/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jive.ExecDev;
import jive.JiveUtils;
import jive3.MainPanel;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;

public abstract class TreePanel
extends JPanel
implements TreeSelectionListener,
MouseListener {
    protected JTree tree;
    protected JScrollPane treeView = null;
    protected DefaultTreeModel treeModel;
    protected TangoNode root;
    protected Database db;
    MainPanel invoker;
    TreePanel self;
    public static final int ACTION_NUMBER = 19;
    public static final int ACTION_RENAME = 0;
    public static final int ACTION_DELETE = 1;
    public static final int ACTION_ADDCLASS = 2;
    public static final int ACTION_TESTADMIN = 3;
    public static final int ACTION_SAVESERVER = 4;
    public static final int ACTION_CLASSWIZ = 5;
    public static final int ACTION_ADDDEVICE = 6;
    public static final int ACTION_DEVICESWIZ = 7;
    public static final int ACTION_MONITORDEV = 8;
    public static final int ACTION_TESTDEV = 9;
    public static final int ACTION_DEFALIAS = 10;
    public static final int ACTION_GOTODEVNODE = 11;
    public static final int ACTION_RESTART = 12;
    public static final int ACTION_DEVICEWIZ = 13;
    public static final int ACTION_GOTOSERVNODE = 14;
    public static final int ACTION_GOTOADMINNODE = 15;
    public static final int ACTION_ADDCLASSATT = 16;
    public static final int ACTION_COPY = 17;
    public static final int ACTION_PASTE = 18;
    private static TangoNode selectedNode;
    static File lastFile;
    private static JPopupMenu actionMenu;
    private static JMenuItem renameMenu;
    private static JMenuItem deleteMenu;
    private static JMenuItem addClassMenu;
    private static JMenuItem testAdminMenu;
    private static JMenuItem saveServerMenu;
    private static JMenuItem classWizMenu;
    private static JMenuItem addDeviceMenu;
    private static JMenuItem devicesWizMenu;
    private static JMenuItem monitorMenu;
    private static JMenuItem testMenu;
    private static JMenuItem aliasMenu;
    private static JMenuItem goToDevMenu;
    private static JMenuItem restartMenu;
    private static JMenuItem deviceWizMenu;
    private static JMenuItem goToServMenu;
    private static JMenuItem goToAdminMenu;
    private static JMenuItem addClassAttMenu;
    private static JMenuItem copyMenu;
    private static JMenuItem pasteMenu;

    abstract TangoNode createRoot();

    public void initTree() {
        this.root = this.createRoot();
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(false);
        this.tree.setCellRenderer(new TangoNodeRenderer());
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.tree.addMouseListener(this);
        this.tree.addTreeSelectionListener(this);
        this.treeView = new JScrollPane(this.tree);
        this.add((Component)this.treeView, "Center");
    }

    public void setDatabase(Database database) {
        this.db = database;
        if (this.treeView != null) {
            this.remove(this.treeView);
            this.treeView = null;
        }
        if (database != null) {
            this.initTree();
        } else {
            this.repaint();
        }
    }

    public void refresh() {
        if (this.treeView == null) {
            return;
        }
        TreePath treePath = this.tree.getSelectionPath();
        this.remove(this.treeView);
        if (this.db != null) {
            this.initTree();
        }
        if (treePath != null) {
            TreePath treePath2 = new TreePath(this.root);
            TangoNode tangoNode = this.root;
            boolean bl = true;
            int n = 1;
            while (bl && n < treePath.getPathCount()) {
                String string = treePath.getPathComponent(n).toString();
                if ((tangoNode = this.searchNode(tangoNode, string)) != null) {
                    treePath2 = treePath2.pathByAddingChild(tangoNode);
                    ++n;
                    continue;
                }
                bl = false;
            }
            this.tree.setSelectionPath(treePath2);
            this.tree.expandPath(treePath2);
            this.tree.makeVisible(treePath2);
            this.tree.scrollPathToVisible(treePath2);
        }
    }

    public void refreshValues() {
        if (this.treeView == null) {
            return;
        }
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            TangoNode[] tangoNodeArray = new TangoNode[treePathArray.length];
            for (int i = 0; i < tangoNodeArray.length; ++i) {
                tangoNodeArray[i] = (TangoNode)treePathArray[i].getLastPathComponent();
            }
            this.invoker.updatePanel(tangoNodeArray);
            if (treePathArray.length == 1) {
                this.tree.scrollPathToVisible(treePathArray[0]);
            }
        } else {
            this.invoker.updatePanel(null);
        }
    }

    public TangoNode searchNode(TangoNode tangoNode, String string) {
        int n = this.treeModel.getChildCount(tangoNode);
        int n2 = 0;
        boolean bl = false;
        TangoNode tangoNode2 = null;
        while (n2 < n && !bl) {
            tangoNode2 = (TangoNode)this.treeModel.getChild(tangoNode, n2);
            bl = tangoNode2.toString().compareToIgnoreCase(string) == 0;
            if (bl) continue;
            ++n2;
        }
        if (bl) {
            return tangoNode2;
        }
        return null;
    }

    public void testDevice(String string) {
        JDialog jDialog = new JDialog((Frame)this.invoker, false);
        jDialog.setTitle("Device Panel [" + string + "]");
        try {
            ExecDev execDev = new ExecDev(string);
            jDialog.setContentPane(execDev);
            JiveUtils.centerDialog(jDialog);
            jDialog.setVisible(true);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    public String getDeviceInfo(String string) {
        String string2 = "";
        try {
            string2 = "- Device Info ----------------------------------------\n\n";
            DbDevImportInfo dbDevImportInfo = this.db.import_device(string);
            string2 = string2 + dbDevImportInfo.toString();
            string2 = string2 + "\n\n- Polling Status -------------------------------------\n\n";
            DeviceProxy deviceProxy = new DeviceProxy(string);
            String[] stringArray = deviceProxy.polling_status();
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = string2 + stringArray[i] + "\n\n";
            }
        }
        catch (DevFailed devFailed) {
            for (int i = 0; i < devFailed.errors.length; ++i) {
                string2 = string2 + "Desc -> " + devFailed.errors[i].desc + "\n";
                string2 = string2 + "Reason -> " + devFailed.errors[i].reason + "\n";
                string2 = string2 + "Origin -> " + devFailed.errors[i].origin + "\n";
            }
        }
        return string2;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.refreshValues();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null && mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 3) {
            this.tree.setSelectionPath(treePath);
            selectedNode = (TangoNode)treePath.getLastPathComponent();
            int[] nArray = selectedNode.getAction();
            if (nArray.length > 0) {
                for (int i = 0; i < 19; ++i) {
                    if (JiveUtils.contains(nArray, i)) {
                        actionMenu.getComponent(i).setVisible(true);
                        continue;
                    }
                    actionMenu.getComponent(i).setVisible(false);
                }
                actionMenu.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    static {
        lastFile = null;
        actionMenu = new JPopupMenu();
        renameMenu = new JMenuItem("Rename");
        actionMenu.add(renameMenu);
        renameMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                selectedNode.execAction(0);
            }
        });
        deleteMenu = new JMenuItem("Delete");
        actionMenu.add(deleteMenu);
        deleteMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                selectedNode.execAction(1);
            }
        });
        addClassMenu = new JMenuItem("Add class");
        actionMenu.add(addClassMenu);
        addClassMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                selectedNode.execAction(2);
            }
        });
        testAdminMenu = new JMenuItem("Test admin server");
        actionMenu.add(testAdminMenu);
        testAdminMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                selectedNode.execAction(3);
            }
        });
        saveServerMenu = new JMenuItem("Save server data");
        actionMenu.add(saveServerMenu);
        saveServerMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                selectedNode.execAction(4);
            }
        });
        classWizMenu = new JMenuItem("Classes wizard");
        actionMenu.add(classWizMenu);
        classWizMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                selectedNode.execAction(5);
            }
        });
        addDeviceMenu = new JMenuItem("Add device");
        actionMenu.add(addDeviceMenu);
        addDeviceMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                selectedNode.execAction(6);
            }
        });
        devicesWizMenu = new JMenuItem("Devices wizard");
        actionMenu.add(devicesWizMenu);
        devicesWizMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                selectedNode.execAction(7);
            }
        });
        monitorMenu = new JMenuItem("Monitor device");
        actionMenu.add(monitorMenu);
        monitorMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                selectedNode.execAction(8);
            }
        });
        testMenu = new JMenuItem("Test device");
        actionMenu.add(testMenu);
        testMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                selectedNode.execAction(9);
            }
        });
        aliasMenu = new JMenuItem("Define device alias");
        actionMenu.add(aliasMenu);
        aliasMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                selectedNode.execAction(10);
            }
        });
        goToDevMenu = new JMenuItem("Go to device node");
        actionMenu.add(goToDevMenu);
        goToDevMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                selectedNode.execAction(11);
            }
        });
        restartMenu = new JMenuItem("Restart device");
        actionMenu.add(restartMenu);
        restartMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                selectedNode.execAction(12);
            }
        });
        deviceWizMenu = new JMenuItem("Device wizard");
        actionMenu.add(deviceWizMenu);
        deviceWizMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                selectedNode.execAction(13);
            }
        });
        goToServMenu = new JMenuItem("Go to server node");
        actionMenu.add(goToServMenu);
        goToServMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                selectedNode.execAction(14);
            }
        });
        goToAdminMenu = new JMenuItem("Go to device admin node");
        actionMenu.add(goToAdminMenu);
        goToAdminMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                selectedNode.execAction(15);
            }
        });
        addClassAttMenu = new JMenuItem("Add attribute");
        actionMenu.add(addClassAttMenu);
        addClassAttMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                selectedNode.execAction(16);
            }
        });
        copyMenu = new JMenuItem("Copy");
        actionMenu.add(copyMenu);
        copyMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                selectedNode.execAction(17);
            }
        });
        pasteMenu = new JMenuItem("Paste");
        actionMenu.add(pasteMenu);
        pasteMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                selectedNode.execAction(18);
            }
        });
    }
}

