/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevSource;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IORdump;
import fr.esrf.TangoDs.Except;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import jive.ClassPanel;
import jive.DevWizard;
import jive.JiveUtils;
import jive.StartingPanel;
import jive.WizardPanel;

class ServerPanel
extends WizardPanel
implements ActionListener {
    private JLabel serverLabel;
    private JComboBox serverCombo;
    private JLabel instanceLabel;
    private JComboBox instanceCombo;
    private static final int DO_NOT_START = 0;
    private static final int START_IT = 1;
    private static final int ALREADY_STARTED = 2;

    public ServerPanel(DevWizard devWizard, String[] stringArray) {
        this.setLayout(null);
        this.serverLabel = new JLabel("Server name");
        this.serverLabel.setFont(DevWizard.wizFont);
        this.serverLabel.setBounds(10, 10, 100, 25);
        this.add(this.serverLabel);
        this.serverCombo = new JComboBox();
        this.serverCombo.setFont(DevWizard.wizFont);
        this.serverCombo.setBounds(120, 10, 140, 25);
        this.add(this.serverCombo);
        if (stringArray != null) {
            this.serverCombo.setEditable(false);
            for (int i = 0; i < stringArray.length; ++i) {
                this.serverCombo.addItem(stringArray[i]);
            }
            this.serverCombo.setSelectedIndex(0);
        } else {
            this.serverCombo.setEditable(true);
            try {
                Database database = ApiUtil.get_db_obj();
                String[] stringArray2 = database.get_server_name_list();
                for (int i = 0; i < stringArray2.length; ++i) {
                    this.serverCombo.addItem(stringArray2[i]);
                }
                this.serverCombo.setSelectedItem(null);
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
            }
        }
        this.serverCombo.addActionListener(this);
        this.instanceLabel = new JLabel("Instance name");
        this.instanceLabel.setFont(DevWizard.wizFont);
        this.instanceLabel.setBounds(10, 40, 100, 25);
        this.add(this.instanceLabel);
        this.instanceCombo = new JComboBox();
        this.instanceCombo.setEditable(true);
        this.instanceCombo.setFont(DevWizard.wizFont);
        this.instanceCombo.setBounds(120, 40, 140, 25);
        this.add(this.instanceCombo);
        this.panelIcon = new ImageIcon(this.getClass().getResource("/jive/server_wz.gif"));
        this.parent = devWizard;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.serverCombo && actionEvent.getActionCommand() == "comboBoxChanged") {
            String string = (String)this.serverCombo.getSelectedItem();
            try {
                Object object2 = this.instanceCombo.getSelectedItem();
                this.instanceCombo.removeAllItems();
                Database database = ApiUtil.get_db_obj();
                String[] stringArray = database.get_instance_name_list(string);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.instanceCombo.addItem(stringArray[i]);
                }
                this.instanceCombo.setSelectedItem(object2);
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
            }
        }
    }

    public String getTitle() {
        return "Server Registration";
    }

    public String getDescription() {
        return "This wizard helps you to install a Tango device. First, you have to enter the \"Server name\" (executable file name) and its \"instance name\".\nTo register the server, click [Next].";
    }

    public boolean getNextState() {
        return true;
    }

    public boolean next() {
        Database database;
        String string = (String)this.serverCombo.getSelectedItem();
        String string2 = (String)this.instanceCombo.getSelectedItem();
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            JiveUtils.showJiveError("Please enter a server and an instance name.");
            return false;
        }
        String string3 = "dserver/" + string + "/" + string2;
        String string4 = string + "/" + string2;
        try {
            database = ApiUtil.get_db_obj();
            if (!this.deviceExists(string3, string4, "DServer")) {
                DbDevInfo dbDevInfo = new DbDevInfo(string3, "DServer", string4);
                database.add_device(dbDevInfo);
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
            return false;
        }
        database = null;
        if (DevWizard.starter != null) {
            database = this.startServer(string4);
            this.removeNextPanel();
            if (database == null) {
                return false;
            }
            this.parent.addPanel(new ClassPanel(this.parent, string4, (DeviceProxy)database));
        } else {
            this.removeNextPanel();
            this.parent.addPanel(new StartingPanel(this.parent, string4));
        }
        return true;
    }

    private int canBeStarted(DeviceProxy deviceProxy, String string, String string2) throws DevFailed {
        String string3 = "dserver/" + string;
        boolean bl = false;
        try {
            deviceProxy.ping();
            bl = true;
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        IORdump iORdump = new IORdump(string3);
        String string4 = iORdump.get_host();
        if (bl) {
            if (string4.startsWith(string2)) {
                JOptionPane.showMessageDialog(this.parent, string + " is alredy running on " + string4, "Jive Message", 2);
                return 2;
            }
            Except.throw_exception((String)"StartServerFailed", (String)(string + " is already running on " + iORdump.get_host()), (String)"DevWizard.startServer()");
        }
        if (string4 != null && !string4.startsWith(string2)) {
            Object[] objectArray = new Object[]{"Continue", "Cancel"};
            if (JOptionPane.showOptionDialog(this.parent, string + " is alredy registred on " + string4, "Warning", -1, 2, null, objectArray, objectArray[0]) != 0) {
                return 0;
            }
        }
        return 1;
    }

    private DeviceProxy startServer(String string) {
        DeviceProxy deviceProxy = null;
        String string2 = "dserver/" + string;
        String string3 = DevWizard.starter.name();
        string3 = string3.substring(string3.lastIndexOf("/") + 1);
        try {
            deviceProxy = new DeviceProxy(string2);
            switch (this.canBeStarted(deviceProxy, string, string3)) {
                case 0: {
                    return null;
                }
                case 2: {
                    return deviceProxy;
                }
            }
            DbDevExportInfo dbDevExportInfo = new DbDevExportInfo(string2, "null", string3, "null");
            ApiUtil.get_db_obj().export_device(dbDevExportInfo);
            ApiUtil.get_db_obj().unexport_device(string2);
            DeviceData deviceData = new DeviceData();
            deviceData.insert(string);
            DevWizard.starter.command_inout("DevStart", deviceData);
            DevWizard.starter.set_source(DevSource.DEV);
            boolean bl = false;
            block7: for (int i = 0; !bl && i < 5; ++i) {
                Thread.sleep(1000L);
                DeviceAttribute deviceAttribute = DevWizard.starter.read_attribute("RunningServers");
                String[] stringArray = deviceAttribute.extractStringArray();
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!stringArray[j].equals(string)) continue;
                    bl = true;
                    deviceProxy = new DeviceProxy(string2);
                    DevWizard.lastServStarted = string;
                    String string4 = string + " is now running on " + string3;
                    JOptionPane.showMessageDialog(this.parent, string4, "Jive Message", 1);
                    continue block7;
                }
            }
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
            JiveUtils.showJiveError("Failed to start " + string + " :\n" + devFailed.errors[0].desc);
            this.parent.setVisible(false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return deviceProxy;
    }
}

