/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import java.util.StringTokenizer;
import java.util.Vector;

public class PolledElement {
    String name = "unknown";
    String type;
    int period = -1;
    int buffer_depth = -1;
    double reading_time = -1.0;
    int last_update = -1;
    int[] real_periods = new int[0];
    DevState state;
    String status;
    private static final String equal = " = ";
    private static final String since = " since ";
    private String[] info;

    public PolledElement(String status) {
        this.status = status;
        this.parsePollingStatus(status);
        this.state = this.period < 0 || this.buffer_depth < 0 || this.reading_time < 0.0 || this.real_periods.length == 0 ? DevState.FAULT : ((double)this.real_periods[0] > 1.5 * (double)this.period || this.reading_time > (double)this.period ? DevState.FAULT : DevState.ON);
    }

    private void parsePollingStatus(String status) {
        Vector<String> lines = new Vector<String>();
        StringTokenizer stk = new StringTokenizer(status, "\n");
        int i = 0;
        while (stk.hasMoreTokens()) {
            String line = stk.nextToken();
            lines.add(line);
            block7 : switch (i) {
                case 0: {
                    int idx = line.indexOf(equal);
                    if (idx > 0) {
                        this.name = line.substring(idx + equal.length());
                    }
                    if (line.indexOf("attribute") > 0) {
                        this.type = "attribute";
                        break;
                    }
                    this.type = "command";
                    break;
                }
                case 1: {
                    int idx = line.indexOf(equal);
                    if (idx <= 0) break;
                    String str = line.substring(idx + equal.length());
                    try {
                        this.period = Integer.parseInt(str);
                    }
                    catch (NumberFormatException e) {}
                    break;
                }
                case 2: {
                    int idx = line.indexOf(equal);
                    if (idx <= 0) break;
                    String str = line.substring(idx + equal.length());
                    try {
                        this.buffer_depth = Integer.parseInt(str);
                    }
                    catch (NumberFormatException e) {}
                    break;
                }
                case 3: {
                    int idx = line.indexOf(equal);
                    if (idx <= 0) break;
                    String str = line.substring(idx + equal.length());
                    try {
                        this.reading_time = Double.parseDouble(str);
                    }
                    catch (NumberFormatException e) {}
                    break;
                }
                case 4: {
                    int idx = line.indexOf(since);
                    if (idx <= 0) break;
                    String str = line.substring(idx + since.length());
                    str = str.substring(0, str.indexOf("mS"));
                    StringTokenizer stk2 = new StringTokenizer(str, " S and ");
                    Vector<String> v = new Vector();
                    while (stk2.hasMoreTokens()) {
                        String s = stk2.nextToken();
                        v.add(s);
                    }
                    switch (v.size()) {
                        case 1: {
                            try {
                                this.last_update = Integer.parseInt((String)v.get(0));
                            }
                            catch (NumberFormatException e) {
                                this.last_update = 1000;
                            }
                            break block7;
                        }
                        case 2: {
                            try {
                                this.last_update = Integer.parseInt((String)v.get(1));
                                this.last_update += 1000 * Integer.parseInt((String)v.get(0));
                            }
                            catch (NumberFormatException e) {
                                this.last_update += 60000;
                            }
                            break block7;
                        }
                    }
                    if (v.size() <= 1) break;
                    try {
                        this.last_update = 60000 * Integer.parseInt((String)v.get(0));
                        this.last_update += Integer.parseInt((String)v.get(3));
                        this.last_update += 1000 * Integer.parseInt((String)v.get(2));
                    }
                    catch (NumberFormatException e) {
                        this.last_update += 60000;
                    }
                    break;
                }
                case 5: {
                    int idx = line.indexOf(equal);
                    if (idx <= 0) break;
                    String str = line.substring(idx + equal.length());
                    StringTokenizer stk2 = new StringTokenizer(str, ", ");
                    Vector<String> v = new Vector<String>();
                    while (stk2.hasMoreTokens()) {
                        v.add(stk2.nextToken());
                    }
                    this.real_periods = new int[v.size()];
                    for (int j = 0; j < v.size(); ++j) {
                        try {
                            this.real_periods[j] = Integer.parseInt((String)v.get(j));
                            continue;
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    break;
                }
            }
            ++i;
        }
        this.info = new String[lines.size()];
        for (i = 0; i < lines.size(); ++i) {
            this.info[i] = (String)lines.get(i);
        }
    }

    public String toString() {
        return this.name;
    }

    public String info() {
        String str = this.type + " " + this.name + ":\t" + this.period + " -> " + this.reading_time;
        str = str + "  (since " + this.last_update + ")\t";
        for (int i = 0; i < this.real_periods.length; ++i) {
            str = str + this.real_periods[i] + ", ";
        }
        str = str + "\t" + ApiUtil.stateName((DevState)this.state);
        return str;
    }

    public String[] getInfo() {
        String[] retStr = new String[5];
        int i = 0;
        retStr[i++] = this.type + "  " + this.name;
        retStr[i++] = "Polling period = " + this.period + "ms";
        retStr[i++] = "Last record takes " + this.reading_time + " ms";
        if (this.info.length > 3) {
            retStr[i++] = this.info[4];
        }
        if (this.info.length > 4) {
            retStr[i] = this.info[5];
        }
        return retStr;
    }
}

