/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.HistoryDialog;
import admin.astor.tools.SubscribedSignal;
import admin.astor.tools.TablePopupMenu;
import app_util.PopupError;
import app_util.PopupMessage;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class EventsTable
extends JDialog {
    public static final int SUBSCRIBE_CHANGE = 0;
    public static final int SUBSCRIBE_PERIODIC = 1;
    public static final int SUBSCRIBE_ARCHIVE = 2;
    public static final String[] strMode = new String[]{"CHANGE", "PERIODIC", "ARCHIVE"};
    public JTable table;
    private DataTableModel model;
    private JScrollPane scrollPane;
    private static String[] col_names = new String[]{"Signal names", "Read Value", "Mode", "Last Time", "Delta Time", "Delta Value", "Received"};
    public static final int NAME = 0;
    public static final int VALUE = 1;
    public static final int MODE = 2;
    public static final int TIME = 3;
    public static final int DT = 4;
    public static final int DV = 5;
    public static final int CNT = 6;
    private static int[] col_width = new int[]{140, 100, 45, 85, 60, 70, 50};
    private Vector signals = new Vector();
    private boolean first = true;
    private TablePopupMenu menu = null;
    private JFrame parent = null;
    private static JFileChooser chooser;
    private static final String ColWidthHeader = "Column_width:";
    private static final String FileHeader = "#\n#\tEventTester :\tevent list\n#\n";
    private JButton cancelBtn;
    private JMenu fileMenu;
    private JMenuBar jMenuBar;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JMenuItem openFile;
    private JMenuItem saveFile;
    private JLabel titleLabel;

    public EventsTable(JFrame parent) throws DevFailed {
        super((Frame)parent, false);
        this.initComponents();
        this.initMyComponents();
        this.titleLabel.setText("TANGO  Event Tester");
        if (parent != null && parent.isVisible()) {
            this.parent = parent;
            Point p = parent.getLocationOnScreen();
            int h = parent.getHeight();
            p.y += h;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension scrsize = toolkit.getScreenSize();
            if (p.y > scrsize.height - this.getHeight() - 20) {
                p.y -= h + this.getHeight();
            }
            this.setLocation(p);
        }
        this.fileMenu.setMnemonic('F');
        this.openFile.setMnemonic('O');
        this.openFile.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.saveFile.setMnemonic('S');
        this.saveFile.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.pack();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.jMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openFile = new JMenuItem();
        this.saveFile = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                EventsTable.this.closeDialog(evt);
            }
        });
        this.cancelBtn.setText("Dismiss");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EventsTable.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.fileMenu.setText("File");
        this.openFile.setText("Open");
        this.openFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EventsTable.this.openFileActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openFile);
        this.saveFile.setText("Save");
        this.saveFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EventsTable.this.saveFileActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveFile);
        this.jMenuBar.add(this.fileMenu);
        this.setJMenuBar(this.jMenuBar);
        this.pack();
    }

    private void openFileActionPerformed(ActionEvent evt) {
        File file;
        if (chooser == null) {
            String homeDir = System.getProperty("EVT_DATA_FILES");
            if (homeDir == null) {
                homeDir = new File("").getAbsolutePath();
            }
            chooser = new JFileChooser(homeDir);
        }
        chooser.setDialogTitle("Open Configuration File");
        chooser.setApproveButtonText("Open");
        if (chooser.showOpenDialog(this) == 0 && (file = chooser.getSelectedFile()) != null && !file.isDirectory()) {
            this.openEventList(file.getAbsolutePath());
        }
    }

    private void saveFileActionPerformed(ActionEvent evt) {
        File file;
        if (this.signals.size() == 0) {
            PopupError.show((Component)this, "No subscription to save");
            return;
        }
        if (chooser == null) {
            String homeDir = System.getProperty("EVT_DATA_FILES");
            if (homeDir == null) {
                homeDir = new File("").getAbsolutePath();
            }
            chooser = new JFileChooser(homeDir);
        }
        chooser.setDialogTitle("Save Configuration");
        chooser.setApproveButtonText("Save");
        if (chooser.showOpenDialog(this) == 0 && (file = chooser.getSelectedFile()) != null && !file.isDirectory()) {
            if (file.exists() && JOptionPane.showConfirmDialog(this, "This File Already Exists !\n\nWould you like to overwrite ?", "information", 0) != 0) {
                return;
            }
            this.saveEventList(file.getAbsolutePath());
        }
    }

    private void saveEventList(String filename) {
        String str = FileHeader;
        for (int i = 0; i < this.signals.size(); ++i) {
            SubscribedSignal sig = (SubscribedSignal)this.signals.get(i);
            str = str + sig.toString() + "\n";
        }
        int[] width = this.getColumnWidth();
        str = str + "#\nColumn_width:\t";
        for (int i = 0; i < width.length; ++i) {
            str = str + " " + width[i];
        }
        try {
            FileOutputStream fidout = new FileOutputStream(filename);
            fidout.write(str.getBytes());
            fidout.close();
        }
        catch (Exception e) {
            PopupError.show((Component)this, e);
        }
    }

    private void openEventList(String filename) {
        String str = "";
        try {
            FileInputStream fid = new FileInputStream(filename);
            int nb = fid.available();
            byte[] inStr = new byte[nb];
            fid.read(inStr);
            str = new String(inStr);
            fid.close();
        }
        catch (Exception e) {
            PopupError.show((Component)this, e);
            return;
        }
        if (!str.startsWith(FileHeader)) {
            PopupError.show((Component)this, "This is not an EventTester Configuration file");
            return;
        }
        str = str.substring(FileHeader.length());
        Vector v = new Vector();
        StringTokenizer stk = new StringTokenizer(str, "\n");
        while (stk.hasMoreTokens()) {
            String line = stk.nextToken();
            if (line.startsWith("#")) continue;
            if (!line.startsWith(ColWidthHeader)) {
                this.createSignalFromLine(line);
                continue;
            }
            this.readColWidthDefinition(line);
        }
        this.setColumnWidth(col_width);
        this.pack();
    }

    private void readColWidthDefinition(String line) {
        StringTokenizer stk = new StringTokenizer(line);
        stk.nextToken();
        col_width = new int[stk.countTokens()];
        int i = 0;
        while (stk.hasMoreTokens()) {
            try {
                String s = stk.nextToken();
                EventsTable.col_width[i] = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                System.out.println("Cannot parse width for column " + i);
                EventsTable.col_width[i] = 50;
            }
            ++i;
        }
    }

    private void createSignalFromLine(String line) {
        StringTokenizer stk = new StringTokenizer(line);
        String name = stk.nextToken();
        String strmode = stk.nextToken().substring(1);
        strmode = strmode.substring(0, strmode.indexOf(93));
        int mode = -1;
        for (int i = 0; i < strMode.length; ++i) {
            if (!strmode.equals(strMode[i])) continue;
            mode = i;
        }
        if (mode == -1) {
            PopupError.show((Component)this, "mode " + strmode + " is unknown !");
            return;
        }
        this.add(name, mode);
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        if (this.parent != null) {
            this.getColumnWidth();
            this.setVisible(false);
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    public void add(String name, int mode) {
        for (int i = 0; i < this.signals.size(); ++i) {
            SubscribedSignal sig = (SubscribedSignal)this.signals.get(i);
            if (!sig.name.toLowerCase().equals(name.toLowerCase()) || sig.mode != mode) continue;
            this.setVisible(true);
            this.table.changeSelection(i, 0, false, false);
            PopupError.show((Component)this, "Event '" + name + "'  already subscribed");
            return;
        }
        SubscribedSignal sig = new SubscribedSignal(name, mode);
        sig.subscribe(this);
        this.signals.add(sig);
        this.setVisible(true);
        this.updateTable();
        Dimension tbsize = this.table.getSize();
        tbsize.height += 40;
        this.scrollPane.setPreferredSize(new Dimension(tbsize));
        this.pack();
    }

    private void buildTitle(ActionEvent evt) {
        String title = "Attribute events";
        String date = SubscribedSignal.getStrDate();
        this.titleLabel.setText(title + " at " + date);
    }

    void updateTable() {
        this.model.fireTableDataChanged();
    }

    private void initMyComponents() throws DevFailed {
        try {
            this.model = new DataTableModel();
            this.table = new JTable(this.model){

                public String getToolTipText(MouseEvent e) {
                    String tip = null;
                    Point p = e.getPoint();
                    int row = this.rowAtPoint(p);
                    int col = this.columnAtPoint(p);
                    int realColumnIndex = this.convertColumnIndexToModel(col);
                    SubscribedSignal signal = (SubscribedSignal)EventsTable.this.signals.get(row);
                    switch (realColumnIndex) {
                        case 0: {
                            tip = signal.name;
                            break;
                        }
                        case 1: {
                            if (signal.except == null) {
                                tip = signal.value;
                                break;
                            }
                            tip = signal.except_str();
                            break;
                        }
                        case 4: {
                            tip = signal.getTimes();
                        }
                    }
                    return tip;
                }
            };
            this.table.setSelectionMode(0);
            this.table.getTableHeader().setFont(new Font("Dialog", 1, 14));
            this.table.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    EventsTable.this.tableActionPerformed(evt);
                }
            });
            this.scrollPane = new JScrollPane(this.table);
            this.scrollPane.setPreferredSize(new Dimension(700, 50));
            this.getContentPane().add((Component)this.scrollPane, "Center");
            if (this.first) {
                int delay = 1000;
                ActionListener taskPerformer = new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        EventsTable.this.buildTitle(evt);
                    }
                };
                new Timer(delay, taskPerformer).start();
                this.first = false;
            }
            this.setColumnWidth(col_width);
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
            Except.throw_exception((String)"INIT_ERROR", (String)e.toString(), (String)"TestEventTable.initMyComponents()");
        }
        this.model.fireTableDataChanged();
    }

    private void tableActionPerformed(MouseEvent evt) {
        if ((evt.getModifiers() & 4) != 0) {
            int row = this.table.rowAtPoint(new Point(evt.getX(), evt.getY()));
            SubscribedSignal signal = (SubscribedSignal)this.signals.get(row);
            if (signal == null) {
                return;
            }
            if (this.menu == null) {
                this.menu = new TablePopupMenu(this);
            }
            this.menu.showMenu(evt, signal);
        }
    }

    void move(SubscribedSignal signal, int direction) {
        int idx = 0;
        for (int i = 0; i < this.signals.size(); ++i) {
            if (!this.signals.get(i).equals(signal)) continue;
            idx = i;
        }
        switch (direction) {
            case 0: {
                if (idx <= 0) break;
                this.signals.remove(signal);
                this.signals.add(idx - 1, signal);
                break;
            }
            case 1: {
                if (idx >= this.signals.size() - 1) break;
                this.signals.remove(signal);
                this.signals.add(idx + 1, signal);
            }
        }
        this.updateTable();
    }

    void displayHistory(SubscribedSignal signal) {
        new HistoryDialog(this, signal).setVisible(true);
    }

    void displayInfo(SubscribedSignal signal) {
        if (signal.except != null) {
            if (signal.except instanceof DevFailed) {
                PopupError.show((Component)this, (DevFailed)((Object)signal.except));
            } else {
                PopupError.show((Component)this, signal.except);
            }
        } else {
            PopupMessage.show((Component)this, signal.status());
        }
    }

    void remove(SubscribedSignal signal) {
        signal.unsubscribe();
        this.signals.remove(signal);
        this.updateTable();
        Dimension tbsize = this.table.getSize();
        tbsize.height += 40;
        this.scrollPane.setPreferredSize(new Dimension(tbsize));
        this.pack();
    }

    public void setColumnWidth(int[] width) {
        Enumeration<TableColumn> cenum = this.table.getColumnModel().getColumns();
        int i = 0;
        while (cenum.hasMoreElements()) {
            TableColumn tc = cenum.nextElement();
            tc.setPreferredWidth(width[i]);
            ++i;
        }
    }

    public int[] getColumnWidth() {
        Enumeration<TableColumn> cenum = this.table.getColumnModel().getColumns();
        Vector<TableColumn> v = new Vector<TableColumn>();
        while (cenum.hasMoreElements()) {
            v.add(cenum.nextElement());
        }
        int[] width = new int[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            TableColumn tc = (TableColumn)v.get(i);
            width[i] = tc.getPreferredWidth();
        }
        return width;
    }

    static void displaySyntax() {
        System.out.println("Syntax:");
        System.out.println("EventsTable -a  <attribute list>");
        System.out.println("EventsTable -f  <file name>");
        System.exit(0);
    }

    public static void main(String[] args) {
        int mode = 2;
        if (args.length > 0 && args[0].equals("-?")) {
            EventsTable.displaySyntax();
        }
        try {
            EventsTable table = new EventsTable(new JFrame());
            if (args.length > 1) {
                if (args[0].equals("-a")) {
                    for (int i = 1; i < args.length; ++i) {
                        table.add(args[i], mode);
                    }
                } else if (args[0].equals("-f")) {
                    table.openEventList(args[1]);
                }
            }
            table.setVisible(true);
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
        }
    }

    public class DataTableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return col_names.length;
        }

        public int getRowCount() {
            return EventsTable.this.signals.size();
        }

        public String getColumnName(int aCol) {
            return col_names[aCol];
        }

        public Object getValueAt(int row, int col) {
            SubscribedSignal sig = (SubscribedSignal)EventsTable.this.signals.get(row);
            switch (col) {
                case 0: {
                    return sig.name;
                }
                case 1: {
                    return sig.value;
                }
                case 2: {
                    return strMode[sig.mode];
                }
                case 3: {
                    return sig.time;
                }
                case 4: {
                    return sig.d_time;
                }
                case 5: {
                    return sig.d_value;
                }
                case 6: {
                    return "" + sig.cnt;
                }
            }
            return "";
        }
    }
}

