/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.HostInfoDialog;
import admin.astor.ManagePollingDialog;
import admin.astor.TangoHost;
import admin.astor.TangoServer;
import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class ServerPopupMenu
extends JPopupMenu
implements AstorDefs {
    private TangoHost host;
    private TangoServer server;
    private JFrame frame;
    private HostInfoDialog parent;
    private static String[] pMenuLabels = new String[]{"Start server", "Restart server", "Set startup level", "Manage Polling", "Configure (Wizard)", "Memorized Attributes", "Server Info", "Class  Info", "Test   Device", "Check  States", "Start daemon", "Standard Error"};
    private static final int OFFSET = 2;
    private static final int START_STOP = 0;
    private static final int RESTART = 1;
    private static final int STARTUP_LEVEL = 2;
    private static final int MANAGE_POLLING = 3;
    private static final int CONFIGURE = 4;
    private static final int MEMO_ATTRIB = 5;
    private static final int SERVER_INFO = 6;
    private static final int CLASS_INFO = 7;
    private static final int TEST_DEVICE = 8;
    private static final int CHECK_STATES = 9;
    private static final int START_DAEMON = 10;
    private static final int STD_ERROR = 11;
    private Point location;

    public ServerPopupMenu(JFrame frame, HostInfoDialog parent, TangoHost host) {
        this.frame = frame;
        this.parent = parent;
        this.host = host;
        this.buildBtnPopupMenu();
    }

    private void buildBtnPopupMenu() {
        JLabel title = new JLabel("Server Control :");
        title.setFont(new Font("Dialog", 1, 16));
        this.add(title);
        this.add(new JPopupMenu.Separator());
        for (int i = 0; i < pMenuLabels.length; ++i) {
            JMenuItem btn = new JMenuItem(pMenuLabels[i]);
            btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ServerPopupMenu.this.serverCmdActionPerformed(evt);
                }
            });
            this.add(btn);
        }
    }

    public void showMenu(MouseEvent evt) {
        Object o = evt.getSource();
        if (!(o instanceof JLabel) || this.isVisible()) {
            this.setVisible(false);
            return;
        }
        JLabel btn = (JLabel)evt.getSource();
        String name = btn.getText();
        JLabel lbl = (JLabel)this.getComponent(0);
        lbl.setText("  " + name + "  :");
        if (name.startsWith("Events")) {
            this.server = null;
            for (int i = 0; i < pMenuLabels.length; ++i) {
                this.getComponent(i + 2).setVisible(false);
            }
            this.getComponent(12).setVisible(true);
            this.getComponent(13).setVisible(false);
            boolean running = this.host.notifyd_state == 3;
            this.getComponent(12).setEnabled(!running);
        } else {
            this.server = this.host.getServer(btn.getText());
            for (int i = 0; i < pMenuLabels.length; ++i) {
                this.getComponent(i + 2).setVisible(true);
            }
            this.getComponent(12).setVisible(false);
            JMenuItem mi = (JMenuItem)this.getComponent(2);
            boolean running = this.server.isRunning();
            if (running) {
                mi.setText("Kill  Server");
            } else {
                mi.setText("Start Server");
            }
            this.getComponent(3).setEnabled(running);
            this.getComponent(5).setEnabled(running);
            this.getComponent(10).setEnabled(running);
            this.getComponent(11).setEnabled(running);
            this.getComponent(6).setEnabled(running);
            this.getComponent(7).setVisible(!running);
        }
        this.location = btn.getLocationOnScreen();
        this.show(btn, evt.getX(), evt.getY());
    }

    private void serverCmdActionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.equals(pMenuLabels[2])) {
            if (this.server.startupLevel(this.parent, this.host.getName(), this.location)) {
                this.parent.updateData();
            }
        } else if (cmd.equals(pMenuLabels[3])) {
            new ManagePollingDialog(this.parent, this.server, this.location).setVisible(true);
        } else if (cmd.equals(pMenuLabels[8])) {
            this.server.testDevice(this.parent, this.location);
        } else if (cmd.equals(pMenuLabels[9])) {
            this.server.checkStates(this.parent, this.location);
        } else if (cmd.equals(pMenuLabels[4])) {
            this.server.configureWithWizard(this.parent);
        } else if (cmd.equals(pMenuLabels[6])) {
            this.server.displayServerInfo(this.parent);
        } else if (cmd.equals(pMenuLabels[5])) {
            this.server.manageMemorizedAttributes(this.parent);
        } else if (cmd.equals(pMenuLabels[7])) {
            this.server.displayClassInfo(this.frame);
        } else if (cmd.equals(pMenuLabels[11])) {
            if (this.server != null) {
                this.host.readStdErrorFile(this.frame, this.server.getName());
            } else {
                this.host.readStdErrorFile(this.frame, "notify_daemon/" + this.host.getName());
            }
        } else if (cmd.equals(pMenuLabels[10])) {
            this.host.startServer(this.parent, "notify_daemon/" + this.host.getName());
        } else if (cmd.equals(pMenuLabels[1])) {
            this.server.restart(this.parent, this.host);
        } else if (this.server.isRunning()) {
            try {
                if (JOptionPane.showConfirmDialog(this.parent, "Are you sure to want to kill " + this.server.getName(), "Confirm Dialog", 0) == 0) {
                    this.host.stopServer(this.server.getName());
                }
            }
            catch (DevFailed e) {
                PopupError.show((Component)this.parent, e);
            }
        } else {
            this.host.startServer(this.parent, this.server.getName());
        }
    }
}

