/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorCmdLine;
import admin.astor.AstorDefs;
import admin.astor.AstorTree;
import admin.astor.AstorUtil;
import admin.astor.CtrlServersDialog;
import admin.astor.DeviceTreeDialog;
import admin.astor.NewStarterDialog;
import admin.astor.OneTool;
import admin.astor.Selector;
import admin.astor.ServerCmdThread;
import admin.astor.TangoHost;
import admin.astor.tools.DevBrowser;
import app_util.PopupError;
import app_util.PopupHtml;
import app_util.PopupMessage;
import app_util.PopupText;
import app_util.TangoWindow;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.TangORBversion;
import fr.esrf.TangoApi.events.EventConsumer;
import fr.esrf.TangoDs.Except;
import fr.esrf.logviewer.Main;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;

public class Astor
extends JFrame
implements AstorDefs {
    private static String revNumber = "Release 4.3.2  -  Mon Jun 26 15:44:04 CEST 2006";
    public AstorTree tree = null;
    private boolean expanded = false;
    private JScrollPane scrowllPane;
    static CtrlServersDialog ctrl_serv_d = null;
    static boolean displayed = false;
    public static DevBrowser dev_browser = null;
    private String tango_host = "";
    static ImageIcon[] state_icons = new ImageIcon[6];
    private int nb_def_tools = 1;
    private Vector app_tools = new Vector();
    private Vector tools_al = new Vector();
    private Selector tango_host_selector = null;
    private Main logviewer = null;
    private static String searched_host = "";
    private JMenuItem aboutBtn;
    private JToggleButton allHostsControledBtn;
    private JMenuItem changeTgHostBtn;
    private JMenu cmdMenu;
    private JMenuItem deviceBrowserBtn;
    private JMenuItem exitBtn;
    private JMenuItem expandBtn;
    private JMenu fileMenu;
    private JMenuItem helpAppliBtn;
    private JMenu helpMenu;
    private JMenuItem helpStarterBtn;
    private JLabel jLabel1;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JMenuItem jiveMenuItem;
    private JMenuItem logviewerMenuItem;
    private JMenuItem newBranchBtn;
    private JMenuItem newHostBtn;
    private JMenuItem principleBtn;
    private JMenuItem refreshBtn;
    private JMenuItem releaseNoteBtn;
    private JMenuItem serversItem;
    private JMenuItem startServersBtn;
    private JMenuItem starterEventsItem;
    private JMenuItem stateIconsBtn;
    private JToggleButton stopHostsControledBtn;
    private JMenuItem stopServersBtn;
    private JMenuItem tangoStatBtn;
    private JMenuItem tangorbBtn;
    private JMenu toolsMenu;
    private JMenu viewMenu;
    private JMenuItem searchHostItem;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public Astor() {
        Astor.state_icons[0] = new ImageIcon(this.getClass().getResource("/app_util/img/greyball.gif"));
        Astor.state_icons[1] = new ImageIcon(this.getClass().getResource("/app_util/img/redball.gif"));
        Astor.state_icons[2] = new ImageIcon(this.getClass().getResource("/app_util/img/orangebal.gif"));
        Astor.state_icons[3] = new ImageIcon(this.getClass().getResource("/app_util/img/greenbal.gif"));
        Astor.state_icons[4] = new ImageIcon(this.getClass().getResource("/app_util/img/blueball.gif"));
        Astor.state_icons[5] = new ImageIcon(this.getClass().getResource("/app_util/img/failed.gif"));
        this.initComponents();
        this.customizeMenu();
        this.setTitle("TANGO Manager - " + revNumber);
        this.buildTree();
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/app_util/img/tango_icon.jpg"));
        this.setIconImage(icon.getImage());
        this.jPanel1.setVisible(AstorUtil.getCtrlBtn());
        this.centerWindow();
        try {
            this.tango_host = ApiUtil.get_db_obj().get_tango_host();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
    }

    public void centerWindow() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension scrsize = toolkit.getScreenSize();
        Dimension appsize = this.getSize();
        Point p = new Point();
        p.x = (scrsize.width - appsize.width) / 2;
        p.y = (scrsize.height - appsize.height) / 2;
        this.setLocation(p);
    }

    private void buildTree() {
        try {
            if (this.tree != null) {
                this.tree.stopThreads();
                this.scrowllPane.remove(this.tree);
                this.remove(this.scrowllPane);
            }
            this.tree = new AstorTree(this, true);
            this.scrowllPane = new JScrollPane();
            this.scrowllPane.setPreferredSize(new Dimension(340, 600));
            this.scrowllPane.setViewportView(this.tree);
            this.getContentPane().add((Component)this.scrowllPane, "Center");
        }
        catch (DevFailed e) {
            PopupError.show((Component)this, e);
        }
        this.expanded = false;
        this.pack();
    }

    private void customizeMenu() {
        this.fileMenu.setMnemonic('F');
        this.exitBtn.setMnemonic('E');
        this.exitBtn.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.changeTgHostBtn.setMnemonic('T');
        this.changeTgHostBtn.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.viewMenu.setMnemonic('V');
        this.newBranchBtn.setMnemonic('N');
        this.newBranchBtn.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.refreshBtn.setMnemonic('U');
        this.refreshBtn.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.deviceBrowserBtn.setMnemonic('B');
        this.deviceBrowserBtn.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.expandBtn.setMnemonic('E');
        this.expandBtn.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.toolsMenu.setMnemonic('T');
        this.jiveMenuItem.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.logviewerMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.cmdMenu.setMnemonic('C');
        this.newHostBtn.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.serversItem.setVisible(false);
        this.serversItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.searchHostItem = new JMenuItem();
        this.searchHostItem.setText("Find Host by Name");
        this.searchHostItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.searchHostItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add((Component)this.searchHostItem, 0);
        this.nb_def_tools = this.toolsMenu.getItemCount();
        this.buildToolsItems();
        this.expandBtn.setVisible(false);
    }

    private void buildToolsItems() {
        for (int i = this.toolsMenu.getItemCount(); i > this.nb_def_tools; --i) {
            JMenuItem mi = this.toolsMenu.getItem(i - 1);
            mi.removeActionListener((ActionListener)this.tools_al.get(i - this.nb_def_tools - 1));
            this.toolsMenu.remove(i - 1);
        }
        this.app_tools.clear();
        this.tools_al.clear();
        String[] str_tools = AstorUtil.getTools();
        if (str_tools != null) {
            for (int i = 0; i < str_tools.length; i += 2) {
                OneTool t = new OneTool(str_tools[i], str_tools[i + 1]);
                this.app_tools.add(t);
                JMenuItem mi = new JMenuItem();
                mi.setText(t.name);
                ActionListener al = new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        Astor.this.toolsItemActionPerformed(evt);
                    }
                };
                mi.addActionListener(al);
                this.tools_al.add(al);
                this.toolsMenu.add(mi);
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.allHostsControledBtn = new JToggleButton();
        this.stopHostsControledBtn = new JToggleButton();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.changeTgHostBtn = new JMenuItem();
        this.exitBtn = new JMenuItem();
        this.viewMenu = new JMenu();
        this.deviceBrowserBtn = new JMenuItem();
        this.refreshBtn = new JMenuItem();
        this.expandBtn = new JMenuItem();
        this.cmdMenu = new JMenu();
        this.startServersBtn = new JMenuItem();
        this.stopServersBtn = new JMenuItem();
        this.newHostBtn = new JMenuItem();
        this.newBranchBtn = new JMenuItem();
        this.toolsMenu = new JMenu();
        this.serversItem = new JMenuItem();
        this.tangoStatBtn = new JMenuItem();
        this.jiveMenuItem = new JMenuItem();
        this.logviewerMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.principleBtn = new JMenuItem();
        this.helpAppliBtn = new JMenuItem();
        this.helpStarterBtn = new JMenuItem();
        this.stateIconsBtn = new JMenuItem();
        this.tangorbBtn = new JMenuItem();
        this.starterEventsItem = new JMenuItem();
        this.releaseNoteBtn = new JMenuItem();
        this.aboutBtn = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Astor.this.exitForm(evt);
            }
        });
        this.jLabel1.setText("Control  :   ");
        this.jPanel1.add(this.jLabel1);
        this.allHostsControledBtn.setFont(new Font("Dialog", 1, 10));
        this.allHostsControledBtn.setText("  All  hosts  ");
        this.allHostsControledBtn.setToolTipText("Start Control on All Hosts");
        this.allHostsControledBtn.setBorder(new BevelBorder(0));
        this.allHostsControledBtn.setMargin(new Insets(2, 2, 2, 2));
        this.allHostsControledBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.allHostsControledBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.allHostsControledBtn);
        this.stopHostsControledBtn.setFont(new Font("Dialog", 1, 10));
        this.stopHostsControledBtn.setText("    None   ");
        this.stopHostsControledBtn.setToolTipText("Stop Control on All Hosts");
        this.stopHostsControledBtn.setBorder(new BevelBorder(0));
        this.stopHostsControledBtn.setMargin(new Insets(2, 2, 2, 2));
        this.stopHostsControledBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.stopHostsControledBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.stopHostsControledBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.fileMenu.setText("File");
        this.changeTgHostBtn.setText("Change Tango Host");
        this.changeTgHostBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.changeTgHostBtnActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.changeTgHostBtn);
        this.exitBtn.setText("Exit");
        this.exitBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.exitBtnActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitBtn);
        this.jMenuBar1.add(this.fileMenu);
        this.viewMenu.setText("View");
        this.deviceBrowserBtn.setText("Device Browser");
        this.deviceBrowserBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.deviceBrowserBtnActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.deviceBrowserBtn);
        this.refreshBtn.setText("Update Tree from database");
        this.refreshBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.refreshBtnActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.refreshBtn);
        this.expandBtn.setText("Expand Tree");
        this.expandBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.expandBtnActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.expandBtn);
        this.jMenuBar1.add(this.viewMenu);
        this.cmdMenu.setText("Command");
        this.startServersBtn.setText("Start All Controlled Servers");
        this.startServersBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.startServersBtnActionPerformed(evt);
            }
        });
        this.cmdMenu.add(this.startServersBtn);
        this.stopServersBtn.setText("Stop All Controlled Servers");
        this.stopServersBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.stopServersBtnActionPerformed(evt);
            }
        });
        this.cmdMenu.add(this.stopServersBtn);
        this.newHostBtn.setText("Add a New Host");
        this.newHostBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.newHostBtnActionPerformed(evt);
            }
        });
        this.cmdMenu.add(this.newHostBtn);
        this.newBranchBtn.setText("Add a New Branch");
        this.newBranchBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.newBranchBtnActionPerformed(evt);
            }
        });
        this.cmdMenu.add(this.newBranchBtn);
        this.jMenuBar1.add(this.cmdMenu);
        this.toolsMenu.setText("Tools");
        this.serversItem.setText("Controlled Servers");
        this.serversItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.serversItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.serversItem);
        this.tangoStatBtn.setText("Ctrl System Info");
        this.tangoStatBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.tangoStatBtnActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.tangoStatBtn);
        this.jiveMenuItem.setText("Jive");
        this.jiveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.jiveMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.jiveMenuItem);
        this.logviewerMenuItem.setText("LogViewer");
        this.logviewerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.logviewerMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.logviewerMenuItem);
        this.jMenuBar1.add(this.toolsMenu);
        this.helpMenu.setText("Help");
        this.principleBtn.setText("Principle");
        this.principleBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.principleBtn);
        this.helpAppliBtn.setText("Application");
        this.helpAppliBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpAppliBtn);
        this.helpStarterBtn.setText("Starter Server");
        this.helpStarterBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpStarterBtn);
        this.stateIconsBtn.setText("State Icons");
        this.stateIconsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.stateIconsBtn);
        this.tangorbBtn.setText("TangORB revision");
        this.tangorbBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.tangorbBtn);
        this.starterEventsItem.setText("Hosts Controlled on Events");
        this.starterEventsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.starterEventsItem);
        this.releaseNoteBtn.setText("Release Note");
        this.releaseNoteBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.releaseNoteBtn);
        this.aboutBtn.setText("About");
        this.aboutBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutBtn);
        this.jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void changeTgHostBtnActionPerformed(ActionEvent evt) {
        try {
            String tmp_tgh;
            if (this.tango_host_selector == null) {
                String[] known_tgh = AstorUtil.getKnownTangoHosts();
                this.tango_host_selector = new Selector((JFrame)this, "Tango Host  (e.g.  hal:2001)", known_tgh, this.tango_host);
                ATKGraphicsUtils.centerDialog((Dialog)this.tango_host_selector);
            }
            if ((tmp_tgh = this.tango_host_selector.showDialog()) == null || tmp_tgh.length() == 0) {
                return;
            }
            String[] tgh_arr = tmp_tgh.split(":");
            if (tgh_arr.length != 2) {
                PopupError.show((Component)this, "Input syntax error\n" + tmp_tgh + "\n is not a valid TANGO_HOST");
                return;
            }
            ApiUtil.get_db_obj((String)tgh_arr[0], (String)tgh_arr[1]);
            if (this.tango_host.equals(tmp_tgh)) {
                return;
            }
            this.tango_host = tmp_tgh;
            this.tree.hostDialogs.close();
            this.tree.hostDialogs.clear();
            if (dev_browser != null) {
                dev_browser.setVisible(false);
                dev_browser = null;
            }
            AstorUtil.setTangoHost(this.tango_host);
            ApiUtil.change_db_obj((String)tgh_arr[0], (String)tgh_arr[1]);
            EventConsumer.create().updateDatabaseObject();
            this.buildTree();
            this.buildToolsItems();
        }
        catch (DevFailed e) {
            PopupError.show((Component)this, e);
        }
    }

    private void logviewerMenuItemActionPerformed(ActionEvent evt) {
        if (this.logviewer == null) {
            this.logviewer = new Main((JFrame)this);
        }
        this.logviewer.setVisible(true);
        this.logviewer.toFront();
    }

    private void jiveMenuItemActionPerformed(ActionEvent evt) {
        this.tree.displayDbaseInfo();
    }

    private void searchHostItemActionPerformed(ActionEvent evt) {
        String hostname = (String)JOptionPane.showInputDialog(this, "Host's Name ?", "Input Dialog", 1, null, null, searched_host);
        if (hostname != null) {
            this.tree.setSelectionPath(hostname);
            this.tree.displayHostInfo();
            searched_host = hostname;
        }
    }

    private void tangoStatBtnActionPerformed(ActionEvent evt) {
        new DeviceTreeDialog(this);
    }

    private void serversItemActionPerformed(ActionEvent evt) {
        if (ctrl_serv_d != null) {
            ctrl_serv_d.doClose();
        }
        ctrl_serv_d = new CtrlServersDialog(this, this.tree.hosts);
    }

    private void toolsItemActionPerformed(ActionEvent evt) {
        String name = evt.getActionCommand();
        for (int i = 0; i < this.app_tools.size(); ++i) {
            OneTool app = (OneTool)this.app_tools.elementAt(i);
            if (!app.name.equals(name)) continue;
            try {
                System.out.println("Starting " + app.classname);
                if (app.jframe == null) {
                    Class<?> cl = Class.forName(app.classname);
                    Class[] param = new Class[]{class$javax$swing$JFrame == null ? Astor.class$("javax.swing.JFrame") : class$javax$swing$JFrame};
                    Constructor<?> contructor = cl.getConstructor(param);
                    Object[] jframe = new JFrame[]{this};
                    JFrame jf = (JFrame)contructor.newInstance(jframe);
                    app.setJFrame(jf);
                }
                app.jframe.setVisible(true);
                continue;
            }
            catch (Exception e) {
                PopupError.show((Component)this, e);
            }
        }
    }

    void removeHost(String hostname) {
        if (JOptionPane.showConfirmDialog(this, "Are you sure to want to remove " + hostname, "Confirm Dialog", 0) != 0) {
            return;
        }
        String servname = "Starter/" + hostname;
        String devadmin = "dserver/" + servname;
        String devname = "tango/admin/" + hostname;
        try {
            DeviceProxy dev = new DeviceProxy(devname);
            dev.delete_property("StarteDsPath");
            dev.delete_property("HostCollection");
            dev.delete_property("HostUsage");
            dev.delete_property("\u00dcseEvents");
            Database db = ApiUtil.get_db_obj((String)AstorUtil.getTangoHost());
            db.delete_server(servname);
            db.delete_device(devname);
            db.delete_device(devadmin);
            JOptionPane.showMessageDialog(this, hostname + " has been removed !", "Command Done", 1);
        }
        catch (DevFailed e) {
            PopupError.show((Component)this, e);
        }
        this.buildTree();
    }

    private void newHostBtnActionPerformed(ActionEvent evt) {
        this.addNewHost(null);
    }

    void addNewHost(TangoHost h) {
        NewStarterDialog dialog = new NewStarterDialog(this, h, AstorTree.collec_names, this.tree.hosts, true);
        dialog.setVisible(true);
        if (dialog.getValue() == 0) {
            this.buildTree();
        }
    }

    void editHostProperties(TangoHost h) {
        NewStarterDialog dialog = new NewStarterDialog(this, h, AstorTree.collec_names, this.tree.hosts, false);
        dialog.setVisible(true);
    }

    private void stopServersBtnActionPerformed(ActionEvent evt) {
        new ServerCmdThread(this, this.tree.hosts, 1).start();
    }

    private void startServersBtnActionPerformed(ActionEvent evt) {
        new ServerCmdThread(this, this.tree.hosts, 0).start();
    }

    private void newBranchBtnActionPerformed(ActionEvent evt) {
        String branch_name = (String)JOptionPane.showInputDialog(this, "New Branch Name", "Input Dialog", 1, null, null, "");
        if (branch_name != null) {
            this.tree.addBranch(branch_name);
        }
    }

    private void helpActionPerformed(ActionEvent evt) {
        String item = evt.getActionCommand();
        if (item.equals(this.principleBtn.getText())) {
            PopupMessage.showImage((Component)this, (String)null, "/app_util/img/principle.gif");
        } else if (item.equals(this.helpAppliBtn.getText())) {
            new PopupHtml(this).show(AstorUtil.getAppliHelpURL());
        } else if (item.equals(this.helpStarterBtn.getText())) {
            new PopupHtml(this).show(AstorUtil.getStarterHelpURL());
        } else if (item.equals(this.stateIconsBtn.getText())) {
            PopupMessage.showImage((Component)this, (String)null, "/app_util/img/astor_state_icons.jpg");
        } else if (item.equals(this.releaseNoteBtn.getText())) {
            new PopupHtml(this).show("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<HEAD>\n<Title> Release Note </Title>\n</HEAD>\n<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" VLINK=\"#7F00FF\" ALINK=\"#FF0000\">\n<P><!-------TITLE------></P>\n<Center>\t<h2>Astor Release Note</h2>\n\t(Generated Mon Jun 26 15:44:04 CEST 2006)</Center><Br>\n<li><b>Astor-4.3.2:</b><Br>\n&nbsp; &nbsp; Bug fixed in miscellaneous host collection.<Br>\n<li><b>Astor-4.3.1:</b><Br>\n&nbsp; &nbsp; Moving state added for collectionx.<Br>\n&nbsp; &nbsp; &nbsp; &nbsp; In StartAll command a sleep(500) has been added between two hosts.<Br>\n<li><b>Astor-4.3.0:</b><Br>\n&nbsp; &nbsp; Moving state added for startup phase.<Br>\n<li><b>Astor-4.2.3:</b><Br>\n&nbsp; &nbsp; Host info panel modified to use icons.<Br>\n<li><b>Astor-4.2.2:</b><Br>\n&nbsp; &nbsp; Backward compatibilty for jive fixed.<Br>\n<li><b>Astor-4.2.1:</b><Br>\n&nbsp; &nbsp; Icons have been changed.<Br>\n&nbsp; &nbsp; &nbsp; &nbsp; Some minor changes.<Br>\n<li><b>Astor-4.2.0:</b><Br>\n&nbsp; &nbsp; Polling profiler added.<Br>\n<li><b>Astor-4.1.4:</b><Br>\n&nbsp; &nbsp; Open/Save menu added on event tester window.<Br>\n<li><b>Astor-4.1.3:</b><Br>\n&nbsp; &nbsp; History added on event management.<Br>\n&nbsp; &nbsp; &nbsp; &nbsp; The maximum servers displayed in horizontal on HostInfoDialog<Br>\n&nbsp; &nbsp; &nbsp; &nbsp; window has been set to 5.<Br>\n<li><b>Astor-4.1.2:</b><Br>\n&nbsp; &nbsp; Bug fixed in Device browser in member device name.<Br>\n<li><b>Astor-4.1.1:</b><Br>\n&nbsp; &nbsp; Change TANGO_HOST added (needs TangORB-4.7.7 or later).<Br>\n<li><b>Astor-4.1.0:</b><Br>\n&nbsp; &nbsp; DevBrowser and MkStarter utilities added.<Br>\n<li><b>Astor-4.0.9:</b><Br>\n&nbsp; &nbsp; Minor changes for EventTester compatibility<Br>\n<li><b>Astor-4.0.8:</b><Br>\n&nbsp; &nbsp; Screen position modified for dialogs.<Br>\n<li><b>Astor-4.0.7:</b><Br>\n&nbsp; &nbsp; Search if host already exist before creation.<Br>\n<li><b>Astor-4.0.6:</b><Br>\n&nbsp; &nbsp; Search by host name added.<Br>\n<li><b>Astor-4.0.5:</b><Br>\n&nbsp; &nbsp; Can change memorized attribute value.<Br>\n<li><b>Astor-4.0.4:</b><Br>\n&nbsp; &nbsp; Bug in server architecture fixed.<Br>\n<li><b>Astor-4.0.3:</b><Br>\n&nbsp; &nbsp; Minor changes, RemoteCmd property added.<Br>\n<li><b>Astor-4.0.2:</b><Br>\n&nbsp; &nbsp; Server architecture display addded.<Br>\n<li><b>Astor-4.0.1:</b><Br>\n&nbsp; &nbsp; DevWizard calls addded.<Br>\n<li><b>Astor-4.0.0:</b><Br>\n&nbsp; &nbsp; Possibility to controle two database servers added.<Br>\n</Body>\n</Html>\n");
        } else if (item.equals(this.tangorbBtn.getText())) {
            TangORBversion tangorb;
            try {
                tangorb = new TangORBversion();
            }
            catch (Exception e) {
                PopupError.show((Component)this, e);
                return;
            }
            String message = tangorb.jarfile + ":\n\n" + tangorb;
            PopupText txt = new PopupText((Frame)this, true);
            txt.setFont(new Font("Courier", 1, 14));
            AstorUtil.centerDialog((JDialog)txt, this);
            txt.show(message);
        } else if (item.equals(this.aboutBtn.getText())) {
            String message = "           Astor  (Tango Manager) \n\nThis programme is used to control, start and stop\n           the TANGO device servers. \n\n" + revNumber + "\n\n" + "Pascal Verdier - Software Engineering Group - ESRF";
            PopupMessage.showImage((Component)this, message, "/app_util/img/tango_icon.jpg");
        } else if (item.equals(this.starterEventsItem.getText())) {
            String title;
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < this.tree.hosts.length; ++i) {
                if (!this.tree.hosts[i].use_events) continue;
                v.add(this.tree.hosts[i].getName());
            }
            String[] hostnames = null;
            if (v.size() == 0) {
                title = "There is no host controlled on events !";
            } else if (v.size() == this.tree.hosts.length) {
                title = "All hosts are controlled on events !";
            } else {
                title = "On " + this.tree.hosts.length + " hosts,\n" + v.size() + "  are controlled on events :";
                hostnames = new String[v.size()];
                for (int i = 0; i < v.size(); ++i) {
                    hostnames[i] = (String)v.elementAt(i);
                }
            }
            if (hostnames == null) {
                PopupMessage.show((Component)this, title);
            } else {
                new PopupText((Frame)this, true).show(title, hostnames, 300, 400);
            }
        } else {
            PopupMessage.show((Component)this, "Not implemented yet !");
        }
    }

    private void stopHostsControledBtnActionPerformed(ActionEvent evt) {
        if (this.tree != null) {
            for (int i = 0; i < this.tree.hosts.length; ++i) {
                this.tree.hosts[i].do_polling = false;
                this.tree.hostDialogs.close(this.tree.hosts[i]);
            }
            this.stopHostsControledBtn.setSelected(false);
        }
    }

    private void allHostsControledBtnActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.tree.hosts.length; ++i) {
            this.tree.hosts[i].do_polling = true;
        }
        this.allHostsControledBtn.setSelected(false);
    }

    private void expandBtnActionPerformed(ActionEvent evt) {
        this.expanded = !this.expanded;
        this.tree.expand(this.expanded);
        if (this.expanded) {
            this.expandBtn.setText("Collapse Tree");
        } else {
            this.expandBtn.setText("Expand Tree");
        }
    }

    private void deviceBrowserBtnActionPerformed(ActionEvent evt) {
        if (dev_browser == null) {
            dev_browser = new DevBrowser(this);
        }
        dev_browser.setVisible(true);
    }

    private void refreshBtnActionPerformed(ActionEvent evt) {
        this.buildTree();
    }

    private void exitBtnActionPerformed(ActionEvent evt) {
        this.doExit();
    }

    private void exitForm(WindowEvent evt) {
        this.doExit();
    }

    private void stopThreads() {
        System.out.println("Astor exiting....");
        if (this.tree != null && this.tree.hosts != null) {
            for (int i = 0; i < this.tree.hosts.length; ++i) {
                this.tree.hosts[i].stopThread();
                if (!this.tree.hosts[i].use_events) continue;
                try {
                    Thread.sleep(20L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        System.out.println(" ");
    }

    public void doExit() {
        if (dev_browser != null && dev_browser.isVisible()) {
            this.setVisible(false);
        } else {
            this.setVisible(false);
            this.stopThreads();
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            try {
                new AstorCmdLine(args);
            }
            catch (DevFailed e) {
                Except.print_exception((Exception)((Object)e));
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
            System.exit(0);
        }
        long t0 = System.currentTimeMillis();
        try {
            TangoWindow tw = new TangoWindow("ASTOR  Tango Manager");
            tw.setVisible(true);
            Astor astor = new Astor();
            astor.setVisible(true);
            displayed = true;
            tw.setVisible(false);
        }
        catch (InternalError e) {
            System.out.println(e);
        }
        long t1 = System.currentTimeMillis();
        System.out.println("Build  GUI :" + (t1 - t0) + " ms");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

