/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import explorer.AttributeTableModel;
import explorer.ColumnListener;
import explorer.EntityTableModel;
import fr.esrf.tangoatk.widget.util.HelpWindow;
import fr.esrf.tangoatk.widget.util.IApplicable;
import fr.esrf.tangoatk.widget.util.IHelpful;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ViewDialog
extends JPanel
implements IApplicable,
IHelpful,
ColumnListener {
    List checkBoxes = new Vector();
    EntityTableModel tableModel;
    String helpUrl = "/explorer/html/ViewDialogHelp.html";

    public ViewDialog(EntityTableModel tableModel) {
        this.tableModel = tableModel;
        tableModel.addColumnListener(this);
        this.initComponents(tableModel);
    }

    public URL getHelpUrl() {
        return this.getClass().getResource(this.helpUrl);
    }

    public void apply() {
        boolean[] visible = new boolean[this.checkBoxes.size()];
        String[] names = new String[this.checkBoxes.size()];
        int i = 0;
        while (i < this.checkBoxes.size()) {
            JCheckBox tmp = (JCheckBox)this.checkBoxes.get(i);
            visible[i] = tmp.isSelected();
            names[i] = tmp.getText();
            ++i;
        }
        this.tableModel.setVisible(names, visible);
    }

    public void cancel() {
        this.getRootPane().getParent().setVisible(false);
    }

    public void ok() {
        this.getRootPane().getParent().setVisible(false);
        this.apply();
    }

    public void help() {
        HelpWindow.getInstance().showUrl(this.getClass().getResource(this.helpUrl));
    }

    public void columnsChanged() {
        int i = 0;
        while (i < this.checkBoxes.size()) {
            JCheckBox tmp = (JCheckBox)this.checkBoxes.get(i);
            tmp.setSelected(this.tableModel.isVisible(tmp.getText()));
            ++i;
        }
    }

    protected void initComponents(EntityTableModel tableModel) {
        HelpWindow.getInstance().addCategory("Dialogs", "View dialog", this.getClass().getResource(this.helpUrl));
        List properties = tableModel.getAllColumnNames();
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        int i = 0;
        while (i < properties.size()) {
            String name = (String)properties.get(i);
            if (name != AttributeTableModel.NAME && name != "Command") {
                JCheckBox tmp = new JCheckBox(name, tableModel.isVisible(name));
                this.checkBoxes.add(tmp);
                this.add((Component)tmp, constraints);
                ++constraints.gridy;
                if (constraints.gridy == 4) {
                    constraints.gridy = 0;
                    ++constraints.gridx;
                }
            }
            ++i;
        }
        constraints.gridwidth = constraints.gridx + 1;
        constraints.gridy = 5;
        constraints.gridx = 0;
        constraints.weightx = 1.0;
    }

    public static void main(String[] args) {
        new ViewDialog(new AttributeTableModel(null, null)).show();
    }
}

