/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDBrowserPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDValueProgram;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class JDValuePanel
extends JPanel
implements ActionListener {
    private JCheckBox userValueCheckBox;
    private JLabel initValueLabel;
    private JTextField initValueText;
    private JLabel minValueLabel;
    private JTextField minValueText;
    private JLabel maxValueLabel;
    private JTextField maxValueText;
    private JButton applyValueBtn;
    private JLabel userBehaviorLabel;
    private JComboBox userBehaviorCombo;
    private JCheckBox affectBackgroundCheckBox;
    private JButton affectBackgroundBtn;
    private JCheckBox affectForegroundCheckBox;
    private JButton affectForegroundBtn;
    private JCheckBox affectVisibleCheckBox;
    private JButton affectVisibleBtn;
    private JCheckBox affectInvertShadowCheckBox;
    private JButton affectInvertShadowBtn;
    private JCheckBox affectXPosCheckBox;
    private JButton affectXPosBtn;
    private JCheckBox affectYPosCheckBox;
    private JButton affectYPosBtn;
    private JCheckBox affectXScaleCheckBox;
    private JButton affectXScaleBtn;
    private JCheckBox affectYScaleCheckBox;
    private JButton affectYScaleBtn;
    private JDObject[] allObjects = null;
    private JDrawEditor invoker;
    private JDBrowserPanel invoker2;
    private boolean isUpdating = false;

    public JDValuePanel(JDObject[] jDObjectArray, JDrawEditor jDrawEditor, JDBrowserPanel jDBrowserPanel) {
        this.invoker = jDrawEditor;
        this.invoker2 = jDBrowserPanel;
        this.setForeground(JDUtils.labelColor);
        this.setFont(JDUtils.labelFont);
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel jPanel = new JPanel(null);
        jPanel.setBorder(JDUtils.createTitleBorder("Object value"));
        jPanel.setBounds(5, 5, 370, 145);
        this.userValueCheckBox = JDUtils.createCheckBox("Enable user interaction (Play mode)", this);
        this.userValueCheckBox.setBounds(5, 20, 330, 25);
        jPanel.add(this.userValueCheckBox);
        this.initValueLabel = JDUtils.createLabel("Init");
        this.initValueLabel.setBounds(10, 50, 30, 25);
        jPanel.add(this.initValueLabel);
        this.initValueText = new JTextField();
        this.initValueText.setMargin(JDUtils.zMargin);
        this.initValueText.setEditable(true);
        this.initValueText.setFont(JDUtils.labelFont);
        this.initValueText.setBounds(45, 50, 40, 24);
        this.initValueText.addActionListener(this);
        jPanel.add(this.initValueText);
        this.minValueLabel = JDUtils.createLabel("Min");
        this.minValueLabel.setBounds(90, 50, 30, 25);
        jPanel.add(this.minValueLabel);
        this.minValueText = new JTextField();
        this.minValueText.setMargin(JDUtils.zMargin);
        this.minValueText.setEditable(true);
        this.minValueText.setFont(JDUtils.labelFont);
        this.minValueText.setBounds(125, 50, 40, 24);
        this.minValueText.addActionListener(this);
        jPanel.add(this.minValueText);
        this.maxValueLabel = JDUtils.createLabel("Max");
        this.maxValueLabel.setBounds(170, 50, 30, 25);
        jPanel.add(this.maxValueLabel);
        this.maxValueText = new JTextField();
        this.maxValueText.setMargin(JDUtils.zMargin);
        this.maxValueText.setEditable(true);
        this.maxValueText.setFont(JDUtils.labelFont);
        this.maxValueText.setBounds(205, 50, 40, 24);
        this.maxValueText.addActionListener(this);
        jPanel.add(this.maxValueText);
        this.applyValueBtn = new JButton("Apply values");
        this.applyValueBtn.setFont(JDUtils.labelFont);
        this.applyValueBtn.setMargin(new Insets(0, 0, 0, 0));
        this.applyValueBtn.setForeground(Color.BLACK);
        this.applyValueBtn.addActionListener(this);
        this.applyValueBtn.setBounds(255, 50, 105, 25);
        jPanel.add(this.applyValueBtn);
        this.userBehaviorLabel = JDUtils.createLabel("Object value change when nouse");
        this.userBehaviorLabel.setBounds(10, 83, 300, 20);
        jPanel.add(this.userBehaviorLabel);
        this.userBehaviorCombo = new JComboBox();
        this.userBehaviorCombo.setFont(JDUtils.labelFont);
        this.userBehaviorCombo.addItem("Clicked (value=value+1)");
        this.userBehaviorCombo.addItem("Pressed,Released (value=value+1)");
        this.userBehaviorCombo.addItem("XDragged (value=vMin,X=0 to vMax,X=W)");
        this.userBehaviorCombo.addItem("XDragged (value=vMax,X=0 to vMin,X=W)");
        this.userBehaviorCombo.addItem("YDragged (value=vMin,Y=0 to vMax,Y=H)");
        this.userBehaviorCombo.addItem("YDragged (value=vMax,Y=0 to vMin,Y=H)");
        this.userBehaviorCombo.addActionListener(this);
        this.userBehaviorCombo.setBounds(10, 105, 350, 25);
        jPanel.add(this.userBehaviorCombo);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel(null);
        jPanel2.setBorder(JDUtils.createTitleBorder("Object value affetcs"));
        int n = 20;
        this.affectBackgroundCheckBox = JDUtils.createCheckBox("Backgound color", this);
        this.affectBackgroundCheckBox.setBounds(5, n, 140, 25);
        jPanel2.add(this.affectBackgroundCheckBox);
        this.affectBackgroundBtn = JDUtils.createSetButton(this);
        this.affectBackgroundBtn.setBounds(150, n, 25, 25);
        jPanel2.add(this.affectBackgroundBtn);
        this.affectForegroundCheckBox = JDUtils.createCheckBox("Foregound color", this);
        this.affectForegroundCheckBox.setBounds(5, n += 25, 140, 25);
        jPanel2.add(this.affectForegroundCheckBox);
        this.affectForegroundBtn = JDUtils.createSetButton(this);
        this.affectForegroundBtn.setBounds(150, n, 25, 25);
        jPanel2.add(this.affectForegroundBtn);
        this.affectVisibleCheckBox = JDUtils.createCheckBox("Visibilty", this);
        this.affectVisibleCheckBox.setBounds(5, n += 25, 140, 25);
        jPanel2.add(this.affectVisibleCheckBox);
        this.affectVisibleBtn = JDUtils.createSetButton(this);
        this.affectVisibleBtn.setBounds(150, n, 25, 25);
        jPanel2.add(this.affectVisibleBtn);
        this.affectInvertShadowCheckBox = JDUtils.createCheckBox("Inverse shadow", this);
        this.affectInvertShadowCheckBox.setBounds(5, n += 25, 140, 25);
        jPanel2.add(this.affectInvertShadowCheckBox);
        this.affectInvertShadowBtn = JDUtils.createSetButton(this);
        this.affectInvertShadowBtn.setBounds(150, n, 25, 25);
        jPanel2.add(this.affectInvertShadowBtn);
        n = 20;
        this.affectXPosCheckBox = JDUtils.createCheckBox("Horizontal position", this);
        this.affectXPosCheckBox.setBounds(190, n, 140, 25);
        jPanel2.add(this.affectXPosCheckBox);
        this.affectXPosBtn = JDUtils.createSetButton(this);
        this.affectXPosBtn.setBounds(335, n, 25, 25);
        jPanel2.add(this.affectXPosBtn);
        this.affectYPosCheckBox = JDUtils.createCheckBox("Vertical position", this);
        this.affectYPosCheckBox.setBounds(190, n += 25, 140, 25);
        jPanel2.add(this.affectYPosCheckBox);
        this.affectYPosBtn = JDUtils.createSetButton(this);
        this.affectYPosBtn.setBounds(335, n, 25, 25);
        jPanel2.add(this.affectYPosBtn);
        this.affectXScaleCheckBox = JDUtils.createCheckBox("Horizontal scale", this);
        this.affectXScaleCheckBox.setBounds(190, n += 25, 140, 25);
        jPanel2.add(this.affectXScaleCheckBox);
        this.affectXScaleBtn = JDUtils.createSetButton(this);
        this.affectXScaleBtn.setBounds(335, n, 25, 25);
        jPanel2.add(this.affectXScaleBtn);
        this.affectYScaleCheckBox = JDUtils.createCheckBox("Vertical scale", this);
        this.affectYScaleCheckBox.setBounds(190, n += 25, 140, 25);
        jPanel2.add(this.affectYScaleCheckBox);
        this.affectYScaleBtn = JDUtils.createSetButton(this);
        this.affectYScaleBtn.setBounds(335, n, 25, 25);
        jPanel2.add(this.affectYScaleBtn);
        this.add(jPanel2);
        jPanel2.setBounds(5, 155, 370, (n += 25) + 10);
        this.updatePanel(jDObjectArray);
    }

    public void updatePanel(JDObject[] jDObjectArray) {
        this.allObjects = jDObjectArray;
        this.isUpdating = true;
        if (jDObjectArray == null || jDObjectArray.length <= 0) {
            this.minValueText.setText("");
            this.maxValueText.setText("");
            this.initValueText.setText("");
            this.userValueCheckBox.setSelected(false);
            this.userBehaviorCombo.setSelectedIndex(-1);
            this.userBehaviorCombo.setEnabled(false);
            this.affectBackgroundCheckBox.setSelected(false);
            this.affectBackgroundBtn.setEnabled(false);
            this.affectForegroundCheckBox.setSelected(false);
            this.affectForegroundBtn.setEnabled(false);
            this.affectVisibleCheckBox.setSelected(false);
            this.affectVisibleBtn.setEnabled(false);
            this.affectInvertShadowCheckBox.setSelected(false);
            this.affectInvertShadowBtn.setEnabled(false);
            this.affectInvertShadowCheckBox.setSelected(false);
            this.affectInvertShadowBtn.setEnabled(false);
            this.affectXPosCheckBox.setSelected(false);
            this.affectXPosBtn.setEnabled(false);
            this.affectYPosCheckBox.setSelected(false);
            this.affectYPosBtn.setEnabled(false);
            this.affectXScaleCheckBox.setEnabled(false);
            this.affectXScaleBtn.setEnabled(false);
            this.affectYScaleCheckBox.setEnabled(false);
            this.affectYScaleBtn.setEnabled(false);
        } else {
            this.refreshControls();
        }
        this.isUpdating = false;
    }

    private void refreshControls() {
        if (this.allObjects == null) {
            return;
        }
        this.isUpdating = true;
        this.minValueText.setText(Integer.toString(this.allObjects[0].getMinValue()));
        this.minValueText.setCaretPosition(0);
        this.maxValueText.setText(Integer.toString(this.allObjects[0].getMaxValue()));
        this.maxValueText.setCaretPosition(0);
        this.initValueText.setText(Integer.toString(this.allObjects[0].getInitValue()));
        this.initValueText.setCaretPosition(0);
        boolean bl = this.allObjects[0].isInteractive();
        this.userValueCheckBox.setSelected(bl);
        this.userBehaviorCombo.setSelectedIndex(this.allObjects[0].getValueChangeMode());
        this.userBehaviorCombo.setEnabled(bl);
        this.affectBackgroundCheckBox.setSelected(this.allObjects[0].hasBackgroundMapper());
        this.affectBackgroundBtn.setEnabled(this.allObjects[0].hasBackgroundMapper());
        this.affectForegroundCheckBox.setSelected(this.allObjects[0].hasForegroundMapper());
        this.affectForegroundBtn.setEnabled(this.allObjects[0].hasForegroundMapper());
        this.affectVisibleCheckBox.setSelected(this.allObjects[0].hasVisibilityMapper());
        this.affectVisibleBtn.setEnabled(this.allObjects[0].hasVisibilityMapper());
        this.affectInvertShadowCheckBox.setSelected(this.allObjects[0].hasInvertShadowMapper());
        this.affectInvertShadowBtn.setEnabled(this.allObjects[0].hasInvertShadowMapper());
        this.affectInvertShadowCheckBox.setSelected(this.allObjects[0].hasInvertShadowMapper());
        this.affectInvertShadowBtn.setEnabled(this.allObjects[0].hasInvertShadowMapper());
        this.affectXPosCheckBox.setSelected(this.allObjects[0].hasHTranslationMapper());
        this.affectXPosBtn.setEnabled(this.allObjects[0].hasHTranslationMapper());
        this.affectYPosCheckBox.setSelected(this.allObjects[0].hasVTranslationMapper());
        this.affectYPosBtn.setEnabled(this.allObjects[0].hasVTranslationMapper());
        this.affectXScaleCheckBox.setEnabled(false);
        this.affectXScaleBtn.setEnabled(false);
        this.affectYScaleCheckBox.setEnabled(false);
        this.affectYScaleBtn.setEnabled(false);
        this.isUpdating = false;
    }

    private void editBackgroundMapper() {
        JDValueProgram jDValueProgram = JDUtils.showValueMappingDialog(this, this.allObjects, "Background color", 2, this.allObjects[0].getBackgroundMapper());
        if (jDValueProgram != null) {
            this.setBackgroundMapper(jDValueProgram);
        } else {
            this.refreshControls();
        }
    }

    private void setBackgroundMapper(JDValueProgram jDValueProgram) {
        if (jDValueProgram == null) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setBackgroundMapper(null);
            }
        } else {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setBackgroundMapper(jDValueProgram.copy());
            }
        }
        this.invoker.setNeedToSave(true, "Change background program");
        if (this.invoker2 != null) {
            this.invoker2.updateNode();
        }
        this.refreshControls();
    }

    private void editForegroundMapper() {
        JDValueProgram jDValueProgram = JDUtils.showValueMappingDialog(this, this.allObjects, "Foreground color", 2, this.allObjects[0].getForegroundMapper());
        if (jDValueProgram != null) {
            this.setForegroundMapper(jDValueProgram);
        } else {
            this.refreshControls();
        }
    }

    private void setForegroundMapper(JDValueProgram jDValueProgram) {
        if (jDValueProgram == null) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setForegroundMapper(null);
            }
        } else {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setForegroundMapper(jDValueProgram.copy());
            }
        }
        this.invoker.setNeedToSave(true, "Change foreground program");
        if (this.invoker2 != null) {
            this.invoker2.updateNode();
        }
        this.refreshControls();
    }

    private void editVisibilityMapper() {
        JDValueProgram jDValueProgram = JDUtils.showValueMappingDialog(this, this.allObjects, "Visibility", 3, this.allObjects[0].getVisibilityMapper());
        if (jDValueProgram != null) {
            this.setVisibilityMapper(jDValueProgram);
        } else {
            this.refreshControls();
        }
    }

    private void setVisibilityMapper(JDValueProgram jDValueProgram) {
        if (jDValueProgram == null) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setVisibilityMapper(null);
            }
        } else {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setVisibilityMapper(jDValueProgram.copy());
            }
        }
        this.invoker.setNeedToSave(true, "Change visibility program");
        if (this.invoker2 != null) {
            this.invoker2.updateNode();
        }
        this.refreshControls();
    }

    private void editInvertShadowMapper() {
        JDValueProgram jDValueProgram = JDUtils.showValueMappingDialog(this, this.allObjects, "Invert shadow", 3, this.allObjects[0].getInvertShadowMapper());
        if (jDValueProgram != null) {
            this.setInvertShadowMapper(jDValueProgram);
        } else {
            this.refreshControls();
        }
    }

    private void setInvertShadowMapper(JDValueProgram jDValueProgram) {
        if (jDValueProgram == null) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setInvertShadowMapper(null);
            }
        } else {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setInvertShadowMapper(jDValueProgram.copy());
            }
        }
        this.invoker.setNeedToSave(true, "Change shadow program");
        if (this.invoker2 != null) {
            this.invoker2.updateNode();
        }
        this.refreshControls();
    }

    private void editHTranslationMapper() {
        JDValueProgram jDValueProgram = JDUtils.showValueMappingDialog(this, this.allObjects, "Horizontal Translation", 1, this.allObjects[0].getHTranslationMapper());
        if (jDValueProgram != null) {
            this.setHTranslationMapper(jDValueProgram);
        } else {
            this.refreshControls();
        }
    }

    private void setHTranslationMapper(JDValueProgram jDValueProgram) {
        if (jDValueProgram == null) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setHTranslationMapper(null);
            }
        } else {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setHTranslationMapper(jDValueProgram.copy());
            }
        }
        this.invoker.setNeedToSave(true, "Change htranslation program");
        if (this.invoker2 != null) {
            this.invoker2.updateNode();
        }
        this.refreshControls();
    }

    private void editVTranslationMapper() {
        JDValueProgram jDValueProgram = JDUtils.showValueMappingDialog(this, this.allObjects, "Vertical Translation", 1, this.allObjects[0].getVTranslationMapper());
        if (jDValueProgram != null) {
            this.setVTranslationMapper(jDValueProgram);
        } else {
            this.refreshControls();
        }
    }

    private void setVTranslationMapper(JDValueProgram jDValueProgram) {
        if (jDValueProgram == null) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setVTranslationMapper(null);
            }
        } else {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setVTranslationMapper(jDValueProgram.copy());
            }
        }
        this.invoker.setNeedToSave(true, "Change vtranslation program");
        if (this.invoker2 != null) {
            this.invoker2.updateNode();
        }
        this.refreshControls();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.minValueText) {
            try {
                int n = Integer.parseInt(this.minValueText.getText());
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setMinValue(n);
                }
                this.invoker.setNeedToSave(true, "Change min value");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Invalid syntax for min value");
            }
            this.refreshControls();
        } else if (object == this.maxValueText) {
            try {
                int n = Integer.parseInt(this.maxValueText.getText());
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setMaxValue(n);
                }
                this.invoker.setNeedToSave(true, "Change max value");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Invalid syntax for max value");
            }
            this.refreshControls();
        } else if (object == this.initValueText) {
            try {
                int n = Integer.parseInt(this.initValueText.getText());
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setInitValue(n);
                }
                this.invoker.setNeedToSave(true, "Change init value");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Invalid syntax for init value");
            }
            this.refreshControls();
        } else if (object == this.applyValueBtn) {
            try {
                int n = Integer.parseInt(this.minValueText.getText());
                int n2 = Integer.parseInt(this.maxValueText.getText());
                int n3 = Integer.parseInt(this.initValueText.getText());
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setMinValue(n);
                    this.allObjects[i].setMaxValue(n2);
                    this.allObjects[i].setInitValue(n3);
                }
                this.invoker.setNeedToSave(true, "Change value range");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "One or more value are incorrect");
            }
            this.refreshControls();
        } else if (object == this.userValueCheckBox) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setInteractive(this.userValueCheckBox.isSelected());
            }
            this.invoker.setNeedToSave(true, "Change interactive flag");
            if (this.invoker2 != null) {
                this.invoker2.updateNode();
            }
            this.refreshControls();
        } else if (object == this.userBehaviorCombo) {
            int n = this.userBehaviorCombo.getSelectedIndex();
            if (n >= 0) {
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setValueChangeMode(n);
                }
                this.invoker.setNeedToSave(true, "Change interactive behavior");
            }
        } else if (object == this.affectBackgroundBtn) {
            this.editBackgroundMapper();
        } else if (object == this.affectBackgroundCheckBox) {
            if (this.allObjects[0].hasBackgroundMapper()) {
                this.setBackgroundMapper(null);
            } else {
                this.editBackgroundMapper();
            }
        } else if (object == this.affectForegroundBtn) {
            this.editForegroundMapper();
        } else if (object == this.affectForegroundCheckBox) {
            if (this.allObjects[0].hasForegroundMapper()) {
                this.setForegroundMapper(null);
            } else {
                this.editForegroundMapper();
            }
        } else if (object == this.affectVisibleBtn) {
            this.editVisibilityMapper();
        } else if (object == this.affectVisibleCheckBox) {
            if (this.allObjects[0].hasVisibilityMapper()) {
                this.setVisibilityMapper(null);
            } else {
                this.editVisibilityMapper();
            }
        } else if (object == this.affectInvertShadowBtn) {
            this.editInvertShadowMapper();
        } else if (object == this.affectInvertShadowCheckBox) {
            if (this.allObjects[0].hasInvertShadowMapper()) {
                this.setInvertShadowMapper(null);
            } else {
                this.editInvertShadowMapper();
            }
        } else if (object == this.affectXPosBtn) {
            this.editHTranslationMapper();
        } else if (object == this.affectXPosCheckBox) {
            if (this.allObjects[0].hasHTranslationMapper()) {
                this.setHTranslationMapper(null);
            } else {
                this.editHTranslationMapper();
            }
        } else if (object == this.affectYPosBtn) {
            this.editVTranslationMapper();
        } else if (object == this.affectYPosCheckBox) {
            if (this.allObjects[0].hasVTranslationMapper()) {
                this.setVTranslationMapper(null);
            } else {
                this.editVTranslationMapper();
            }
        }
    }
}

