/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.widget.util.EntityNode;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.Node;

class MemberNode
extends Node {
    private String domain;
    private String family;
    private String member;

    MemberNode(int n, String string, String string2, String string3) {
        this.mode = n;
        this.domain = string;
        this.family = string2;
        this.member = string3;
    }

    void populateNode() throws DevFailed {
        if (!this.isLeaf()) {
            String string = this.domain + "/" + this.family + "/" + this.member;
            try {
                Device device = DeviceFactory.getInstance().getDevice(string);
                switch (this.mode) {
                    case 1: {
                        String[] stringArray = device.get_attribute_list();
                        for (int i = 0; i < stringArray.length; ++i) {
                            this.add(new EntityNode(this.mode, stringArray[i]));
                        }
                        break;
                    }
                    case 3: {
                        AttributeInfo[] attributeInfoArray = device.get_attribute_config();
                        for (int i = 0; i < attributeInfoArray.length; ++i) {
                            if (attributeInfoArray[i].data_format.value() != 0) continue;
                            this.add(new EntityNode(this.mode, attributeInfoArray[i].name));
                        }
                        break;
                    }
                    case 2: {
                        CommandInfo[] commandInfoArray = device.command_list_query();
                        for (int i = 0; i < commandInfoArray.length; ++i) {
                            this.add(new EntityNode(this.mode, commandInfoArray[i].cmd_name));
                        }
                        break;
                    }
                }
            }
            catch (ConnectionException connectionException) {
                ErrorPane.showErrorMessage(null, string, (ATKException)connectionException);
            }
        }
    }

    public boolean isLeaf() {
        return this.mode == 0;
    }

    public String toString() {
        return this.member;
    }
}

