/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.image;

import com.braju.format.Format;
import fr.esrf.tangoatk.widget.util.JTableRow;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class LineProfilerViewer
extends JFrame
implements IJLChartListener,
ActionListener {
    JPanel cfgPanel;
    JLChart theGraph;
    JLDataView theDataY;
    JTableRow theTable = null;
    Font panelFont;
    JCheckBox tableCheck;
    JLabel minLabel;
    JTextField minText;
    JLabel maxLabel;
    JTextField maxText;
    JLabel avgLabel;
    JTextField avgText;
    JLabel stdLabel;
    JTextField stdText;
    static String[] colName = new String[]{"Index", "Value"};
    static String[][] emptyStr = new String[][]{{"", ""}};

    public LineProfilerViewer() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.panelFont = new Font("Dialog", 0, 11);
        this.cfgPanel = new JPanel();
        this.cfgPanel.setLayout(null);
        this.cfgPanel.setPreferredSize(new Dimension(0, 25));
        container.add((Component)this.cfgPanel, "South");
        this.tableCheck = new JCheckBox("View table");
        this.tableCheck.setSelected(false);
        this.tableCheck.setFont(this.panelFont);
        this.tableCheck.setBounds(5, 3, 80, 20);
        this.tableCheck.addActionListener(this);
        this.cfgPanel.add(this.tableCheck);
        this.minLabel = new JLabel("Min");
        this.minLabel.setFont(this.panelFont);
        this.minLabel.setHorizontalAlignment(4);
        this.minLabel.setBounds(85, 3, 30, 20);
        this.cfgPanel.add(this.minLabel);
        this.minText = new JTextField("");
        this.minText.setMargin(new Insets(0, 0, 0, 0));
        this.minText.setFont(this.panelFont);
        this.minText.setBounds(120, 3, 60, 20);
        this.cfgPanel.add(this.minText);
        this.maxLabel = new JLabel("Max");
        this.maxLabel.setFont(this.panelFont);
        this.maxLabel.setHorizontalAlignment(4);
        this.maxLabel.setBounds(180, 3, 30, 20);
        this.cfgPanel.add(this.maxLabel);
        this.maxText = new JTextField("");
        this.maxText.setMargin(new Insets(0, 0, 0, 0));
        this.maxText.setFont(this.panelFont);
        this.maxText.setBounds(215, 3, 60, 20);
        this.cfgPanel.add(this.maxText);
        this.avgLabel = new JLabel("Avg");
        this.avgLabel.setFont(this.panelFont);
        this.avgLabel.setHorizontalAlignment(4);
        this.avgLabel.setBounds(275, 3, 30, 20);
        this.cfgPanel.add(this.avgLabel);
        this.avgText = new JTextField("");
        this.avgText.setMargin(new Insets(0, 0, 0, 0));
        this.avgText.setFont(this.panelFont);
        this.avgText.setBounds(310, 3, 60, 20);
        this.cfgPanel.add(this.avgText);
        this.stdLabel = new JLabel("Std");
        this.stdLabel.setFont(this.panelFont);
        this.stdLabel.setHorizontalAlignment(4);
        this.stdLabel.setBounds(370, 3, 30, 20);
        this.cfgPanel.add(this.stdLabel);
        this.stdText = new JTextField("");
        this.stdText.setMargin(new Insets(0, 0, 0, 0));
        this.stdText.setFont(this.panelFont);
        this.stdText.setBounds(405, 3, 60, 20);
        this.cfgPanel.add(this.stdText);
        this.theGraph = new JLChart();
        this.theGraph.setBorder(new EtchedBorder());
        this.theGraph.setChartBackground(new Color(160, 160, 160));
        this.theGraph.getXAxis().setAutoScale(true);
        this.theGraph.getXAxis().setAnnotation(2);
        this.theGraph.getXAxis().setGridVisible(true);
        this.theGraph.getXAxis().setLabelFormat(3);
        this.theDataY = new JLDataView();
        this.theGraph.getY1Axis().setAutoScale(true);
        this.theGraph.getY1Axis().addDataView(this.theDataY);
        this.theGraph.getY1Axis().setGridVisible(true);
        this.theGraph.setPreferredSize(new Dimension(640, 480));
        this.theGraph.setMinimumSize(new Dimension(640, 480));
        this.theGraph.setHeaderFont(new Font("Dialog", 1, 18));
        this.theGraph.setJLChartListener(this);
        container.add((Component)this.theGraph, "Center");
        this.theTable = new JTableRow();
        this.theTable.setPreferredSize(new Dimension(170, 0));
        this.theTable.setVisible(false);
        container.add((Component)this.theTable, "East");
        this.pack();
    }

    public void setLineProfileMode() {
        this.setTitle("[profile] ImageViewer");
        this.theGraph.setHeader("Line profile");
        this.theGraph.getXAxis().setName("Pixel index");
        this.theGraph.getY1Axis().setName("Value");
        this.theDataY.setName("Pixel value");
        if (this.theGraph.isZoomed()) {
            this.theGraph.exitZoom();
        }
    }

    public void setHistogramMode() {
        this.setTitle("[Histogram] ImageViewer");
        this.theGraph.setHeader("Histogram");
        this.theGraph.getXAxis().setName("Pixel value");
        this.theGraph.getY1Axis().setName("Number");
        this.theDataY.setName("pixel number");
        if (this.theGraph.isZoomed()) {
            this.theGraph.exitZoom();
        }
    }

    private void refreshTable() {
        if (this.theTable.isVisible()) {
            Object[][] objectArray;
            LineProfilerViewer.colName[0] = this.theGraph.getXAxis().getName();
            LineProfilerViewer.colName[1] = this.theGraph.getY1Axis().getName();
            if (this.theDataY.getDataLength() > 0) {
                objectArray = new String[this.theDataY.getDataLength()][2];
                DataList dataList = this.theDataY.getData();
                for (int i = 0; i < this.theDataY.getDataLength(); ++i) {
                    objectArray[i][0] = Integer.toString((int)dataList.x);
                    objectArray[i][1] = Double.toString(dataList.y);
                    dataList = dataList.next;
                }
            } else {
                objectArray = emptyStr;
            }
            this.theTable.setData(objectArray, colName);
        }
    }

    public void setData(double[] dArray) {
        this.setData(dArray, 0);
    }

    public void setData(double[] dArray, int n) {
        this.theDataY.reset();
        if (dArray != null) {
            int n2;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = dArray.length;
            for (n2 = 0; n2 < dArray.length; ++n2) {
                this.theDataY.add(n2 + n, dArray[n2]);
                d += dArray[n2];
            }
            d3 = d / d5;
            for (n2 = 0; n2 < dArray.length; ++n2) {
                d2 += (dArray[n2] - d3) * (dArray[n2] - d3);
            }
            d4 = Math.sqrt(d2 / d5);
            this.minText.setText(Double.toString(this.theDataY.getMinimum()));
            this.maxText.setText(Double.toString(this.theDataY.getMaximum()));
            Double d6 = new Double(d3);
            Double d7 = new Double(d4);
            this.avgText.setText(Format.sprintf((String)"%.2f", (Object[])new Double[]{d6}));
            this.stdText.setText(Format.sprintf((String)"%.2f", (Object[])new Double[]{d7}));
        } else {
            this.minText.setText("");
            this.maxText.setText("");
            this.avgText.setText("");
            this.stdText.setText("");
        }
        this.theGraph.repaint();
        this.refreshTable();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.tableCheck) {
            this.theTable.setVisible(this.tableCheck.isSelected());
            this.refreshTable();
            JPanel jPanel = (JPanel)this.getContentPane();
            jPanel.revalidate();
        }
    }

    public String[] clickOnChart(JLChartEvent jLChartEvent) {
        String[] stringArray = new String[]{this.theGraph.getXAxis().getName() + " = " + jLChartEvent.getTransformedXValue(), this.theDataY.getName() + " = " + jLChartEvent.getTransformedYValue()};
        return stringArray;
    }

    public static void main(String[] stringArray) {
        LineProfilerViewer lineProfilerViewer = new LineProfilerViewer();
        lineProfilerViewer.setDefaultCloseOperation(3);
        lineProfilerViewer.setVisible(true);
    }
}

