/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.command;

import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.command.InvalidCommand;
import fr.esrf.tangoatk.core.command.VoidVoidCommand;
import fr.esrf.tangoatk.widget.command.AnyCommandViewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class CommandComboViewer
extends JPanel {
    JFrame argFrame = null;
    AnyCommandViewer acv = null;
    private CommandList commandList;
    private JComboBox commands;
    boolean borderVisble;
    boolean infoButtonVisible;
    boolean cancelButtonVisible;
    boolean deviceButtonVisible;
    boolean descriptionVisible;

    public CommandComboViewer() {
        this.initComponents();
    }

    private void initComponents() {
        this.commands = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.commands.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CommandComboViewer.this.commandsActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.add((Component)this.commands, gridBagConstraints);
    }

    private void commandsActionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        ICommand iCommand = (ICommand)jComboBox.getSelectedItem();
        if (iCommand instanceof InvalidCommand) {
            JOptionPane.showMessageDialog(this, iCommand.getName() + " is not supported. It probably takes an array as input.", "Error", 1);
            return;
        }
        if (iCommand instanceof VoidVoidCommand) {
            iCommand.execute();
            return;
        }
        if (this.acv == null) {
            this.acv = new AnyCommandViewer();
            this.argFrame = new JFrame();
            this.argFrame.getContentPane().add(this.acv);
        }
        this.acv.initialize(iCommand);
        this.acv.setDeviceButtonVisible(this.deviceButtonVisible);
        this.acv.setDescriptionVisible(this.descriptionVisible);
        this.acv.setInfoButtonVisible(this.infoButtonVisible);
        this.acv.setBorder(null);
        this.acv.setInputVisible(true);
        if (!iCommand.takesInput()) {
            iCommand.execute();
        }
        this.argFrame.setTitle(iCommand.getName());
        this.argFrame.pack();
        this.argFrame.show();
    }

    public boolean isBorderVisible() {
        return this.borderVisble;
    }

    public void setBorderVisible(boolean bl) {
        this.borderVisble = bl;
    }

    public boolean isInfoButtonVisible() {
        return this.infoButtonVisible;
    }

    public void setInfoButtonVisible(boolean bl) {
        this.infoButtonVisible = bl;
    }

    public boolean isCancelButtonVisible() {
        return this.cancelButtonVisible;
    }

    public void setCancelButtonVisible(boolean bl) {
        this.cancelButtonVisible = bl;
    }

    public boolean isDeviceButtonVisible() {
        return this.deviceButtonVisible;
    }

    public void setDeviceButtonVisible(boolean bl) {
        this.deviceButtonVisible = bl;
    }

    public boolean isDescriptionVisible() {
        return this.descriptionVisible;
    }

    public void setDescriptionVisible(boolean bl) {
        this.descriptionVisible = bl;
    }

    public void setModel(CommandList commandList) {
        this.commandList = commandList;
        this.commands.setModel(commandList);
    }

    public CommandList getModel() {
        return this.commandList;
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.commands == null) {
            return;
        }
        this.commands.setForeground(color);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.commands == null) {
            return;
        }
        this.commands.setBackground(color);
    }

    public void setFont(Font font) {
        if (this.commands == null) {
            return;
        }
        this.commands.setFont(font);
    }

    public Font getFont() {
        if (this.commands == null) {
            return super.getFont();
        }
        return this.commands.getFont();
    }

    public static void main(String[] stringArray) throws Exception {
        CommandList commandList = new CommandList();
        CommandComboViewer commandComboViewer = new CommandComboViewer();
        commandList.add("eas/test-api/1/*");
        commandComboViewer.setModel(commandList);
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(commandComboViewer);
        jFrame.pack();
        jFrame.show();
    }
}

