/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class NumberScalarStateViewer
extends JLabel
implements INumberScalarListener {
    private INumberScalar model = null;

    public NumberScalarStateViewer() {
        this.initComponents();
    }

    private void initComponents() {
        this.setFont(new Font("Dialog", 0, 12));
        this.setPreferredSize(new Dimension(20, 20));
        this.setMinimumSize(new Dimension(20, 20));
        this.setOpaque(true);
    }

    public static String getStringState(int n) {
        switch (n) {
            case 0: {
                return "ON";
            }
            case 1: {
                return "OFF";
            }
            case 2: {
                return "CLOSE";
            }
            case 3: {
                return "OPEN";
            }
            case 4: {
                return "INSERT";
            }
            case 5: {
                return "EXTRACT";
            }
            case 6: {
                return "MOVING";
            }
            case 7: {
                return "STANDBY";
            }
            case 8: {
                return "FAULT";
            }
            case 9: {
                return "INIT";
            }
            case 10: {
                return "RUNNING";
            }
            case 11: {
                return "ALARM";
            }
            case 12: {
                return "DISABLE";
            }
        }
        return "UNKNOWN";
    }

    public INumberScalar getModel() {
        return this.model;
    }

    public void setModel(INumberScalar iNumberScalar) {
        if (this.model != null) {
            this.model.removeNumberScalarListener((INumberScalarListener)this);
        }
        this.model = iNumberScalar;
        if (this.model != null) {
            this.model.addNumberScalarListener((INumberScalarListener)this);
            this.setToolTipText(this.model.getName());
        }
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        int n = (int)numberScalarEvent.getValue();
        String string = NumberScalarStateViewer.getStringState(n);
        this.setBackground(ATKConstant.getColor4State(string));
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        NumberScalarStateViewer numberScalarStateViewer = new NumberScalarStateViewer();
        try {
            INumberScalar iNumberScalar = (INumberScalar)attributeList.add("id14/cryospy/eh3/IcingStatus");
            numberScalarStateViewer.setModel(iNumberScalar);
        }
        catch (Exception exception) {
            System.out.println("caught exception : " + exception.getMessage());
            System.exit(-1);
        }
        attributeList.startRefresher();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(numberScalarStateViewer);
        jFrame.pack();
        jFrame.show();
    }
}

