/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.widget.attribute.NumberScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.NumberScalarWheelEditor;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import fr.esrf.tangoatk.widget.properties.LabelViewer;
import fr.esrf.tangoatk.widget.util.JAutoScrolledText;
import fr.esrf.tangoatk.widget.util.JAutoScrolledTextListener;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class NumberScalarListViewer
extends JPanel
implements JAutoScrolledTextListener {
    public static final String DEFAULT_SETTER = "WheelEditor";
    public static final String COMBO_SETTER = "ComboEditor";
    private Vector listModel = null;
    private Vector nsLabels = null;
    private Vector nsViewers = null;
    private Vector nsSetters = null;
    private Vector nsPropButtons = null;
    private SimplePropertyFrame propFrame = new SimplePropertyFrame();
    private Font theFont = new Font("Dialog", 0, 14);
    private boolean labelVisible = true;
    private boolean setterVisible = true;
    private boolean propertyButtonVisible = true;
    private boolean propertyListEditable = true;
    private boolean unitVisible = true;
    private String setterType = "WheelEditor";
    private Color arrowColor = null;

    public NumberScalarListViewer() {
        this.setLayout(new GridBagLayout());
        this.setVisible(false);
    }

    public void setModel(AttributeList attributeList) {
        if (attributeList == null) {
            if (this.listModel != null) {
                this.removeComponents();
            }
            return;
        }
        if (this.listModel != null) {
            return;
        }
        int n = attributeList.getSize();
        if (n <= 0) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Object object = attributeList.getElementAt(i);
            if (!(object instanceof INumberScalar)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        this.initComponents(attributeList);
        this.setVisible(true);
    }

    private void removeComponents() {
        Object var3_1 = null;
        INumberScalar iNumberScalar = null;
        LabelViewer labelViewer = null;
        SimpleScalarViewer simpleScalarViewer = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        Object var9_7 = null;
        this.propFrame = null;
        this.propFrame = new SimplePropertyFrame();
        int n = this.listModel.size();
        for (int i = 0; i < n; ++i) {
            try {
                var3_1 = this.listModel.get(i);
                iNumberScalar = var3_1 instanceof INumberScalar ? (INumberScalar)var3_1 : null;
                if (iNumberScalar == null) continue;
                var3_1 = this.nsLabels.get(i);
                if (var3_1 instanceof LabelViewer) {
                    labelViewer = var3_1;
                    labelViewer.setModel(null);
                }
                if ((var3_1 = this.nsViewers.get(i)) instanceof SimpleScalarViewer) {
                    simpleScalarViewer = var3_1;
                    simpleScalarViewer.clearModel();
                }
                if ((var3_1 = this.nsSetters.get(i)) instanceof NumberScalarWheelEditor) {
                    numberScalarWheelEditor = var3_1;
                    if (!iNumberScalar.isWritable()) continue;
                    numberScalarWheelEditor.setModel(null);
                    continue;
                }
                if (!(var3_1 instanceof NumberScalarComboEditor)) continue;
                numberScalarComboEditor = var3_1;
                if (!iNumberScalar.isWritable()) continue;
                numberScalarComboEditor.setNumberModel(null);
                continue;
            }
            catch (Exception exception) {
                System.out.println("NumberScalarListViewer : setTheFont : Caught exception  " + exception.getMessage());
            }
        }
        this.nsLabels.removeAllElements();
        this.nsViewers.removeAllElements();
        this.nsSetters.removeAllElements();
        this.nsPropButtons.removeAllElements();
        this.listModel.removeAllElements();
        this.removeAll();
        this.listModel = null;
        this.nsLabels = null;
        this.nsViewers = null;
        this.nsSetters = null;
        this.nsPropButtons = null;
    }

    public Font getTheFont() {
        return this.theFont;
    }

    public void setTheFont(Font font) {
        Object var4_2 = null;
        LabelViewer labelViewer = null;
        SimpleScalarViewer simpleScalarViewer = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        JButton jButton = null;
        if (font != null) {
            this.theFont = font;
            if (this.listModel != null) {
                int n = this.listModel.size();
                for (int i = 0; i < n; ++i) {
                    try {
                        var4_2 = this.nsLabels.get(i);
                        if (var4_2 instanceof LabelViewer) {
                            labelViewer = var4_2;
                            labelViewer.setFont(this.theFont);
                        }
                        if ((var4_2 = this.nsViewers.get(i)) instanceof SimpleScalarViewer) {
                            simpleScalarViewer = var4_2;
                            simpleScalarViewer.setFont(this.theFont);
                        }
                        if ((var4_2 = this.nsSetters.get(i)) instanceof NumberScalarWheelEditor) {
                            numberScalarWheelEditor = var4_2;
                            numberScalarWheelEditor.setFont(this.theFont);
                        } else if (var4_2 instanceof NumberScalarComboEditor) {
                            numberScalarComboEditor = var4_2;
                            numberScalarComboEditor.setFont(this.theFont);
                        }
                        var4_2 = this.nsPropButtons.get(i);
                        if (!(var4_2 instanceof JButton)) continue;
                        jButton = var4_2;
                        jButton.setFont(this.theFont);
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("NumberScalarListViewer : setTheFont : Caught exception  " + exception.getMessage());
                    }
                }
            }
        }
    }

    public boolean getLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(boolean bl) {
        if (this.labelVisible != bl) {
            this.labelVisible = bl;
            this.changeLabelVisibility();
        }
    }

    private void changeLabelVisibility() {
        Object var3_1 = null;
        LabelViewer labelViewer = null;
        if (this.nsLabels != null) {
            int n = this.nsLabels.size();
            for (int i = 0; i < n; ++i) {
                try {
                    var3_1 = this.nsLabels.get(i);
                    if (!(var3_1 instanceof LabelViewer)) continue;
                    labelViewer = var3_1;
                    labelViewer.setVisible(this.labelVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("NumberScalarListViewer : changeLabelVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getSetterVisible() {
        return this.setterVisible;
    }

    public void setSetterVisible(boolean bl) {
        if (this.setterVisible != bl) {
            this.setterVisible = bl;
            this.changeSetterVisibility();
        }
    }

    private void changeSetterVisibility() {
        Object var3_1 = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        if (this.nsSetters != null) {
            int n = this.nsSetters.size();
            for (int i = 0; i < n; ++i) {
                try {
                    var3_1 = this.nsSetters.get(i);
                    if (var3_1 instanceof NumberScalarWheelEditor) {
                        numberScalarWheelEditor = var3_1;
                        numberScalarWheelEditor.setVisible(this.setterVisible);
                        continue;
                    }
                    if (!(var3_1 instanceof NumberScalarComboEditor)) continue;
                    numberScalarComboEditor = var3_1;
                    numberScalarComboEditor.setVisible(this.setterVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("NumberScalarListViewer : changeSetterVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getPropertyButtonVisible() {
        return this.propertyButtonVisible;
    }

    public void setPropertyButtonVisible(boolean bl) {
        if (this.propertyButtonVisible != bl) {
            this.propertyButtonVisible = bl;
            this.changePropButtonVisibility();
        }
    }

    private void changePropButtonVisibility() {
        Object var3_1 = null;
        JButton jButton = null;
        if (this.nsPropButtons != null) {
            int n = this.nsPropButtons.size();
            for (int i = 0; i < n; ++i) {
                try {
                    var3_1 = this.nsPropButtons.get(i);
                    if (!(var3_1 instanceof JButton)) continue;
                    jButton = var3_1;
                    jButton.setVisible(this.propertyButtonVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("NumberScalarListViewer : changePropButtonVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getPropertyListEditable() {
        return this.propertyListEditable;
    }

    public void setPropertyListEditable(boolean bl) {
    }

    public boolean getUnitVisible() {
        return this.unitVisible;
    }

    public void setUnitVisible(boolean bl) {
        if (this.unitVisible != bl) {
            this.unitVisible = bl;
            this.changeUnitVisibility();
        }
    }

    private void changeUnitVisibility() {
        Object var3_1 = null;
        SimpleScalarViewer simpleScalarViewer = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        if (this.nsViewers != null) {
            int n = this.nsViewers.size();
            for (int i = 0; i < n; ++i) {
                try {
                    var3_1 = this.nsViewers.get(i);
                    if (var3_1 instanceof SimpleScalarViewer) {
                        simpleScalarViewer = var3_1;
                        simpleScalarViewer.setUnitVisible(this.unitVisible);
                    }
                    if (!((var3_1 = this.nsSetters.get(i)) instanceof NumberScalarComboEditor)) continue;
                    numberScalarComboEditor = var3_1;
                    numberScalarComboEditor.setUnitVisible(this.unitVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("NumberScalarListViewer : changeUnitVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public String getSetterType() {
        return this.setterType;
    }

    public void setSetterType(String string) {
        if (this.listModel != null) {
            return;
        }
        this.setterType = string.equalsIgnoreCase(DEFAULT_SETTER) ? DEFAULT_SETTER : (string.equalsIgnoreCase(COMBO_SETTER) ? COMBO_SETTER : DEFAULT_SETTER);
    }

    public Color getArrowColor() {
        if (this.arrowColor == null) {
            return this.getBackground();
        }
        return this.arrowColor;
    }

    public void setArrowColor(Color color) {
        if (color == this.arrowColor) {
            return;
        }
        this.changeArrowColors(color);
        this.arrowColor = color;
    }

    private void changeArrowColors(Color color) {
        Object var4_2 = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        if (this.nsSetters != null) {
            int n = this.nsSetters.size();
            for (int i = 0; i < n; ++i) {
                try {
                    var4_2 = this.nsSetters.get(i);
                    if (!(var4_2 instanceof NumberScalarWheelEditor)) continue;
                    numberScalarWheelEditor = var4_2;
                    if (color == null) {
                        numberScalarWheelEditor.setButtonColor(numberScalarWheelEditor.getBackground());
                        continue;
                    }
                    numberScalarWheelEditor.setButtonColor(color);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("NumberScalarListViewer : changeArrowColors : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public void textExceedBounds(JAutoScrolledText jAutoScrolledText) {
        this.revalidate();
    }

    private void initComponents(AttributeList attributeList) {
        LabelViewer labelViewer = null;
        SimpleScalarViewer simpleScalarViewer = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        JComponent jComponent = null;
        JButton jButton = null;
        int n = 0;
        this.listModel = new Vector();
        this.nsLabels = new Vector();
        this.nsViewers = new Vector();
        this.nsSetters = new Vector();
        this.nsPropButtons = new Vector();
        int n2 = 0;
        int n3 = attributeList.size();
        for (int i = 0; i < n3; ++i) {
            Object object = attributeList.getElementAt(i);
            if (!(object instanceof INumberScalar)) continue;
            INumberScalar iNumberScalar = (INumberScalar)object;
            labelViewer = new LabelViewer();
            simpleScalarViewer = new SimpleScalarViewer();
            jButton = new JButton();
            labelViewer.setFont(this.theFont);
            labelViewer.setHorizontalAlignment(JSmoothLabel.RIGHT_ALIGNMENT);
            labelViewer.setBackground(this.getBackground());
            labelViewer.setText(iNumberScalar.getLabel());
            if (this.labelVisible) {
                labelViewer.setVisible(true);
            } else {
                labelViewer.setVisible(false);
            }
            labelViewer.setModel((IAttribute)iNumberScalar);
            if (this.setterType.equalsIgnoreCase(COMBO_SETTER)) {
                numberScalarComboEditor = new NumberScalarComboEditor();
                numberScalarComboEditor.setFont(this.theFont);
                numberScalarComboEditor.setBackground(this.getBackground());
                numberScalarComboEditor.setUnitVisible(this.unitVisible);
                if (iNumberScalar.isWritable()) {
                    numberScalarComboEditor.setNumberModel(iNumberScalar);
                    if (this.setterVisible) {
                        numberScalarComboEditor.setVisible(true);
                    } else {
                        numberScalarComboEditor.setVisible(false);
                    }
                } else {
                    numberScalarComboEditor.setVisible(false);
                }
                this.nsSetters.add(numberScalarComboEditor);
                jComponent = numberScalarComboEditor;
            } else {
                numberScalarWheelEditor = new NumberScalarWheelEditor();
                numberScalarWheelEditor.setFont(this.theFont);
                numberScalarWheelEditor.setBackground(this.getBackground());
                if (iNumberScalar.isWritable()) {
                    numberScalarWheelEditor.setModel(iNumberScalar);
                    if (this.setterVisible) {
                        numberScalarWheelEditor.setVisible(true);
                    } else {
                        numberScalarWheelEditor.setVisible(false);
                    }
                } else {
                    numberScalarWheelEditor.setVisible(false);
                }
                this.nsSetters.add(numberScalarWheelEditor);
                jComponent = numberScalarWheelEditor;
            }
            simpleScalarViewer.setFont(this.theFont);
            simpleScalarViewer.setUnitVisible(this.unitVisible);
            simpleScalarViewer.setBackgroundColor(this.getBackground());
            simpleScalarViewer.setBorder(BorderFactory.createLoweredBevelBorder());
            simpleScalarViewer.setAlarmEnabled(true);
            simpleScalarViewer.setModel(iNumberScalar);
            jButton.setFont(this.theFont);
            jButton.setBackground(this.getBackground());
            jButton.setText(" ... ");
            jButton.setMargin(new Insets(-3, 0, 3, 0));
            if (!this.propertyButtonVisible && jButton != null) {
                jButton.setVisible(false);
            }
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NumberScalarListViewer.this.propertyButtonActionPerformed(actionEvent);
                }
            });
            iNumberScalar.refresh();
            simpleScalarViewer.addTextListener(this);
            n = (jComponent.getPreferredSize().height - simpleScalarViewer.getPreferredSize().height) / 2;
            if (n > 0) {
                simpleScalarViewer.setMargin(new Insets(n + 2, 5, n + 2, 5));
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(1, 5, 1, 1);
            this.add((Component)labelViewer, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(1, 2, 1, 1);
            this.add((Component)simpleScalarViewer, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(1, 1, 1, 1);
            this.add((Component)jComponent, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.insets = new Insets(1, 3, 1, 5);
            this.add((Component)jButton, gridBagConstraints);
            this.listModel.add(iNumberScalar);
            this.nsLabels.add(labelViewer);
            this.nsViewers.add(simpleScalarViewer);
            this.nsPropButtons.add(jButton);
        }
    }

    private void propertyButtonActionPerformed(ActionEvent actionEvent) {
        Object e;
        int n = -1;
        if (this.nsPropButtons == null) {
            return;
        }
        if (this.listModel == null) {
            return;
        }
        int n2 = this.nsPropButtons.size();
        for (int i = 0; i < n2; ++i) {
            try {
                JButton jButton;
                e = this.nsPropButtons.get(i);
                if (!(e instanceof JButton) || !(jButton = (JButton)e).equals(actionEvent.getSource())) continue;
                n = i;
                break;
            }
            catch (Exception exception) {
                System.out.println("NumberScalarListViewer : propertyButtonActionPerformed : Caught exception  " + exception.getMessage());
                return;
            }
        }
        if (n < 0) {
            return;
        }
        INumberScalar iNumberScalar = null;
        try {
            e = this.listModel.get(n);
            if (e instanceof INumberScalar) {
                iNumberScalar = (INumberScalar)e;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iNumberScalar == null) {
            return;
        }
        if (this.propFrame != null) {
            this.propFrame.setModel((IAttribute)iNumberScalar);
            this.propFrame.setVisible(true);
        }
    }

    public static void main(String[] stringArray) {
        final AttributeList attributeList = new AttributeList();
        NumberScalarListViewer numberScalarListViewer = new NumberScalarListViewer();
        double[] dArray = new double[]{0.1, 0.3, 1.0, 3.0, 10.0, 30.0, 100.0, 300.0};
        try {
            INumberScalar iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_un");
            iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_deux");
            iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_trois");
            iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_quatre");
            numberScalarListViewer.setModel(attributeList);
        }
        catch (Exception exception) {
            System.out.println("caught exception : " + exception.getMessage());
            System.exit(-1);
        }
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                attributeList.startRefresher();
            }
        });
        jFrame.setContentPane(numberScalarListViewer);
        jFrame.pack();
        jFrame.show();
    }
}

