/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import com.braju.format.Format;
import fr.esrf.TangoDs.AttrManip;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.NumberImageEvent;
import fr.esrf.tangoatk.widget.util.JTableRow;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class NumberImageTable
extends JPanel
implements IImageListener {
    protected double[][] data;
    protected INumberImage model;
    protected JTableRow modelTable;
    protected Rectangle selectionRect;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(double[][] dArray) {
        NumberImageTable numberImageTable = this;
        synchronized (numberImageTable) {
            this.data = dArray;
        }
    }

    public void setSelectionRect(Rectangle rectangle) {
        this.selectionRect = rectangle;
    }

    public Rectangle getSelectionRect() {
        return this.selectionRect;
    }

    public void setModel(INumberImage iNumberImage) {
        if (this.model != null) {
            this.model.removeImageListener((IImageListener)this);
            this.model = null;
        }
        if (iNumberImage != null) {
            this.model = iNumberImage;
            this.model.addImageListener((IImageListener)this);
            this.model.refresh();
        }
    }

    private boolean buildTable() {
        Rectangle rectangle = this.selectionRect;
        if (rectangle == null) {
            return false;
        }
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return false;
        }
        String string = null;
        if (this.model != null) {
            string = this.model.getFormat();
        }
        if (string != null && string.length() > 0) {
            if (string.indexOf(37) == -1) {
                Object[][] objectArray = new String[rectangle.height][rectangle.width];
                for (int i = 0; i < rectangle.height; ++i) {
                    for (int j = 0; j < rectangle.width; ++j) {
                        objectArray[i][j] = AttrManip.format((String)string, (double)this.data[rectangle.y + i][rectangle.x + j]);
                    }
                }
                this.modelTable.setData(objectArray, rectangle.x, rectangle.y);
            } else {
                Object[] objectArray = new Double[1];
                Object[][] objectArray2 = new String[rectangle.height][rectangle.width];
                for (int i = 0; i < rectangle.height; ++i) {
                    for (int j = 0; j < rectangle.width; ++j) {
                        objectArray[0] = new Double(this.data[rectangle.y + i][rectangle.x + j]);
                        objectArray2[i][j] = Format.sprintf((String)string, (Object[])objectArray);
                    }
                }
                this.modelTable.setData(objectArray2, rectangle.x, rectangle.y);
            }
        } else {
            Object[][] objectArray = new Double[rectangle.height][rectangle.width];
            for (int i = 0; i < rectangle.height; ++i) {
                for (int j = 0; j < rectangle.width; ++j) {
                    objectArray[i][j] = new Double(this.data[rectangle.y + i][rectangle.x + j]);
                }
            }
            this.modelTable.setData(objectArray, rectangle.x, rectangle.y);
        }
        return true;
    }

    public void imageChange(NumberImageEvent numberImageEvent) {
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
    }

    public static void main(String[] stringArray) {
    }
}

