/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.INonAttrNumberSpectrum;
import fr.esrf.tangoatk.core.INonAttrSpectrumListener;
import fr.esrf.tangoatk.core.NonAttrNumberSpectrumEvent;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import java.awt.Color;
import java.util.Vector;
import javax.swing.border.EtchedBorder;

public class NonAttrNumberSpectrumViewer
extends JLChart
implements INonAttrSpectrumListener {
    private int current_model_number = 0;
    private int maximum_model_number = 9;
    INonAttrNumberSpectrum[] models = new INonAttrNumberSpectrum[this.maximum_model_number];
    JLDataView[] dvy = new JLDataView[this.maximum_model_number];
    JLDataView dvx;
    public static final Color[] defaultColor = new Color[]{Color.red, Color.blue, Color.cyan, Color.green, Color.magenta, Color.orange, Color.pink, Color.yellow, Color.black};

    public NonAttrNumberSpectrumViewer() {
        this.setBorder(new EtchedBorder());
        this.setBackground(new Color(180, 180, 180));
        this.getY1Axis().setAutoScale(true);
        this.getY2Axis().setAutoScale(true);
        this.getXAxis().setAutoScale(true);
        this.dvx = new JLDataView();
        this.getXAxis().addDataView(this.dvx);
    }

    public void reset() {
        for (int i = 0; i < this.current_model_number; ++i) {
            this.models[i].removeNonAttrSpectrumListener((INonAttrSpectrumListener)this);
            this.getY1Axis().removeDataView(this.dvy[i]);
        }
        this.current_model_number = 0;
    }

    private int findModelIndex(INonAttrNumberSpectrum iNonAttrNumberSpectrum) {
        int n = -1;
        while (++n < this.current_model_number && this.models[n] != iNonAttrNumberSpectrum) {
        }
        if (n == this.current_model_number) {
            n = -1;
        }
        return n;
    }

    public void spectrumChange(NonAttrNumberSpectrumEvent nonAttrNumberSpectrumEvent) {
        INonAttrNumberSpectrum iNonAttrNumberSpectrum = (INonAttrNumberSpectrum)nonAttrNumberSpectrumEvent.getSource();
        int n = this.findModelIndex(iNonAttrNumberSpectrum);
        if (n != -1) {
            double[] dArray = nonAttrNumberSpectrumEvent.getXValue();
            double[] dArray2 = nonAttrNumberSpectrumEvent.getYValue();
            int n2 = dArray.length;
            this.dvx.reset();
            for (int i = 0; i < n2; ++i) {
                this.dvx.add(i, dArray[i]);
            }
            n2 = dArray2.length;
            JLDataView jLDataView = this.dvy[n];
            jLDataView.reset();
            for (int i = 0; i < n2; ++i) {
                jLDataView.add(i, dArray2[i]);
            }
            this.repaint();
        }
    }

    public void addModel(INonAttrNumberSpectrum iNonAttrNumberSpectrum) {
        if (iNonAttrNumberSpectrum != null && this.current_model_number < this.maximum_model_number && this.findModelIndex(iNonAttrNumberSpectrum) == -1) {
            this.models[this.current_model_number] = iNonAttrNumberSpectrum;
            JLDataView jLDataView = new JLDataView();
            jLDataView.setUnit(iNonAttrNumberSpectrum.getYUnit());
            jLDataView.setName(iNonAttrNumberSpectrum.getYName());
            jLDataView.setColor(defaultColor[this.current_model_number]);
            jLDataView.setMarkerColor(defaultColor[this.current_model_number]);
            this.getY1Axis().addDataView(jLDataView);
            this.dvy[this.current_model_number] = jLDataView;
            ++this.current_model_number;
            iNonAttrNumberSpectrum.addNonAttrSpectrumListener((INonAttrSpectrumListener)this);
        }
    }

    public String setSettings(String string) {
        CfFileReader cfFileReader = new CfFileReader();
        if (!cfFileReader.parseText(string)) {
            return "NumberSpectrumViewer.setSettings: Failed to parse given config";
        }
        Vector vector = cfFileReader.getParam("graph_title");
        if (vector != null) {
            this.setHeader(OFormat.getName(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("label_visible")) != null) {
            this.setLabelVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("graph_background")) != null) {
            this.setBackground(OFormat.getColor(vector));
        }
        if ((vector = cfFileReader.getParam("title_font")) != null) {
            this.setHeaderFont(OFormat.getFont(vector));
        }
        JLAxis jLAxis = this.getXAxis();
        vector = cfFileReader.getParam("xgrid");
        if (vector != null) {
            jLAxis.setGridVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("xsubgrid")) != null) {
            jLAxis.setSubGridVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("xgrid_style")) != null) {
            jLAxis.setGridStyle(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("xmin")) != null) {
            jLAxis.setMinimum(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("xmax")) != null) {
            jLAxis.setMaximum(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("xautoscale")) != null) {
            jLAxis.setAutoScale(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("xcale")) != null) {
            jLAxis.setScale(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("xformat")) != null) {
            jLAxis.setLabelFormat(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("xtitle")) != null) {
            jLAxis.setName(OFormat.getName(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("xcolor")) != null) {
            jLAxis.setAxisColor(OFormat.getColor(vector));
        }
        if ((vector = cfFileReader.getParam("xlabel_font")) != null) {
            jLAxis.setFont(OFormat.getFont(vector));
        }
        jLAxis = this.getY1Axis();
        vector = cfFileReader.getParam("y1grid");
        if (vector != null) {
            jLAxis.setGridVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y1subgrid")) != null) {
            jLAxis.setSubGridVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y1grid_style")) != null) {
            jLAxis.setGridStyle(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y1min")) != null) {
            jLAxis.setMinimum(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y1max")) != null) {
            jLAxis.setMaximum(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y1autoscale")) != null) {
            jLAxis.setAutoScale(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y1cale")) != null) {
            jLAxis.setScale(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y1format")) != null) {
            jLAxis.setLabelFormat(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y1title")) != null) {
            jLAxis.setName(OFormat.getName(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y1color")) != null) {
            jLAxis.setAxisColor(OFormat.getColor(vector));
        }
        if ((vector = cfFileReader.getParam("y1label_font")) != null) {
            jLAxis.setFont(OFormat.getFont(vector));
        }
        return "";
    }

    public String getSettings() {
        String string = "";
        string = string + "graph_title:'" + this.getHeader() + "'\n";
        string = string + "label_visible:" + this.isLabelVisible() + "\n";
        string = string + "graph_background:" + OFormat.color(this.getBackground()) + "\n";
        string = string + "title_font:" + OFormat.font(this.getHeaderFont()) + "\n";
        string = string + "xgrid:" + this.getXAxis().isGridVisible() + "\n";
        string = string + "xsubgrid:" + this.getXAxis().isSubGridVisible() + "\n";
        string = string + "xgrid_style:" + this.getXAxis().getGridStyle() + "\n";
        string = string + "xmin:" + this.getXAxis().getMinimum() + "\n";
        string = string + "xmax:" + this.getXAxis().getMaximum() + "\n";
        string = string + "xautoscale:" + this.getXAxis().isAutoScale() + "\n";
        string = string + "xcale:" + this.getXAxis().getScale() + "\n";
        string = string + "xformat:" + this.getXAxis().getLabelFormat() + "\n";
        string = string + "xtitle:'" + this.getXAxis().getName() + "'\n";
        string = string + "xcolor:" + OFormat.color(this.getXAxis().getAxisColor()) + "\n";
        string = string + "xlabel_font:" + OFormat.font(this.getXAxis().getFont()) + "\n";
        string = string + "y1grid:" + this.getY1Axis().isGridVisible() + "\n";
        string = string + "y1subgrid:" + this.getY1Axis().isSubGridVisible() + "\n";
        string = string + "y1grid_style:" + this.getY1Axis().getGridStyle() + "\n";
        string = string + "y1min:" + this.getY1Axis().getMinimum() + "\n";
        string = string + "y1max:" + this.getY1Axis().getMaximum() + "\n";
        string = string + "y1autoscale:" + this.getY1Axis().isAutoScale() + "\n";
        string = string + "y1cale:" + this.getY1Axis().getScale() + "\n";
        string = string + "y1format:" + this.getY1Axis().getLabelFormat() + "\n";
        string = string + "y1title:'" + this.getY1Axis().getName() + "'\n";
        string = string + "y1color:" + OFormat.color(this.getY1Axis().getAxisColor()) + "\n";
        string = string + "y1label_font:" + OFormat.font(this.getY1Axis().getFont()) + "\n";
        return string;
    }
}

