/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class IconNumberSpectrumViewer
extends JPanel
implements ISpectrumListener {
    JLabel[] iconViewers;
    Icon[] icons;
    INumberSpectrum model;
    int rows = 0;
    int columns = 1;
    Icon invalidIcon;
    String[][] texts;
    Color[] colors;

    public IconNumberSpectrumViewer() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public void errorChange(ErrorEvent errorEvent) {
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    protected void updateIcon(JLabel jLabel, int n) {
        try {
            jLabel.setIcon(this.icons[n]);
        }
        catch (Exception exception) {
            jLabel.setIcon(this.getInvalidIcon());
        }
    }

    protected void updateText(JLabel jLabel, String[] stringArray, int n) {
        try {
            jLabel.setText(stringArray[n]);
        }
        catch (Exception exception) {
            jLabel.setText("");
        }
    }

    protected void updateColor(JLabel jLabel, int n) {
        try {
            jLabel.setBackground(this.colors[n]);
        }
        catch (Exception exception) {
            jLabel.setBackground(this.getBackground());
        }
    }

    public void spectrumChange(NumberSpectrumEvent numberSpectrumEvent) {
        double[] dArray = numberSpectrumEvent.getValue();
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = (int)dArray[i];
            this.updateIcon(this.iconViewers[i], n2);
            this.updateText(this.iconViewers[i], this.texts[i], n2);
            this.updateColor(this.iconViewers[i], n2);
        }
    }

    public Color[] getColors() {
        return this.colors;
    }

    public void setColors(Color[] colorArray) {
        this.colors = colorArray;
    }

    public String[][] getTexts() {
        return this.texts;
    }

    public void setTexts(String[][] stringArray) {
        this.texts = stringArray;
    }

    public Icon getInvalidIcon() {
        return this.invalidIcon;
    }

    public void setInvalidIcon(Icon icon) {
        this.invalidIcon = icon;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int n) {
        this.columns = n;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n) {
        this.rows = n;
    }

    public INumberSpectrum getModel() {
        return this.model;
    }

    public void setModel(INumberSpectrum iNumberSpectrum) {
        if (this.model != null) {
            this.model.removeSpectrumListener((ISpectrumListener)this);
        }
        this.model = iNumberSpectrum;
        this.model.addSpectrumListener((ISpectrumListener)this);
        this.iconViewers = new JLabel[this.model.getMaxXDimension()];
        this.removeAll();
        this.setLayout(new GridLayout(this.rows, this.columns));
        for (int i = 0; i < this.iconViewers.length; ++i) {
            this.iconViewers[i] = new JLabel(Integer.toString(i));
            this.iconViewers[i].setOpaque(true);
            this.iconViewers[i].setBorder(BorderFactory.createEtchedBorder());
            this.add(this.iconViewers[i]);
        }
    }

    public void setIconBorders(Border border) {
        for (int i = 0; i < this.iconViewers.length; ++i) {
            this.iconViewers[i].setBorder(border);
        }
    }

    public Border getIconBorders() {
        return this.iconViewers[0].getBorder();
    }

    public void setFont(Font font) {
        if (this.iconViewers == null) {
            return;
        }
        for (int i = 0; i < this.iconViewers.length; ++i) {
            this.iconViewers[i].setFont(font);
        }
    }

    public Font getFont() {
        if (this.iconViewers == null || this.iconViewers[0] == null) {
            return super.getFont();
        }
        return this.iconViewers[0].getFont();
    }

    public void setHorizontalAlignment(int n) {
        if (this.iconViewers == null) {
            return;
        }
        for (int i = 0; i < this.iconViewers.length; ++i) {
            this.iconViewers[i].setHorizontalAlignment(n);
        }
    }

    public int getHorizontalAlignment() {
        if (this.iconViewers == null) {
            return 0;
        }
        return this.iconViewers[0].getHorizontalAlignment();
    }

    public Icon[] getIcons() {
        return this.icons;
    }

    public void setIcons(Icon[] iconArray) {
        this.icons = iconArray;
    }

    public static void main(String[] stringArray) throws Exception {
        Icon[] iconArray = new Icon[2];
        AttributeList attributeList = new AttributeList();
        INumberSpectrum iNumberSpectrum = (INumberSpectrum)attributeList.add("eas/test-api/1/Short_spec_attr");
        IconNumberSpectrumViewer iconNumberSpectrumViewer = new IconNumberSpectrumViewer();
        iconArray[0] = new ImageIcon(iconNumberSpectrumViewer.getClass().getResource("/fr/esrf/TangoATK/Widget/Attribute/NumberScalarViewer.gif"));
        iconArray[1] = new ImageIcon(iconNumberSpectrumViewer.getClass().getResource("/fr/esrf/TangoATK/Widget/Attribute/JChartAdapter.gif"));
        iconNumberSpectrumViewer.setIcons(iconArray);
        iconNumberSpectrumViewer.setModel(iNumberSpectrum);
        attributeList.startRefresher();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(iconNumberSpectrumViewer);
        jFrame.pack();
        jFrame.show();
    }
}

