/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IAttributeStateListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IScalarAttribute;
import fr.esrf.tangoatk.widget.attribute.IAttributeViewer;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.attribute.Trend;
import fr.esrf.tangoatk.widget.properties.PropertyViewer;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKField;
import fr.esrf.tangoatk.widget.util.ATKFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class AScalarViewer
extends JPanel
implements IAttributeStateListener,
IErrorListener,
IAttributeViewer {
    SimplePropertyFrame f;
    IScalarAttribute supermodel;
    Color background = this.getBackground();
    Trend globalTrend;
    boolean fullState = false;
    boolean propertyListEditable = false;
    boolean setter = false;
    boolean valueEditable;
    boolean alarmEnabled = true;
    private JPanel jPanel1;
    private PropertyViewer label;
    private ATKField value;
    private PropertyViewer unit;
    private JButton info;

    public AScalarViewer() {
        this.initComponents();
        this.label.setValueHorizontalAlignment(4);
        this.setUnitBorder(null);
        this.setLabelBorder(null);
        Dimension dimension = this.info.getPreferredSize();
        Dimension dimension2 = this.getValue().getPreferredSize();
        dimension.setSize(dimension.getWidth(), dimension2.getHeight() - 1.0);
        this.info.setPreferredSize(dimension);
        this.info.setMaximumSize(dimension);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.jPanel1 == null) {
            return;
        }
        this.setLabelFont(font);
        this.setUnitFont(font);
        this.setValueFont(font);
        this.info.setFont(font);
    }

    protected void setValueField(ATKField aTKField) {
        GridBagLayout gridBagLayout = (GridBagLayout)this.jPanel1.getLayout();
        this.jPanel1.remove(this.value);
        this.value = aTKField;
        this.jPanel1.add((Component)this.value, 1);
    }

    public void fullStateChange(String string) {
        if ("VALID".equals(string)) {
            this.setBackground(this.background);
            return;
        }
        this.setBackground(ATKConstant.getColor4Quality(string));
    }

    public void stateChange(String string) {
        if (!this.alarmEnabled) {
            return;
        }
        if (this.fullState) {
            this.fullStateChange(string);
            return;
        }
        if ("VALID".equals(string)) {
            this.value.setState(this.getBackground());
            return;
        }
        this.value.setState(ATKConstant.getColor4Quality(string));
    }

    protected void init(IScalarAttribute iScalarAttribute) {
        if (this.supermodel != null) {
            this.supermodel.removeStateListener((IAttributeStateListener)this);
        }
        this.supermodel = iScalarAttribute;
        this.supermodel.addStateListener((IAttributeStateListener)this);
        this.getLabel().setModel(this.supermodel.getProperty("label"));
        this.getLabel().setEditable(false);
        this.getUnit().setModel(this.supermodel.getProperty("unit"));
        this.getUnit().setEditable(false);
        this.getValue().setFormat(this.supermodel.getProperty("format").getPresentation());
        Border border = this.getBorder();
        if (border != null && border instanceof TitledBorder && this.supermodel != null && this.supermodel.getName() != null) {
            ((TitledBorder)border).setTitle(this.supermodel.getName());
        }
        this.stateChange(iScalarAttribute.getState());
    }

    public boolean isFullState() {
        return this.fullState;
    }

    public void setFullState(boolean bl) {
        this.fullState = bl;
    }

    public void setUserFormat(ATKFormat aTKFormat) {
        this.value.setUserFormat(aTKFormat);
    }

    public ATKFormat getUserFormat() {
        return this.value.getUserFormat();
    }

    public void setLabelFont(Font font) {
        this.label.setFont(font);
    }

    public Font getLabelFont() {
        return this.label.getFont();
    }

    public void setUnitFont(Font font) {
        this.unit.setFont(font);
    }

    public Font getUnitFont() {
        return this.unit.getFont();
    }

    public void setValueFont(Font font) {
        this.value.setFont(font);
    }

    public Font getValueFont() {
        return this.value.getFont();
    }

    public Dimension getLabelPreferredSize() {
        return this.label.getPreferredSize();
    }

    public void setLabelPreferredSize(Dimension dimension) {
        this.label.setPreferredSize(dimension);
    }

    public Dimension getValuePreferredSize() {
        return this.value.getPreferredSize();
    }

    public void setValuePreferredSize(Dimension dimension) {
        this.value.setPreferredSize(dimension);
    }

    public void setGlobalTrend(Trend trend) {
        this.globalTrend = trend;
    }

    public Trend getGlobalTrend() {
        return this.globalTrend;
    }

    public Dimension getUnitPreferredSize() {
        return this.unit.getPreferredSize();
    }

    public void setUnitPreferredSize(Dimension dimension) {
        this.unit.setPreferredSize(dimension);
    }

    public void setUnitMaximumLength(int n) {
        this.unit.setValueMaximumLength(n);
    }

    public int getUnitMaximumLength() {
        return this.unit.getValueMaximumLength();
    }

    public void setLabelMaximumLength(int n) {
        this.label.setValueMaximumLength(n);
    }

    public int getLabelMaximumLength() {
        return this.label.getValueMaximumLength();
    }

    public void setValueMaximumLength(int n) {
        this.value.setMaximumLength(n);
    }

    public int getValueMaximumLength() {
        return this.value.getMaximumLength();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.label = new PropertyViewer();
        this.value = new ATKField();
        this.unit = new PropertyViewer();
        this.info = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Not Connected"));
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setAlignmentX(0.0f);
        this.jPanel1.setAlignmentY(0.0f);
        this.label.setLabelVisible(false);
        this.label.setValue("label");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.1;
        this.jPanel1.add((Component)this.label, gridBagConstraints);
        this.value.setHorizontalAlignment(11);
        this.value.setText("-------");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.jPanel1.add((Component)this.value, gridBagConstraints);
        this.unit.setLabelVisible(false);
        this.unit.setValue("unit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        gridBagConstraints.anchor = 13;
        this.jPanel1.add((Component)this.unit, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 0.1;
        this.add((Component)this.jPanel1, gridBagConstraints2);
        this.info.setFont(new Font("Dialog", 0, 12));
        this.info.setText("...");
        this.info.setAlignmentY(0.0f);
        this.info.setHorizontalTextPosition(0);
        this.info.setMargin(new Insets(0, 5, 0, 5));
        this.info.setMinimumSize(new Dimension(0, 0));
        this.info.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                AScalarViewer.this.infoMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 13;
        this.add((Component)this.info, gridBagConstraints2);
    }

    private void infoMouseClicked(MouseEvent mouseEvent) {
        if (this.f == null) {
            this.f = new SimplePropertyFrame();
            this.f.setSize(300, 400);
            this.f.setEditable(this.propertyListEditable);
            this.f.setModel((IAttribute)this.supermodel);
            this.f.pack();
        }
        this.f.show();
    }

    public static void main(String[] stringArray) {
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.jPanel1 == null) {
            return;
        }
        this.unit.setForeground(color);
        this.label.setForeground(color);
        this.value.setForeground(color);
        this.jPanel1.setForeground(color);
        this.info.setForeground(color);
    }

    public void setBackground(Color color) {
        this.background = color;
        super.setBackground(color);
        if (this.jPanel1 == null) {
            return;
        }
        this.unit.setBackground(color);
        this.label.setBackground(color);
        this.value.setBackground(color);
        this.jPanel1.setBackground(color);
        this.info.setBackground(color);
    }

    public void setUnitVisible(boolean bl) {
        this.unit.setVisible(bl);
    }

    public boolean isUnitVisible() {
        return this.unit.isVisible();
    }

    public boolean isLabelVisible() {
        return this.label.isVisible();
    }

    public void setLabelVisible(boolean bl) {
        this.label.setVisible(bl);
    }

    public void setInfoVisible(boolean bl) {
        this.info.setVisible(bl);
    }

    public boolean isInfoVisible() {
        return this.info.isVisible();
    }

    public void setPropertyListEditable(boolean bl) {
        this.propertyListEditable = bl;
        if (this.f == null) {
            return;
        }
        this.f.setEditable(bl);
    }

    public boolean isPropertyListEditable() {
        return this.propertyListEditable;
    }

    public void setSetter(boolean bl) {
        this.setter = bl;
        this.value.setEditable(this.setter);
    }

    public boolean isSetter() {
        return this.value.isEditable();
    }

    public void setValueEditable(boolean bl) {
        this.valueEditable = bl;
    }

    public boolean isValueEditable() {
        return this.valueEditable;
    }

    public void setValueBorder(Border border) {
        this.value.setBorder(border);
    }

    public Border getValueBorder() {
        return this.value.getBorder();
    }

    public void setLabelBorder(Border border) {
        this.label.setBorder(border);
    }

    public Border getLabelBorder() {
        return this.label.getBorder();
    }

    public void setUnitBorder(Border border) {
        this.unit.setBorder(border);
    }

    public Border getUnitBorder() {
        return this.unit.getBorder();
    }

    public void setValueOpaque(boolean bl) {
        this.value.setOpaque(bl);
    }

    public boolean isValueOpaque() {
        return this.value.isOpaque();
    }

    public void setLabelOpaque(boolean bl) {
        this.label.setOpaque(bl);
    }

    public boolean isLabelOpaque() {
        return this.label.isOpaque();
    }

    public void setUnitOpaque(boolean bl) {
        this.unit.setOpaque(bl);
    }

    public boolean isUnitOpaque() {
        return this.unit.isOpaque();
    }

    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        if (this.jPanel1 == null) {
            return;
        }
        this.setUnitOpaque(bl);
        this.setLabelOpaque(bl);
        this.jPanel1.setOpaque(bl);
    }

    public boolean isOpaque() {
        return super.isOpaque();
    }

    protected PropertyViewer getUnit() {
        return this.unit;
    }

    protected PropertyViewer getLabel() {
        return this.label;
    }

    protected ATKField getValue() {
        return this.value;
    }

    public double getValueWidth() {
        return AScalarViewer.getWidth(this.getValue());
    }

    public double getLabelWidth() {
        return AScalarViewer.getWidth(this.label);
    }

    public double getUnitWidth() {
        return AScalarViewer.getWidth(this.unit);
    }

    public void setLabelWidth(double d) {
        AScalarViewer.setWidth(this.label, d);
    }

    public void setUnitWidth(double d) {
        AScalarViewer.setWidth(this.unit, d);
    }

    public void setValueWidth(double d) {
        AScalarViewer.setWidth(this.getValue(), d);
    }

    static double getWidth(JComponent jComponent) {
        return jComponent.getPreferredSize().getWidth();
    }

    static void setWidth(JComponent jComponent, double d) {
        Dimension dimension = jComponent.getPreferredSize();
        dimension.setSize(d, dimension.getHeight());
        jComponent.setPreferredSize(dimension);
        jComponent.setMinimumSize(dimension);
    }

    public boolean isAlarmEnabled() {
        return this.alarmEnabled;
    }

    public void setAlarmEnabled(boolean bl) {
        this.alarmEnabled = bl;
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.value.setError();
        this.stateChange("UNKNOWN");
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
        this.stateChange(attributeStateEvent.getState());
    }

    public IAttribute getModel() {
        return this.supermodel;
    }
}

