/*
 * Decompiled with CFR 0.152.
 */
package app_util;

import app_util.Misc;
import fr.esrf.TangoApi.CommandInfo;
import java.awt.Component;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class PopupMessage {
    private static final String[] TangoTypesArray = new String[]{"Tango::DEV_VOID", "Tango::DEV_BOOLEAN", "Tango::DEV_SHORT", "Tango::DEV_LONG", "Tango::DEV_FLOAT", "Tango::DEV_DOUBLE", "Tango::DEV_USHORT", "Tango::DEV_ULONG", "Tango::CONST_DEV_STRING", "Tango::DEV_STRING", "Tango::DEVVAR_CHARARRAY", "Tango::DEVVAR_SHORTARRAY", "Tango::DEVVAR_LONGARRAY", "Tango::DEVVAR_FLOATARRAY", "Tango::DEVVAR_DOUBLEARRAY", "Tango::DEVVAR_USHORTARRAY", "Tango::DEVVAR_ULONGARRAY", "Tango::DEVVAR_STRINGARRAY", "Tango::DEVVAR_LONGSTRINGARRAY", "Tango::DEVVAR_DOUBLESTRINGARRAY", "Tango::DEV_STATE"};

    public static void show(Component parent, String message) {
        JOptionPane.showMessageDialog(parent, message, "Message Window", 1);
    }

    public static void show(Component parent, String title, String s) {
        StringBuffer sb = new StringBuffer("");
        if (title.length() > 0) {
            sb.append(title + ":\n\n");
        }
        sb.append(s);
        PopupMessage.show(parent, sb.toString());
    }

    public static void show(Component parent, String title, String[] s) {
        StringBuffer sb = new StringBuffer("");
        if (title.length() > 0) {
            sb.append(title + ":\n\n");
        }
        for (int i = 0; i < s.length; ++i) {
            sb.append(s[i] + "\n");
        }
        PopupMessage.show(parent, sb.toString());
    }

    public static void show(Component parent, String[] s) {
        PopupMessage.show(parent, "", s);
    }

    public static void show(Component parent, Vector v) {
        String[] s = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            s[i] = (String)v.elementAt(i);
        }
        PopupMessage.show(parent, "", s);
    }

    public static void show(Component parent, String title, CommandInfo[] cmdInfo) {
        String[] array = new String[cmdInfo.length];
        for (int i = 0; i < cmdInfo.length; ++i) {
            CommandInfo info = cmdInfo[i];
            array[i] = new String(info.cmd_name + "(" + TangoTypesArray[info.in_type] + ",\t" + TangoTypesArray[info.out_type] + ")");
        }
        PopupMessage.show(parent, title, array);
    }

    public static void showImage(Component parent, String message, String filename) {
        ImageIcon icon = new ImageIcon(parent.getClass().getResource(filename));
        JOptionPane.showMessageDialog(parent, message, "Message Window", 1, icon);
    }

    public static void showImage(Component parent, String[] array, String filename) {
        String message = Misc.array2string(array);
        ImageIcon icon = new ImageIcon(parent.getClass().getResource(filename));
        JOptionPane.showMessageDialog(parent, message, "Message Window", 1, icon);
    }
}

