/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.Astor;
import admin.astor.ManagePollingDialog;
import admin.astor.tools.DevBrowserTree;
import admin.astor.tools.EventsTable;
import admin.astor.tools.SubscribedSignal;
import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import jive.MultiLineToolTipUI;

public class DevBrowser
extends JFrame {
    private Astor astor;
    private DevBrowserTree tree;
    private static EventsTable ev_table;
    private JMenuItem astorBtn;
    private JMenuItem eventsDlgBtn;
    private JMenuItem exitBtn;
    private JMenu fileMenu;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JTextArea textArea;
    private JScrollPane textScrollPane;
    private JScrollPane treeScrollPane;
    private JMenu viewMenu;

    public DevBrowser(Astor parent) {
        this.astor = parent;
        this.initComponents();
        try {
            this.tree = new DevBrowserTree(this);
            this.treeScrollPane.setViewportView(this.tree);
        }
        catch (DevFailed e) {
            PopupError.show((Component)parent, e);
        }
        this.customizeMenu();
        this.pack();
        ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
        MultiLineToolTipUI.initialize();
    }

    private void customizeMenu() {
        this.fileMenu.setMnemonic('F');
        this.exitBtn.setMnemonic('E');
        this.exitBtn.setAccelerator(KeyStroke.getKeyStroke(81, 2));
    }

    void displayEventProperties(String attname) {
        this.tree.displayEventProperties(attname);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.textScrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.treeScrollPane = new JScrollPane();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exitBtn = new JMenuItem();
        this.viewMenu = new JMenu();
        this.eventsDlgBtn = new JMenuItem();
        this.astorBtn = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DevBrowser.this.exitForm(evt);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.textScrollPane.setPreferredSize(new Dimension(400, 400));
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Courier New", 1, 12));
        this.textScrollPane.setViewportView(this.textArea);
        this.jPanel1.add((Component)this.textScrollPane, "Center");
        this.treeScrollPane.setPreferredSize(new Dimension(300, 400));
        this.jPanel1.add((Component)this.treeScrollPane, "West");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.fileMenu.setText("File");
        this.exitBtn.setText("Exit");
        this.exitBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DevBrowser.this.exitBtnActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitBtn);
        this.jMenuBar1.add(this.fileMenu);
        this.viewMenu.setText("View");
        this.eventsDlgBtn.setText("Events Panel");
        this.eventsDlgBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DevBrowser.this.eventsDlgBtnActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.eventsDlgBtn);
        this.astorBtn.setText("Astor Panel");
        this.astorBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DevBrowser.this.astorBtnActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.astorBtn);
        this.jMenuBar1.add(this.viewMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void astorBtnActionPerformed(ActionEvent evt) {
        if (this.astor != null) {
            this.astor.setVisible(true);
        }
    }

    private void eventsDlgBtnActionPerformed(ActionEvent evt) {
        try {
            if (ev_table == null) {
                ev_table = new EventsTable(this);
            }
            ev_table.setVisible(true);
        }
        catch (DevFailed e) {
            PopupError.show((Component)this, e);
            return;
        }
    }

    private void exitBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void exitForm(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        if (this.astor.isVisible()) {
            this.dispose();
        } else {
            this.astor.doExit();
        }
    }

    void setText(String str) {
        this.textArea.setText(str);
        this.textArea.setCaretPosition(0);
    }

    void add(String signame, int mode) {
        if (ev_table == null) {
            try {
                ev_table = new EventsTable(this);
            }
            catch (DevFailed e) {
                PopupError.show((Component)this, e);
                return;
            }
        }
        ev_table.add(signame, mode);
    }

    void displayHostPanel(String devname) {
        this.astor.tree.displayHostInfo(devname);
    }

    void managePolling(SubscribedSignal sig, Point p) {
        try {
            new ManagePollingDialog(this, sig.devname, sig.attname, p).setVisible(true);
        }
        catch (DevFailed e) {
            PopupError.show((Component)this.astor, e);
        }
    }

    void managePolling(String devname) {
        try {
            Point p = this.getLocationOnScreen();
            p.translate(10, 10);
            new ManagePollingDialog(this, devname, "", p).setVisible(true);
        }
        catch (DevFailed e) {
            PopupError.show((Component)this.astor, e);
        }
    }

    void managePolling(DeviceProxy dev, String attname) {
        try {
            Point p = this.getLocationOnScreen();
            p.translate(10, 10);
            new ManagePollingDialog(this, dev.name(), attname, p).setVisible(true);
        }
        catch (DevFailed e) {
            PopupError.show((Component)this.astor, e);
        }
    }

    public static void main(String[] args) {
        Astor astor = new Astor();
        DevBrowser db = new DevBrowser(astor);
        db.setVisible(true);
    }
}

