/*
 * Decompiled with CFR 0.152.
 */
package pogo.make_util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import pogo.gene.PogoUtil;

public class TagModule {
    public String modulname = null;
    private String cvsroot = null;
    static String separator = "-";
    public static final int DisplayMode = 0;
    public static final int WriteMode = 1;
    public static final int LastMode = 2;
    private static final int T = 0;
    private static final int DATE = 1;
    private static final int TIME = 2;
    private static final int ADD = 3;
    private static final int USER = 4;
    private static final int MODULE = 5;
    private static final int TAGNAME = 6;

    public TagModule(String modulname) throws Exception {
        if (modulname == null) {
            this.setCVSentries();
        } else {
            this.modulname = modulname;
        }
    }

    public void setTag(String release) throws Exception {
        System.out.println("setting tag " + release + " for module " + this.modulname);
        this.checkTags(release);
        this.patchSourceFile(release);
        TagModule.executeShellCmd("cvs rtag " + release + "  " + this.modulname);
    }

    private void setCVSentries() throws Exception {
        try {
            this.cvsroot = PogoUtil.readFile("CVS/Root").trim();
            this.modulname = PogoUtil.readFile("CVS/Repository").trim();
            int start = this.modulname.lastIndexOf("/");
            if (start >= 0) {
                this.modulname = this.modulname.substring(start + 1);
            }
            System.out.println("cvsroot = " + this.cvsroot);
            System.out.println("module  = " + this.modulname);
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("CVS (No such file or directory)\n  This is not a CVS directory !");
        }
    }

    public String printLastTag() throws Exception {
        Tag[] tags = this.getLastTag();
        for (int i = 0; i < tags.length; ++i) {
            if (tags[i].filename.startsWith(".")) continue;
            return tags[i].tag;
        }
        return "No  tag found";
    }

    public void checkTags(String release) throws Exception {
        Tag[] tags = this.getLastTag();
        for (int i = 0; i < tags.length; ++i) {
            if (!tags[i].tag.equals(release)) continue;
            throw new Exception("Tag " + release + " already used");
        }
    }

    private Tag[] getLastTag() throws Exception {
        File exe = new File(this.modulname);
        File tmp_exe = new File("." + this.modulname);
        boolean exe_exists = false;
        if (exe.exists()) {
            try {
                exe.renameTo(tmp_exe);
                exe_exists = true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        TagModule.executeShellCmd("cvs co " + this.modulname);
        String dirname = this.modulname;
        File d = new File(dirname);
        String[] filenames = d.list();
        String cmd = "cvs log -h ";
        for (int i = 0; i < filenames.length; ++i) {
            String filename = dirname + "/" + filenames[i];
            if (filename.indexOf("CVS") >= 0) continue;
            cmd = cmd + filename + " ";
        }
        String cvslog = TagModule.executeShellCmd(cmd);
        TagModule.executeShellCmd("rm -R " + this.modulname);
        if (exe_exists) {
            tmp_exe.renameTo(exe);
        }
        return this.parseTags(cvslog);
    }

    private Tag[] parseTags(String fulltag) {
        Vector<Tag> v = new Vector<Tag>();
        String filename = "";
        StringTokenizer stk = new StringTokenizer(fulltag, "\n");
        while (stk.hasMoreTokens()) {
            int end;
            String line = stk.nextToken();
            if (line.startsWith("Working file:")) {
                filename = line.substring("Working file:".length()).trim();
                continue;
            }
            if (!line.startsWith("symbolic names:") || (line = stk.nextToken().trim()).indexOf("keyword substitution") >= 0 || (end = line.indexOf(":")) <= 0) continue;
            String tag = line.substring(0, end);
            v.add(new Tag(filename, tag));
        }
        Tag[] tags = new Tag[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            tags[i] = (Tag)v.get(i);
        }
        return tags;
    }

    private void updateSourceFile(String release) throws Exception {
        TagModule.executeShellCmd("cvs co -r " + release + "  " + this.modulname);
        String classname = release.substring(0, release.indexOf(separator));
        String filename = classname + "Class.cpp";
        FileInputStream fid = new FileInputStream(this.modulname + "/" + filename);
        int nb = fid.available();
        byte[] inStr = new byte[nb];
        fid.read(inStr);
        String code = new String(inStr);
        fid.close();
        FileOutputStream fidout = new FileOutputStream(filename);
        fidout.write(code.getBytes());
        fidout.close();
        TagModule.executeShellCmd("rm -R " + this.modulname);
    }

    private void patchSourceFile(String release) throws Exception {
        String classname = release.substring(0, release.indexOf(separator));
        String filename = classname + "Class.cpp";
        if (!new File(filename).exists()) {
            return;
        }
        FileInputStream fid = new FileInputStream(filename);
        int nb = fid.available();
        byte[] inStr = new byte[nb];
        fid.read(inStr);
        String code = new String(inStr);
        fid.close();
        int start = code.indexOf("static const char *TagName");
        if (start < 0) {
            throw new Exception("\"char *TagName\" not found in " + filename);
        }
        String tagName = "$Name: ";
        if ((start = code.indexOf(tagName, start)) < 0) {
            throw new Exception("\"" + tagName + "\" not found in " + filename);
        }
        int end = code.indexOf("$", start += tagName.length());
        if (end < start) {
            throw new Exception("\"" + tagName + "\" syntax error in " + filename);
        }
        String new_code = code.substring(0, start) + release + " " + code.substring(end);
        FileOutputStream fidout = new FileOutputStream(filename);
        fidout.write(new_code.getBytes());
        fidout.close();
    }

    public static String executeShellCmd(String cmd) throws Exception {
        String str;
        Process proc = Runtime.getRuntime().exec(cmd);
        InputStream istr = proc.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(istr));
        StringBuffer sb = new StringBuffer("");
        while ((str = br.readLine()) != null) {
            sb.append(str + "\n");
        }
        proc.waitFor();
        int retVal = proc.exitValue();
        if (retVal != 0) {
            InputStream errstr = proc.getErrorStream();
            br = new BufferedReader(new InputStreamReader(errstr));
            while ((str = br.readLine()) != null) {
                System.out.println(str);
                sb.append(str + "\n");
            }
            throw new Exception("the shell command\n" + cmd + "\nreturns : " + retVal + " !\n\n" + sb.toString());
        }
        return sb.toString();
    }

    public static void displaySyntax(String message, String[] args) {
        System.out.println();
        System.out.print("TagModule ");
        for (int i = 0; i < args.length; ++i) {
            System.out.print(args[i] + " ");
        }
        System.out.println("\n\n*********    " + message + "    *******\n");
        System.out.println("TagModule -d [Module's name]");
        System.out.println("\tto display last tag");
        System.out.println("                or");
        System.out.println("TagModule <tag release>");
        System.out.println("\tto tag a module (tag must looks like ClassName:Release_1_2)");
        System.out.println("                or");
        System.out.println("TagModule -last [Module's name]  [File's name]");
        System.out.println("\tdisplay the last Tag found in file.");
        System.out.println();
        System.exit(1);
    }

    public static void main(String[] args) {
        TagModule client = null;
        String release = "";
        int mode = -1;
        String modulname = null;
        String filename = null;
        switch (args.length) {
            case 1: {
                if (args[0].equals("-d")) {
                    mode = 0;
                    break;
                }
                mode = 1;
                release = args[0];
                if (release.indexOf(separator + "Release_") > 0) break;
                TagModule.displaySyntax("Release Syntax Error !", args);
                break;
            }
            case 2: {
                if (args[0].equals("-d")) {
                    mode = 0;
                    modulname = args[1];
                    break;
                }
                if (args[0].equals("-last")) {
                    mode = 2;
                    modulname = args[1];
                    break;
                }
                TagModule.displaySyntax("Arguments Number Incorrect !", args);
                break;
            }
            case 3: {
                if (args[0].equals("-last")) {
                    mode = 2;
                    modulname = args[1];
                    filename = args[2];
                    break;
                }
                TagModule.displaySyntax("Arguments Number Incorrect !", args);
                break;
            }
            default: {
                TagModule.displaySyntax("Arguments Number Incorrect !", args);
            }
        }
        try {
            client = new TagModule(modulname);
            switch (mode) {
                case 0: {
                    String tag = client.printLastTag();
                    System.out.println("Last tag of " + client.modulname + " is " + tag);
                    break;
                }
                case 1: {
                    client.checkTags(release);
                    client.setTag(release);
                    break;
                }
                case 2: {
                    String lt = client.printTags();
                    System.out.println(lt);
                }
            }
        }
        catch (Exception e) {
            System.out.println("********************************************************************");
            System.out.println("\t" + e);
            System.out.println("********************************************************************");
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public String printTags() throws Exception {
        String cmd = "cvs history -T -a";
        System.out.println(cmd);
        String result = TagModule.executeShellCmd(cmd);
        StringTokenizer stk = new StringTokenizer(result, "\n");
        while (stk.hasMoreTokens()) {
            String line = stk.nextToken();
            StringTokenizer stk2 = new StringTokenizer(line);
            Vector<String> v = new Vector<String>();
            while (stk2.hasMoreTokens()) {
                v.add(stk2.nextToken());
            }
            if (v.size() <= 6) continue;
            String[] param = new String[7];
            for (int i = 0; i < v.size() && i < 7; ++i) {
                param[i] = (String)v.get(i);
            }
            if (!param[5].equals(this.modulname)) continue;
            param[6] = param[6].substring(1, param[6].indexOf(":A]"));
            System.out.println(param[4] + " tagged " + this.modulname + " on " + param[1] + " " + param[2] + " as " + param[6]);
        }
        return "";
    }

    public String getLastTag(String filename) throws Exception {
        String tagTag = "|A|";
        String code = PogoUtil.readFile(filename);
        Vector v = new Vector();
        StringTokenizer stk = new StringTokenizer(code, "\n");
        while (stk.hasMoreTokens()) {
            String line = stk.nextToken();
            if (!line.startsWith("T")) continue;
            Vector<String> v2 = new Vector<String>();
            StringTokenizer stk2 = new StringTokenizer(line, "|");
            while (stk2.hasMoreTokens()) {
                v2.add(stk2.nextToken());
            }
            String field_3 = (String)v2.get(3);
            String field_5 = (String)v2.get(5);
            if (!field_3.equals("A") || !field_5.equals(this.modulname)) continue;
            v.add(v2.get(4));
        }
        if (v.size() == 0) {
            return "No Tag.";
        }
        return (String)v.get(v.size() - 1);
    }

    class Tag {
        String filename;
        String tag;

        Tag(String filename, String tag) {
            this.filename = filename;
            this.tag = tag;
        }
    }
}

