/*
 * Decompiled with CFR 0.152.
 */
package pogo.make_util;

import java.util.Date;
import java.util.StringTokenizer;
import pogo.gene.PogoUtil;

public class ReleaseNote2html {
    private static final String filename = "ReleaseNote";

    public static void writeFile(String title) {
        try {
            String code = ReleaseNote2html.buildHtmPage(title);
            PogoUtil.writeFile("ReleaseNote.html", code);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void makeJavaRelease(String title, String jpackage) {
        try {
            String header = "\npackage " + jpackage + ";\n\n" + "public interface ReleaseNote\n{\n" + "\tpublic final String\tstr = \n";
            String str = ReleaseNote2html.buildHtmPage(title);
            String code = header;
            StringTokenizer stk = new StringTokenizer(str, "\n");
            while (stk.hasMoreTokens()) {
                String line = ReleaseNote2html.checkString(stk.nextToken());
                code = code + "\t\t\"" + line + "\\n\" + \n";
            }
            code = code + "\t\t\"\";\n}\n";
            PogoUtil.writeFile("ReleaseNote.java", code);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String checkString(String s) {
        int idx = 0;
        while ((idx = s.indexOf(34, idx)) >= 0) {
            s = s.substring(0, idx) + "\\" + s.substring(idx);
            idx += 2;
        }
        return s;
    }

    private static String buildHtmPage(String title) throws Exception {
        String startBold = "<li><b>";
        String stopBold = "</b>";
        String breakLine = "<Br>\n";
        String space = "&nbsp; ";
        String indent = space + space;
        String header = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<HEAD>\n<Title> Release Note </Title>\n</HEAD>\n<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" VLINK=\"#7F00FF\" ALINK=\"#FF0000\">\n<P><!-------TITLE------></P>\n\n";
        header = header + "<Center>";
        header = header + "\t<h2>" + title + "</h2>\n";
        header = header + "\t(Generated " + new Date() + ")";
        header = header + "</Center><Br>\n";
        String str = PogoUtil.readFile(filename);
        int start = 0;
        int end = 0;
        int nb = 0;
        while ((end = str.indexOf(10, start)) >= 0) {
            if (!str.substring(start, end).startsWith("#")) {
                ++nb;
            }
            start = end + 1;
        }
        String[] array = new String[nb];
        start = 0;
        int i = 0;
        while ((end = str.indexOf(10, start)) >= 0) {
            if (!str.substring(start, end).startsWith("#")) {
                array[i++] = str.substring(start, end);
            }
            start = end + 1;
        }
        String new_code = "";
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2 - 1].length() == 0 && array[i2].indexOf(58) > 0) {
                int idx = array[i2].indexOf(58) + 1;
                String revision = array[i2].substring(0, idx);
                new_code = new_code + startBold + revision + stopBold + breakLine;
                new_code = new_code + indent + array[i2].substring(idx).trim() + breakLine;
                continue;
            }
            if (array[i2].length() == 0) continue;
            new_code = new_code + indent + indent + array[i2].trim() + breakLine;
        }
        new_code = header + new_code + "</Body>\n</Html>\n";
        return new_code;
    }

    public static void displaySyntax(String message) {
        System.out.println();
        System.out.println("********  " + message + "********");
        System.out.println();
        System.out.println("ReleaseNote2html -html <page title>");
        System.out.println("\t\tor");
        System.out.println("ReleaseNote2html -java <page title> <package>");
        System.out.println();
        System.exit(1);
    }

    public static void main(String[] args) {
        switch (args.length) {
            case 2: {
                if (args[0].equals("-html")) {
                    ReleaseNote2html.writeFile(args[1]);
                    break;
                }
                ReleaseNote2html.displaySyntax(args[0] + "  invalid option for " + args.length + " arguments");
                break;
            }
            case 3: {
                if (args[0].equals("-java")) {
                    ReleaseNote2html.makeJavaRelease(args[1], args[2]);
                    break;
                }
                ReleaseNote2html.displaySyntax(args[0] + "  invalid option for " + args.length + " arguments");
                break;
            }
            default: {
                ReleaseNote2html.displaySyntax("" + args.length + "  invalid arguments number");
            }
        }
        System.exit(0);
    }
}

