/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.TangoDs.TangoConst;
import java.io.FileNotFoundException;
import java.io.IOException;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGene;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;
import pogo.gene.PropertyTable;

public class JavaServerClass
extends PogoGene
implements PogoDefs,
TangoConst {
    private PropertyTable properties;

    public JavaServerClass(PogoClass pogo) {
        super(pogo);
        this.properties = pogo.class_properties;
    }

    public void generateSource(String serverclass) throws FileNotFoundException, SecurityException, IOException, PogoException {
        String get_property;
        System.out.println("Generating " + serverclass + "....");
        String templname = this.pogo.templates_dir + "/java/" + "DevServ" + "Class.java";
        PogoString templcode = new PogoString(PogoUtil.readFile(templname));
        templcode = PogoUtil.removeLogMessages(templcode);
        while (templcode.str.indexOf("TemplateDevServ") >= 0) {
            templcode.replace("TemplateDevServ", this.pogo.class_name);
        }
        String class_constructor = null;
        if (this.already_exists(serverclass)) {
            PogoString code = new PogoString(PogoUtil.readFile(serverclass));
            class_constructor = this.getClassConstructor(code);
            get_property = this.getGetPropertyMethod(code);
        } else {
            get_property = this.getGetPropertyMethod(null);
        }
        String factories = this.buildFactories(templcode);
        if (class_constructor != null) {
            PogoString tmp = new PogoString(factories);
            String s = this.getClassConstructor(tmp);
            tmp.replace(s, class_constructor);
            factories = tmp.str;
        }
        String classname = "";
        get_property = this.properties.updateJavaMethod(get_property, "class", classname);
        factories = this.addPutGetPropertyCall(factories, "get");
        factories = this.properties.addJavaDataMembers(factories);
        factories = this.addPutGetPropertyCall(factories, "write");
        String put_property = this.buildPutPropertyMethod();
        String newcode = this.checkForDbDatumArray(factories + get_property + "\n" + put_property + "\n}\n");
        PogoUtil.writeFile(serverclass, newcode);
    }

    private String checkForDbDatumArray(String strcode) throws FileNotFoundException, SecurityException, IOException {
        int start;
        PogoString code = new PogoString(strcode);
        String declare = "\t/**\n\t *\tClass properties array.\n\t */\n\tprivate DbDatum[]\tcl_prop = null;\n\n";
        if (code.str.indexOf(declare) < 0 && (start = code.str.indexOf("\t//--------- Start of properties data members ----------")) > 0) {
            code.insert(start, declare);
        }
        if (code.str.indexOf("public DbDatum get_class_property(String name)") < 0) {
            String templname = this.pogo.templates_dir + "/java/readPropMethodName.java";
            String templcode = PogoUtil.readFile(templname);
            int end = templcode.indexOf("public void get_target_property() throws DevFailed");
            end = templcode.lastIndexOf("//", end);
            end = templcode.lastIndexOf("//", end - 1);
            String method = templcode.substring(0, end);
            start = code.str.indexOf("public void get_class_property() throws DevFailed");
            start = code.str.lastIndexOf("//", start);
            start = code.str.lastIndexOf("//", start - 1);
            code.insert(start, method);
        }
        return code.str;
    }

    protected String addPutGetPropertyCall(String readcode, String putget) throws PogoException {
        String method_call = putget + "_class_property();";
        String s = this.getClassConstructor(new PogoString(readcode));
        PogoString method_core = new PogoString(s);
        if (s.indexOf(method_call) > 0) {
            return readcode;
        }
        int start = method_core.str.indexOf("Util.out2.println");
        if (start < 0) {
            return readcode;
        }
        start = method_core.nextCr(start) + 1;
        method_core.insert(start, "\t\t" + method_call + "\n");
        PogoString newcode = new PogoString(readcode);
        newcode.replace(s, method_core.str);
        return newcode.str;
    }

    protected String buildFactories(PogoString templcode) throws PogoException {
        StringBuffer sb = new StringBuffer();
        int start = 0;
        int end = templcode.str.indexOf("command_factory");
        if (end < 0) {
            throw new PogoException("command_factory() method not found !");
        }
        end = templcode.inMethod(end);
        sb.append(templcode.str.substring(start, end));
        sb.append(this.pogo.commands.buildCommandFactoryMethod(0));
        start = templcode.outMethod(end + 1);
        start = templcode.nextCr(start);
        end = templcode.str.indexOf("device_factory");
        if (end < 0) {
            throw new PogoException("device_factory() method not found !");
        }
        end = templcode.inMethod(end);
        end = templcode.outMethod(end + 1);
        end = templcode.nextCr(end);
        sb.append(templcode.str.substring(start, end));
        if (this.pogo.attributes.size() > 0) {
            sb.append("\n//=============================================================================\n");
            sb.append("//\n//\tMethod:\tattribute_factory(Vector att_list)\n//\n");
            sb.append("//=============================================================================\n");
            sb.append("\tpublic void attribute_factory(Vector att_list) throws DevFailed\n");
            sb.append(this.pogo.attributes.buildFactory(0));
        }
        return sb.toString();
    }

    protected String getClassConstructor(PogoString readcode) throws PogoException {
        String constr_sign = "protected " + this.pogo.class_name + "Class(String name) throws DevFailed";
        int end = readcode.str.indexOf(constr_sign);
        if (end < 0) {
            throw new PogoException("Input File Syntax error !\n" + constr_sign + "\n Not found !");
        }
        end = readcode.inMethod(end + 1);
        end = readcode.outMethod(end);
        return readcode.str.substring(0, end);
    }

    protected String getGetPropertyMethod(PogoString readcode) throws FileNotFoundException, SecurityException, IOException {
        int start;
        String get_property_signature = "public void get_class_property()";
        if (readcode == null || (start = readcode.str.indexOf(get_property_signature)) < 0) {
            String templname = this.pogo.templates_dir + "/java/" + "readPropMethodName.java";
            PogoString templcode = new PogoString(PogoUtil.readFile(templname));
            templcode = PogoUtil.removeLogMessages(templcode);
            while (templcode.str.indexOf("TemplateDevServ") >= 0) {
                templcode.replace("TemplateDevServ", this.pogo.class_name + "Class");
            }
            while (templcode.str.indexOf("target") >= 0) {
                templcode.replace("target", "class");
            }
            return templcode.str;
        }
        int end = readcode.inMethod(start);
        end = readcode.outMethod(end + 1);
        while (readcode.str.charAt(start) != '}') {
            --start;
        }
        return readcode.str.substring(start += 2, end);
    }

    protected String buildPutPropertyMethod() throws FileNotFoundException, SecurityException, IOException, PogoException {
        String templname = this.pogo.templates_dir + "/java/write_property.java";
        PogoString readcode = new PogoString(PogoUtil.readFile(templname));
        readcode = PogoUtil.removeLogMessages(readcode);
        while (readcode.str.indexOf("TemplateDevServ") >= 0) {
            readcode.replace("TemplateDevServ", this.pogo.class_name);
        }
        String tag = "PogoProjectTitle";
        String pattern = "\"" + this.pogo.title + "\"";
        while (readcode.str.indexOf(tag) >= 0) {
            readcode.replace(tag, pattern);
        }
        tag = "PogoClassDescription";
        PogoString desc = new PogoString(this.pogo.class_desc);
        pattern = "\\n";
        while (desc.str.indexOf("\n") >= 0) {
            desc.replace("\n", pattern);
        }
        String tmp = desc.str;
        if (tmp.length() > 255) {
            tmp = tmp.substring(0, 255);
        }
        pattern = "\"" + tmp + "\"";
        while (readcode.str.indexOf(tag) >= 0) {
            readcode.replace(tag, pattern);
        }
        return readcode.str;
    }
}

