/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import pogo.appli.PogoAppli;
import pogo.appli.PogoAppliDefs;
import pogo.gene.PogoDefs;
import pogo.gene.PogoString;
import pogo.gene.Property;

public class PropertyDialog
extends JDialog
implements PogoAppliDefs,
PogoDefs {
    private static int returnStatus = 0;
    private JFrame parent;
    private JPanel jPanel1;
    private JButton okBtn;
    private JButton cancelBtn;
    private JPanel jPanel2;
    private JLabel typeLbl;
    private JLabel descLbl;
    private JComboBox typeBox;
    private JLabel nameLbl;
    private JTextField nameText;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTextArea descText;
    private JScrollPane jScrollPane2;
    private JTextArea valTxt;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel5;
    private JLabel titleLabel;

    public PropertyDialog(JFrame parent, Property property, String title) {
        super((Frame)parent, true);
        this.parent = parent;
        this.initComponents();
        for (int i = 0; i < PogoAppliDefs.TangoPropertyTypesArray.length; ++i) {
            this.typeBox.addItem(PogoAppliDefs.TangoPropertyTypesArray[i]);
        }
        this.initializeWindow(property);
        this.titleLabel.setText(title);
        this.pack();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.typeLbl = new JLabel();
        this.descLbl = new JLabel();
        this.typeBox = new JComboBox();
        this.nameLbl = new JLabel();
        this.nameText = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.descText = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.valTxt = new JTextArea();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jPanel5 = new JPanel();
        this.titleLabel = new JLabel();
        this.setTitle("Edit Property Window");
        this.setBackground(new Color(198, 178, 168));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PropertyDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new FlowLayout(2));
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertyDialog.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertyDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setLayout(new GridBagLayout());
        this.typeLbl.setText("Property type");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.insets = new Insets(0, 3, 0, 0);
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.typeLbl, gridBagConstraints1);
        this.descLbl.setText("Property Description:  ");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.insets = new Insets(0, 3, 0, 0);
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.descLbl, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.typeBox, gridBagConstraints1);
        this.nameLbl.setText("Property name");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(0, 3, 0, 0);
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.nameLbl, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = 2;
        this.jPanel2.add((Component)this.nameText, gridBagConstraints1);
        this.jLabel1.setText("Default value :");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 7;
        gridBagConstraints1.insets = new Insets(0, 3, 0, 0);
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints1);
        this.jScrollPane1.setForeground(Color.lightGray);
        this.jScrollPane1.setPreferredSize(new Dimension(450, 150));
        this.descText.setColumns(80);
        this.descText.setMinimumSize(new Dimension(0, 100));
        this.descText.setPreferredSize(new Dimension(1408, 400));
        this.jScrollPane1.setViewportView(this.descText);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.gridwidth = 3;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 3, 0, 3);
        gridBagConstraints1.weightx = 1.0;
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints1);
        this.jScrollPane2.setForeground(Color.lightGray);
        this.jScrollPane2.setPreferredSize(new Dimension(450, 100));
        this.valTxt.setColumns(80);
        this.valTxt.setMinimumSize(new Dimension(0, 100));
        this.valTxt.setPreferredSize(new Dimension(880, 400));
        this.jScrollPane2.setViewportView(this.valTxt);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 8;
        gridBagConstraints1.gridwidth = 3;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 3, 0, 3);
        this.jPanel2.add((Component)this.jScrollPane2, gridBagConstraints1);
        this.jLabel2.setText("  ");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints1);
        this.jLabel3.setText("   ");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 6;
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints1);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("jLabel4");
        this.jPanel5.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel5, "North");
    }

    private String verifyDefaultValue() {
        String err_mess = null;
        String type = this.typeBox.getSelectedItem().toString().toLowerCase();
        String[] def_val = new PogoString(this.valTxt.getText().trim()).string2array();
        if (type.indexOf("array") < 0 && def_val.length > 1) {
            err_mess = "Property's default value is not coherent with selected type !";
        }
        for (int i = 0; i < def_val.length; ++i) {
            try {
                if (type.indexOf("float") >= 0 || type.indexOf("double") >= 0) {
                    Double.parseDouble(def_val[i]);
                    continue;
                }
                if (type.indexOf("short") >= 0 || type.indexOf("long") >= 0) {
                    Integer.parseInt(def_val[i]);
                    continue;
                }
                if (type.indexOf("boolean") < 0 || def_val[i].toLowerCase().equals("true") || def_val[i].toLowerCase().equals("false")) continue;
                err_mess = "Property's default value is not coherent with selected type !\nA boolean value must be  false or true";
                continue;
            }
            catch (Exception e) {
                err_mess = "Property's default value is not coherent with selected type !\n" + e.toString();
            }
        }
        return err_mess;
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        String err_mess = null;
        err_mess = this.nameText.getText().length() <= 0 ? "Property's name must be filled in !" : this.verifyDefaultValue();
        if (err_mess != null) {
            JOptionPane.showMessageDialog(this, err_mess, "Error Window", 0);
        } else {
            this.doClose(1);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    private void setComboBoxIdx(String str) {
        boolean found = false;
        for (int i = 0; i < PogoAppliDefs.TangoPropertyTypesArray.length; ++i) {
            if (!PogoAppliDefs.TangoPropertyTypesArray[i].equals(str)) continue;
            this.typeBox.setSelectedIndex(i);
            found = true;
        }
        if (!found) {
            if (str.equals("Tango::DEVVAR_SHORTARRAY")) {
                this.setComboBoxIdx("Array of short");
            } else if (str.equals("Tango::DEVVAR_LONGARRAY")) {
                this.setComboBoxIdx("Array of long");
            } else if (str.equals("Tango::DEVVAR_FLOATARRAY")) {
                this.setComboBoxIdx("Array of float");
            } else if (str.equals("Tango::DEVVAR_DOUBLEARRAY")) {
                this.setComboBoxIdx("Array of double");
            } else if (str.equals("Tango::DEVVAR_STRINGARRAY")) {
                this.setComboBoxIdx("Array of string");
            }
        }
    }

    private void initializeWindow(Property property) {
        if (property != null) {
            if (property.type.code == -2 || property.type.code == 8) {
                property.type.cpp_code_str = new String("string");
            }
            this.nameText.setText(property.name);
            this.setComboBoxIdx(property.type.cpp_code_str);
            if (property.description != null) {
                this.descText.setText(property.description);
            }
            if (property.default_value != null) {
                this.valTxt.setText(property.default_value);
            }
        }
    }

    public int showDialog() {
        PogoAppli.centerDialog(this, this.parent);
        this.setVisible(true);
        return returnStatus;
    }

    public Property getInput() {
        StringTokenizer stk = new StringTokenizer(this.nameText.getText());
        String name = stk.nextToken();
        if (name.charAt(0) >= 'a' || name.charAt(0) >= 'z') {
            char car = (char)(name.charAt(0) - 32);
            name = new String(car + name.substring(1));
        }
        String type = this.typeBox.getSelectedItem().toString();
        return new Property(name, type, this.descText.getText(), this.valTxt.getText().trim());
    }
}

