/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import pogo.appli.PogoAppli;
import pogo.appli.PogoAppliDefs;
import pogo.gene.DevState;
import pogo.gene.DevStateTable;
import pogo.gene.PogoDefs;

public class NotAllowedDialog
extends JDialog
implements PogoAppliDefs,
PogoDefs {
    private static int returnStatus = 0;
    private Vector stVector;
    private JRadioButton[] radioBtn;
    private JPanel jPanel1;
    private JButton okBtn;
    private JButton cancelBtn;
    private JPanel jPanel2;
    private JLabel nameLbl;

    public NotAllowedDialog(JFrame parent, String allow_what, Vector stVect) {
        super((Frame)parent, true);
        this.stVector = stVect;
        this.initComponents();
        this.setTitle(allow_what + " Allowed For States");
        this.nameLbl.setText(allow_what + " Allowed For States:");
        this.pack();
        PogoAppli.centerDialog(this, parent);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.nameLbl = new JLabel();
        this.setBackground(new Color(198, 178, 168));
        this.setTitle("Command Allowed Window");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                NotAllowedDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new FlowLayout(2, 5, 5));
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NotAllowedDialog.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NotAllowedDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setLayout(new GridBagLayout());
        this.nameLbl.setText("Command Allowed for Selected States: ");
        this.nameLbl.setForeground(Color.black);
        this.nameLbl.setFont(new Font("Arial", 1, 14));
        this.nameLbl.setPreferredSize(new Dimension(400, 40));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.nameLbl, gridBagConstraints1);
        this.radioBtn = new JRadioButton[this.stVector.size()];
        for (int i = 0; i < this.stVector.size(); ++i) {
            DevState state = (DevState)this.stVector.elementAt(i);
            this.radioBtn[i] = new JRadioButton(state.name);
            this.radioBtn[i].setFont(new Font("Arial", 1, 12));
            this.radioBtn[i].setSelected(true);
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = i + 2;
            gridBagConstraints1.anchor = 17;
            this.jPanel2.add((Component)this.radioBtn[i], gridBagConstraints1);
        }
        this.getContentPane().add((Component)this.jPanel2, "Center");
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    public int showDialog(DevStateTable stTable) {
        if (stTable != null) {
            for (int i = 0; i < stTable.size(); ++i) {
                for (int j = 0; j < this.radioBtn.length; ++j) {
                    DevState state = (DevState)stTable.elementAt(i);
                    if (!state.name.equals(this.radioBtn[j].getText())) continue;
                    this.radioBtn[j].setSelected(false);
                }
            }
        }
        this.setVisible(true);
        return returnStatus;
    }

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public DevStateTable getInput() {
        Vector forbStates = new Vector();
        for (int i = 0; i < this.stVector.size(); ++i) {
            if (this.radioBtn[i].getSelectedObjects() != null) continue;
            forbStates.addElement(this.stVector.elementAt(i));
        }
        return new DevStateTable(forbStates);
    }
}

