/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import app_util.PopupError;
import fr.esrf.Tango.DispLevel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import pogo.appli.EditDialog;
import pogo.appli.NotAllowedDialog;
import pogo.appli.PogoAppli;
import pogo.appli.PogoAppliDefs;
import pogo.gene.Cmd;
import pogo.gene.DevStateTable;
import pogo.gene.PogoClass;
import pogo.gene.PogoException;
import pogo.gene.PogoUtil;

public class CommandDialog
extends JDialog
implements PogoAppliDefs {
    private static String cmd_gotten = "";
    private JFrame parent;
    private DevStateTable notAllowedFor;
    private int returnStatus = 0;
    private int poll_period = 0;
    private PogoClass server;
    private int cmd_idx = -1;
    private String cmd_name;
    private JButton allowedBtn;
    private JComboBox arginComboBox;
    private JButton arginDescBtn;
    private JTextField arginDescText;
    private JComboBox argoutComboBox;
    private JButton argoutDecBtn;
    private JTextField argoutDescText;
    private JButton cancelBtn;
    private JTextArea cmdDescText;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JComboBox nameComboBox;
    private JLabel nameLbl;
    private JButton okBtn;
    private JRadioButton levelBtn;
    private JRadioButton polledBtn;
    private JLabel periodLabel;
    private JLabel periodUnitLabel;
    private JTextField periodText;

    public CommandDialog(JFrame parent, PogoClass server, Cmd cmd, int action) {
        super((Frame)parent, true);
        int i;
        this.parent = parent;
        this.server = server;
        this.initComponents();
        this.addElements();
        for (i = 0; i < PogoAppliDefs.standardCommandNames.length; ++i) {
            this.nameComboBox.addItem(PogoAppliDefs.standardCommandNames[i]);
        }
        for (i = 0; i < PogoAppliDefs.TangoTypesArray.length; ++i) {
            this.arginComboBox.addItem(PogoAppliDefs.TangoTypesArray[i]);
            this.argoutComboBox.addItem(PogoAppliDefs.TangoTypesArray[i]);
        }
        this.arginComboBox.setMaximumRowCount(12);
        this.argoutComboBox.setMaximumRowCount(12);
        if (cmd == null || action == 0) {
            this.cmd_idx = -1;
        } else {
            for (i = 0; i < server.commands.size(); ++i) {
                if (server.commands.cmdAt(i) != cmd) continue;
                this.cmd_idx = i;
            }
        }
        this.initializeDialogFromCmd(cmd);
        this.pack();
    }

    private void addElements() {
        this.levelBtn = new JRadioButton();
        this.levelBtn.setToolTipText("Display Level (expert or operator)");
        this.levelBtn.setText(" Expert Only  ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.jPanel2.add((Component)new JLabel("  "), gbc);
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.jPanel2.add((Component)this.levelBtn, gbc);
        this.polledBtn = new JRadioButton();
        this.polledBtn.setToolTipText("Command polled.");
        this.polledBtn.setText(" Polled ");
        gbc.gridx = 4;
        gbc.gridy = 1;
        gbc.fill = 2;
        this.jPanel2.add((Component)this.polledBtn, gbc);
        this.polledBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.polledBtnActionPerformed(evt);
            }
        });
        this.arginComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.arginCBActionPerformed(evt);
            }
        });
        this.periodLabel = new JLabel("Period :");
        this.periodLabel.setHorizontalAlignment(4);
        gbc.gridx = 3;
        gbc.gridy = 4;
        this.jPanel2.add((Component)this.periodLabel, gbc);
        this.periodText = new JTextField();
        gbc.gridx = 4;
        gbc.gridy = 4;
        gbc.fill = 2;
        this.jPanel2.add((Component)this.periodText, gbc);
        this.periodText.setRequestFocusEnabled(true);
        this.periodUnitLabel = new JLabel(" ms  ");
        gbc.gridx = 5;
        gbc.gridy = 4;
        this.jPanel2.add((Component)this.periodUnitLabel, gbc);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.nameLbl = new JLabel();
        this.jLabel1 = new JLabel();
        this.arginComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.argoutComboBox = new JComboBox();
        this.jLabel8 = new JLabel();
        this.arginDescText = new JTextField();
        this.jLabel4 = new JLabel();
        this.argoutDescText = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.allowedBtn = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.cmdDescText = new JTextArea();
        this.nameComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel7 = new JLabel();
        this.arginDescBtn = new JButton();
        this.argoutDecBtn = new JButton();
        this.setTitle("Command Window");
        this.setBackground(new Color(198, 178, 168));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CommandDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new FlowLayout(2));
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setMinimumSize(new Dimension(220, 230));
        this.nameLbl.setText("Command Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.nameLbl, gridBagConstraints);
        this.jLabel1.setText("Argin Type:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.jPanel2.add((Component)this.arginComboBox, gridBagConstraints);
        this.jLabel2.setText("Argout Type:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        this.jPanel2.add((Component)this.argoutComboBox, gridBagConstraints);
        this.jLabel8.setText("Argin Description:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jLabel8, gridBagConstraints);
        this.arginDescText.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.arginDescText, gridBagConstraints);
        this.jLabel4.setText("Argout Description:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.argoutDescText.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.argoutDescText, gridBagConstraints);
        this.jLabel5.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText("Command Description:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        this.allowedBtn.setText("Command Allowed For States....");
        this.allowedBtn.setBorder(new BevelBorder(0));
        this.allowedBtn.setPreferredSize(new Dimension(167, 30));
        this.allowedBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.allowedBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.allowedBtn, gridBagConstraints);
        this.jScrollPane1.setForeground(Color.lightGray);
        this.jScrollPane1.setPreferredSize(new Dimension(500, 150));
        this.cmdDescText.setColumns(80);
        this.cmdDescText.setMinimumSize(new Dimension(0, 100));
        this.cmdDescText.setPreferredSize(new Dimension(880, 400));
        this.jScrollPane1.setViewportView(this.cmdDescText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.nameComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.nameComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanel2.add((Component)this.nameComboBox, gridBagConstraints);
        this.jLabel3.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel7.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanel2.add((Component)this.jLabel7, gridBagConstraints);
        this.arginDescBtn.setText("....");
        this.arginDescBtn.setMargin(new Insets(2, 8, 2, 8));
        this.arginDescBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.arginDescBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.arginDescBtn, gridBagConstraints);
        this.argoutDecBtn.setText("....");
        this.argoutDecBtn.setMargin(new Insets(2, 8, 2, 8));
        this.argoutDecBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.argoutDecBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.argoutDecBtn, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel2, "Center");
    }

    private void arginDescBtnActionPerformed(ActionEvent evt) {
        EditDialog dialog = new EditDialog(this.parent, this.arginDescText.getText());
        if (dialog.showDialog() == 1) {
            this.arginDescText.setText(dialog.getText());
        }
    }

    private void argoutDecBtnActionPerformed(ActionEvent evt) {
        EditDialog dialog = new EditDialog(this.parent, this.argoutDescText.getText());
        if (dialog.showDialog() == 1) {
            this.argoutDescText.setText(dialog.getText());
        }
    }

    private void polledBtnActionPerformed(ActionEvent evt) {
        boolean state = this.polledBtn.getSelectedObjects() != null;
        this.setPeriodEnabled(state);
        if (state) {
            this.periodText.selectAll();
            this.periodText.requestFocus();
        }
    }

    private void arginCBActionPerformed(ActionEvent evt) {
        switch (this.arginComboBox.getSelectedIndex()) {
            case 0: {
                this.polledBtn.setEnabled(true);
                break;
            }
            default: {
                this.polledBtn.setEnabled(false);
                this.polledBtn.setSelected(false);
                this.setPeriodEnabled(false);
            }
        }
    }

    private void nameComboBoxActionPerformed(ActionEvent evt) {
        String cmd_name = this.nameComboBox.getSelectedItem().toString();
        if (cmd_name.equals(PogoAppliDefs.specif_cmd)) {
            String newCmd = null;
            do {
                if ((newCmd = (String)JOptionPane.showInputDialog(this, "Command Name", "Input Dialog", 1, null, null, cmd_gotten)) == null) {
                    boolean found = false;
                    for (int i = 0; i < this.nameComboBox.getItemCount(); ++i) {
                        String item = (String)this.nameComboBox.getItemAt(i);
                        if (!item.equals(cmd_gotten)) continue;
                        this.nameComboBox.setSelectedIndex(i);
                        found = true;
                    }
                    if (!found) {
                        this.nameComboBox.setSelectedIndex(0);
                    }
                    return;
                }
                cmd_gotten = newCmd;
            } while (newCmd == null);
            this.initializeCmdComboBox(newCmd);
        }
    }

    public void initializeCmdComboBox(String cmd) {
        int i;
        boolean std_cmd = false;
        for (i = 0; i < PogoAppliDefs.standardCommandNames.length; ++i) {
            if (!PogoAppliDefs.standardCommandNames[i].equals(cmd)) continue;
            std_cmd = true;
            this.nameComboBox.setSelectedIndex(i);
        }
        if (std_cmd) {
            return;
        }
        for (i = 0; i < this.nameComboBox.getItemCount(); ++i) {
            String item = ((String)this.nameComboBox.getItemAt(i)).toLowerCase();
            if (!item.equals(cmd.toLowerCase())) continue;
            this.nameComboBox.setSelectedIndex(i);
            return;
        }
        int pos = this.nameComboBox.getItemCount() - 1;
        this.nameComboBox.insertItemAt(cmd, pos);
        this.nameComboBox.setSelectedIndex(pos);
    }

    public int showDialog() {
        PogoAppli.centerDialog(this, this.parent);
        this.setVisible(true);
        return this.returnStatus;
    }

    private void initializeDialogFromCmd(Cmd cmd) {
        if (cmd != null) {
            this.initializeCmdComboBox(cmd.name);
            for (int i = 0; i < PogoAppliDefs.TangoTypesArray.length; ++i) {
                if (PogoAppliDefs.TangoTypesArray[i].equals(cmd.argin.cpp_code_str)) {
                    this.arginComboBox.setSelectedIndex(i);
                }
                if (!PogoAppliDefs.TangoTypesArray[i].equals(cmd.argout.cpp_code_str)) continue;
                this.argoutComboBox.setSelectedIndex(i);
            }
            if (cmd.argin.description != null) {
                this.arginDescText.setText(cmd.argin.description);
            }
            if (cmd.argout.description != null) {
                this.argoutDescText.setText(cmd.argout.description);
            }
            if (cmd.description != null) {
                this.cmdDescText.setText(cmd.description);
            }
            this.notAllowedFor = new DevStateTable(cmd.notAllowedFor);
            if (cmd.level == DispLevel.EXPERT) {
                this.levelBtn.setSelected(true);
            }
            if ((this.poll_period = cmd.polled_period) > 0) {
                this.polledBtn.setSelected(true);
                this.setPeriodEnabled(true);
            } else {
                this.setPeriodEnabled(false);
            }
        }
    }

    private void allowedBtnActionPerformed(ActionEvent evt) {
        if (this.server.states.size() == 0) {
            JOptionPane.showMessageDialog(this, "There is no state defined !", "Error Window", 0);
            return;
        }
        String cmd_name = this.nameComboBox.getSelectedItem().toString();
        NotAllowedDialog dialog = new NotAllowedDialog(this.parent, "Command " + cmd_name, this.server.states);
        int ret = dialog.showDialog(this.notAllowedFor);
        if (ret == 1) {
            this.notAllowedFor = dialog.getInput();
        }
    }

    private void nameTextActionPerformed(ActionEvent evt) {
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private int controlPeriodText() {
        if (this.polledBtn.getSelectedObjects() != null) {
            String s = this.periodText.getText();
            try {
                this.poll_period = Integer.parseInt(s);
                if (this.poll_period < 20) {
                    PopupError.show((Component)this.parent, "The polling period minimum value is  20 ms");
                    return -1;
                }
                return 1;
            }
            catch (Exception e) {
                PopupError.show((Component)this.parent, e.toString() + "\n\nBad Value in Polling period field !");
                return -1;
            }
        }
        return 1;
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.cmd_name = this.nameComboBox.getSelectedItem().toString();
        try {
            this.cmd_name = PogoUtil.checkCmdAttrName(this.cmd_name, this.server.commands, this.server.attributes, this.cmd_idx, 2);
        }
        catch (PogoException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Error Window", 1);
            return;
        }
        cmd_gotten = new String(this.cmd_name);
        if (this.controlPeriodText() == 1) {
            this.doClose(1);
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public Cmd getInput() {
        DispLevel level = this.levelBtn.getSelectedObjects() == null ? DispLevel.OPERATOR : DispLevel.EXPERT;
        Cmd cmd = new Cmd(this.cmd_name, this.cmd_name + "Cmd", this.arginComboBox.getSelectedItem().toString(), this.argoutComboBox.getSelectedItem().toString(), this.arginDescText.getText(), this.argoutDescText.getText(), this.cmdDescText.getText(), level);
        if (this.notAllowedFor == null) {
            this.notAllowedFor = new DevStateTable();
        }
        cmd.setNotAllowedFor(this.notAllowedFor);
        cmd.polled_period = this.polledBtn.getSelectedObjects() != null ? this.poll_period : 0;
        return cmd;
    }

    private void setPeriodEnabled(boolean state) {
        this.periodLabel.setVisible(state);
        this.periodText.setVisible(state);
        this.periodUnitLabel.setVisible(state);
        if (state) {
            String txt = this.poll_period == 0 ? "2000" : "" + this.poll_period;
            this.periodText.setText(txt);
        }
        this.pack();
    }
}

