/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IBooleanImage;
import fr.esrf.tangoatk.core.IBooleanImageListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.BooleanImageHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class BooleanImage
extends AAttribute
implements IBooleanImage {
    BooleanImageHelper imageHelper = new BooleanImageHelper(this);
    boolean[][] imageValue = null;

    public boolean[][] getValue() {
        return this.imageValue;
    }

    public void setValue(boolean[][] blArray) {
        try {
            this.checkDimensions(blArray);
            this.insert(this.imageHelper.flatten(blArray));
            this.writeAtt();
            this.imageHelper.fireImageValueChanged(blArray, System.currentTimeMillis());
        }
        catch (DevFailed devFailed) {
            this.setAttError("Couldn't set value", new AttributeSetException(devFailed));
        }
        catch (Exception exception) {
            this.setAttError("Couldn't set value", new ATKException(exception));
        }
    }

    void insert(boolean[] blArray) {
        this.imageHelper.insert(blArray);
    }

    public void refresh() {
        DeviceAttribute deviceAttribute = null;
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                deviceAttribute = this.readValueFromNetwork();
                if (deviceAttribute == null) {
                    return;
                }
                this.imageValue = this.imageHelper.getBooleanImageValue(deviceAttribute);
                this.fireValueChanged(this.imageValue);
            }
            catch (DevFailed devFailed) {
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
        }
        catch (Exception exception) {
            System.out.println("BooleanImage.refresh() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("BooleanImage.refresh()------------------------------------------------");
        }
    }

    public void dispatch(DeviceAttribute deviceAttribute) {
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                this.setState(deviceAttribute);
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.imageValue = this.imageHelper.getBooleanImageValue(deviceAttribute);
                this.fireValueChanged(this.imageValue);
            }
            catch (DevFailed devFailed) {
                this.dispatchError(devFailed);
            }
        }
        catch (Exception exception) {
            System.out.println("BooleanImage.dispatch() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("BooleanImage.dispatch()------------------------------------------------");
        }
    }

    public void dispatchError(DevFailed devFailed) {
        this.imageValue = null;
        this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
    }

    public boolean isWritable() {
        return super.isWritable();
    }

    protected void fireValueChanged(boolean[][] blArray) {
        this.imageHelper.fireImageValueChanged(blArray, this.timeStamp);
    }

    public void addBooleanImageListener(IBooleanImageListener iBooleanImageListener) {
        this.imageHelper.addBooleanImageListener(iBooleanImageListener);
        this.addStateListener(iBooleanImageListener);
    }

    public void removeBooleanImageListener(IBooleanImageListener iBooleanImageListener) {
        this.imageHelper.removeBooleanImageListener(iBooleanImageListener);
        this.removeStateListener(iBooleanImageListener);
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
        ++this.periodicCount;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(128, "BooleanImage.periodic method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoPeriodicEvent.getValue();
            this.trace(128, "BooleanImage.periodicEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(128, "BooleanImage.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "BooleanImage.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(128, "BooleanImage.periodicEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(128, "BooleanImage.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            System.out.println("BooleanImage.periodic.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("BooleanImage.periodic.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.imageValue = this.imageHelper.getBooleanImageValue(deviceAttribute);
                this.fireValueChanged(this.imageValue);
            }
            catch (DevFailed devFailed) {
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                System.out.println("BooleanImage.periodic.extractBoolean() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("BooleanImage.periodic.extractBoolean()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
        ++this.changeCount;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(32, "BooleanImage.change method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoChangeEvent.getValue();
            this.trace(32, "BooleanImage.changeEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(32, "BooleanImage.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "BooleanImage.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(32, "BooleanImage.changeEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(32, "BooleanImage.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            System.out.println("BooleanImage.change.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("BooleanImage.change.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.imageValue = this.imageHelper.getBooleanImageValue(deviceAttribute);
                this.fireValueChanged(this.imageValue);
            }
            catch (DevFailed devFailed) {
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                System.out.println("BooleanImage.change.extractBoolean() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("BooleanImage.change.extractBoolean()------------------------------------------------");
            }
        }
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    public String getVersion() {
        return "$Id: BooleanImage.java,v 1.4 2005/12/02 15:41:03 jlpons Exp $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }
}

