/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.tangoatk.core.AEntityFactory;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IEntityCollection;
import fr.esrf.tangoatk.core.IEntityFilter;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IRefresherListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.Refresher;
import fr.esrf.tangoatk.core.util.AtkTimer;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;

public abstract class AEntityList
extends DefaultListModel
implements IEntityCollection,
ComboBoxModel {
    protected int refreshInterval = 1000;
    protected AEntityFactory factory;
    protected Refresher refresher = null;
    protected static ThreadGroup refreshers = new ThreadGroup("listRefreshers");
    protected transient AtkTimer timer = AtkTimer.getInstance();
    protected List errorListeners = new Vector();
    protected List refresherListeners = new Vector();
    protected List setErrorListeners = new Vector();
    protected IEntity selectedItem;
    boolean refresherStarted = false;
    protected IEntityFilter filter = new IEntityFilter(){

        public boolean keep(IEntity iEntity) {
            return true;
        }
    };
    protected boolean synchronizedPeriod = false;
    protected boolean traceUnexpected = false;
    private static String VERSION = "$Id: AEntityList.java,v 1.23 2006/01/17 12:26:36 ounsy Exp $";

    public void setRefreshInterval(int n) {
        this.refreshInterval = n;
        if (this.refresher != null) {
            this.refresher.setRefreshInterval(this.refreshInterval);
        }
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(Object object) {
        this.selectedItem = (IEntity)object;
    }

    public void refresh() {
        IEntity iEntity = null;
        long l = System.currentTimeMillis();
        this.trace(4, "AEntityList.refresh()  ", l);
        for (int i = 0; i < this.size(); ++i) {
            IAttribute iAttribute;
            iEntity = (IEntity)this.get(i);
            if (!iEntity.getDevice().doesEvent()) {
                this.trace(4, "AEntityList.refresh() : device is not event compatible; will call refresh for " + iEntity.getName(), l);
                iEntity.refresh();
                continue;
            }
            if (!(iEntity instanceof IAttribute) || (iAttribute = (IAttribute)iEntity).hasEvents()) continue;
            this.trace(4, "AEntityList.refresh() : attribute has not subscribed event; will call refresh for " + iEntity.getName(), l);
            iEntity.refresh();
        }
    }

    public boolean isRefresherStarted() {
        return this.refresherStarted;
    }

    public void stopRefresher() {
        if (this.refresher != null) {
            this.refresher.stop = true;
        }
        this.refresher = null;
        this.refresherStarted = false;
    }

    public void startRefresher() {
        if (this.refresher == null) {
            this.refresher = new Refresher("ListRefresher");
            this.refresher.setRefreshInterval(this.getRefreshInterval());
            this.refresher.setSynchronizedPeriod(this.synchronizedPeriod);
            this.refresher.setTraceUnexpected(this.traceUnexpected);
        }
        this.refresher.addRefreshee(this).start();
        this.refresherStarted = true;
    }

    public void setRefresher(Refresher refresher) {
        if (refresher != null) {
            this.synchronizedPeriod = refresher.isSynchronizedPeriod();
            this.traceUnexpected = refresher.isTraceUnexpected();
        }
        this.refresher = refresher;
    }

    public void setFilter(IEntityFilter iEntityFilter) {
        this.filter = iEntityFilter;
    }

    public IEntityFilter getFilter() {
        return this.filter;
    }

    public List get(String[] stringArray) {
        Vector<IEntity> vector = new Vector<IEntity>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(this.get(stringArray[i]));
        }
        return vector;
    }

    public IEntity get(String string) {
        for (int i = 0; i < this.size(); ++i) {
            IEntity iEntity = (IEntity)this.get(i);
            if (!iEntity.getName().equals(string)) continue;
            return iEntity;
        }
        return null;
    }

    public void add(String[] stringArray) throws ConnectionException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            this.add(stringArray[i]);
        }
    }

    public void add(IEntity iEntity) {
        int n;
        if (this.contains(iEntity)) {
            return;
        }
        if (!this.filter.keep(iEntity)) {
            return;
        }
        if (this.errorListeners != null) {
            for (n = 0; n < this.errorListeners.size(); ++n) {
                iEntity.addErrorListener((IErrorListener)this.errorListeners.get(n));
            }
        }
        if (iEntity instanceof IAttribute && this.setErrorListeners != null) {
            for (n = 0; n < this.setErrorListeners.size(); ++n) {
                ((IAttribute)iEntity).addSetErrorListener((ISetErrorListener)this.setErrorListeners.get(n));
            }
        }
        this.addElement(iEntity);
    }

    public IEntity add(String string) throws ConnectionException {
        IEntity iEntity = this.get(string);
        if (iEntity == null) {
            List list = null;
            try {
                list = this.factory.getEntities(string);
            }
            catch (ConnectionException connectionException) {
                if (AEntityFactory.isWildCard(string)) {
                    string = string.substring(0, string.length() - 2);
                }
                this.fireErrorEvent(connectionException, string);
                throw connectionException;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int n;
                iEntity = (IEntity)iterator.next();
                if (iEntity == null || this.contains(iEntity) || !this.filter.keep(iEntity)) continue;
                if (this.errorListeners != null) {
                    for (n = 0; n < this.errorListeners.size(); ++n) {
                        iEntity.addErrorListener((IErrorListener)this.errorListeners.get(n));
                    }
                }
                if (iEntity instanceof IAttribute && this.setErrorListeners != null) {
                    for (n = 0; n < this.setErrorListeners.size(); ++n) {
                        ((IAttribute)iEntity).addSetErrorListener((ISetErrorListener)this.setErrorListeners.get(n));
                    }
                }
                this.addElement(iEntity);
            }
        }
        return iEntity;
    }

    public boolean remove(String string) {
        IEntity iEntity = this.get(string);
        int n = this.indexOf(iEntity);
        return n >= 0 && this.remove(n) != null;
    }

    public void addErrorListener(IErrorListener iErrorListener) {
        this.errorListeners.add(iErrorListener);
    }

    public void addSetErrorListener(ISetErrorListener iSetErrorListener) {
        this.setErrorListeners.add(iSetErrorListener);
    }

    public void removeErrorListener(IErrorListener iErrorListener) {
        IEntity iEntity = null;
        if (iErrorListener == null) {
            return;
        }
        if (this.errorListeners.contains(iErrorListener)) {
            for (int i = 0; i < this.size(); ++i) {
                iEntity = (IEntity)this.get(i);
                iEntity.removeErrorListener(iErrorListener);
            }
            try {
                this.errorListeners.remove(iErrorListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void removeSetErrorListener(ISetErrorListener iSetErrorListener) {
        IEntity iEntity = null;
        IAttribute iAttribute = null;
        if (iSetErrorListener == null) {
            return;
        }
        if (this.setErrorListeners.contains(iSetErrorListener)) {
            for (int i = 0; i < this.size(); ++i) {
                iEntity = (IEntity)this.get(i);
                if (!(iEntity instanceof IAttribute)) continue;
                iAttribute = (IAttribute)iEntity;
                iAttribute.removeSetErrorListener(iSetErrorListener);
            }
            try {
                this.setErrorListeners.remove(iSetErrorListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addRefresherListener(IRefresherListener iRefresherListener) {
        if (!this.refresherListeners.contains(iRefresherListener)) {
            this.refresherListeners.add(iRefresherListener);
        }
    }

    public void removeRefresherListener(IRefresherListener iRefresherListener) {
        this.refresherListeners.remove(iRefresherListener);
    }

    public void clearRefresherListener() {
        this.refresherListeners.clear();
    }

    protected void fireRefresherStepEvent() {
        int n = this.refresherListeners.size();
        for (int i = 0; i < n; ++i) {
            IRefresherListener iRefresherListener = (IRefresherListener)this.refresherListeners.get(i);
            try {
                iRefresherListener.refreshStep();
                continue;
            }
            catch (Exception exception) {
                System.out.println("AEntityList.fireRefresherStepEvent() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("AEntityList.fireRefresherStepEvent()------------------------------------------------");
            }
        }
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    private void fireErrorEvent(ConnectionException connectionException, String string) {
        if (this.errorListeners != null) {
            for (int i = 0; i < this.errorListeners.size(); ++i) {
                ((IErrorListener)this.errorListeners.get(i)).errorChange(new ErrorEvent(string, connectionException, System.currentTimeMillis()));
            }
        }
    }

    public void finalize() {
        this.stopRefresher();
    }

    public String getVersion() {
        return VERSION;
    }

    public void setSynchronizedPeriod(boolean bl) {
        this.synchronizedPeriod = bl;
        if (this.refresher == null) {
            this.refresher = new Refresher("ListRefresher");
            this.refresher.setRefreshInterval(this.getRefreshInterval());
        }
        this.refresher.setSynchronizedPeriod(this.synchronizedPeriod);
        this.refresher.setTraceUnexpected(this.traceUnexpected);
    }

    public void setTraceUnexpected(boolean bl) {
        this.traceUnexpected = bl;
        if (this.refresher == null) {
            this.refresher = new Refresher("ListRefresher");
            this.refresher.setRefreshInterval(this.getRefreshInterval());
        }
        this.refresher.setSynchronizedPeriod(this.synchronizedPeriod);
        this.refresher.setTraceUnexpected(this.traceUnexpected);
    }
}

