/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import pogo.gene.Attrib;
import pogo.gene.Cmd;
import pogo.gene.CmdTable;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;

public class PogoUtil
implements PogoDefs {
    private static PogoUtil instance = null;
    static final String[] cpp_target = new String[]{"Inherited from class ", ": public Tango::Device_3Impl", ": public Tango::Device_2Impl", ": public Tango::DeviceImpl"};
    private static final String[] java_target = new String[]{" extends DeviceImpl implements TangoConst"};
    private static String attrSoleil = null;
    private static boolean test_mode = false;
    private static boolean test_mode_read = false;
    private static final String logfile = "/tmp/pogo.log";

    private PogoUtil() {
    }

    public static PogoUtil getInstance() {
        if (instance == null) {
            instance = new PogoUtil();
        }
        return instance;
    }

    public static boolean isDeviceImplClass(String filename) {
        try {
            int i;
            String readcode = PogoUtil.readFile(filename);
            for (i = 0; i < cpp_target.length; ++i) {
                if (readcode.indexOf(cpp_target[i]) <= 0) continue;
                return true;
            }
            for (i = 0; i < java_target.length; ++i) {
                if (readcode.indexOf(java_target[i]) <= 0) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean checkIfSuperclass(String filename, CmdTable commands) {
        try {
            String readcode = PogoUtil.readFile(filename);
            int start = readcode.indexOf("virtual void read_attr_hardware(vector<long> &attr_list)");
            if (start > 0) {
                int end = readcode.indexOf("\n", start);
                if (readcode.substring(start, end).indexOf("NULL") > 0) {
                    return true;
                }
                return readcode.substring(start, end).indexOf("0") > 0;
            }
            if (commands.size() > 2) {
                int end;
                Cmd cmd = commands.cmdAt(2);
                String proto = cmd.buildCppCmdProtypesLine();
                start = readcode.indexOf(proto = proto.substring(0, proto.length() - 2));
                if (readcode.substring(start, end = readcode.indexOf("\n", start)).indexOf("NULL") > 0) {
                    return true;
                }
                return readcode.substring(start, end).indexOf("0") > 0;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int deviceImplRevisionNumber(String filename) {
        try {
            String ext = filename.substring(filename.lastIndexOf("."));
            if (ext.equals(".c")) {
                return cpp_target.length;
            }
            if (ext.equals(".cpp")) {
                filename = filename.substring(0, filename.lastIndexOf(".")) + ".h";
            }
            String readcode = PogoUtil.readFile(filename);
            for (int i = 0; i < cpp_target.length; ++i) {
                if (readcode.indexOf(cpp_target[i]) <= 0) continue;
                if (i == 0) {
                    return cpp_target.length - 1;
                }
                return cpp_target.length - i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }

    public static String getInheritance(String classname, String filename) throws PogoException, FileNotFoundException, SecurityException, IOException {
        String path;
        String readcode = PogoUtil.readFile(filename);
        if (readcode.indexOf(cpp_target[1]) > 0) {
            return "Device_3Impl";
        }
        String target = "class " + classname + ": public ";
        int start = readcode.indexOf(target);
        int end = readcode.indexOf("//", start += target.length());
        if (end < 0) {
            throw new PogoException("Inheritance syntax error");
        }
        String abstractclass = readcode.substring(start, end).trim();
        if ((start = abstractclass.indexOf("::")) < 0) {
            throw new PogoException("Inheritance syntax error");
        }
        abstractclass = abstractclass.substring(start + 2);
        String[] cl_list = PogoUtil.abstractClassList();
        boolean found = false;
        System.out.println(cl_list.length + " Super Classes available:");
        for (int i = 0; !found && i < cl_list.length; ++i) {
            String _class;
            System.out.println(cl_list[i]);
            start = cl_list[i].lastIndexOf("/");
            if (start <= 0 || !(found = (_class = cl_list[i].substring(start + 1, cl_list[i].lastIndexOf("."))).equals(abstractclass))) continue;
            abstractclass = cl_list[i].substring(0, cl_list[i].lastIndexOf("."));
        }
        if (!found && (path = System.getProperty("SUPER_HOME")) != null) {
            abstractclass = path + "/" + abstractclass;
        }
        return abstractclass;
    }

    public static String[] getTangoFilesList(String dirname) {
        int i;
        String[] ext = new String[]{".java", ".h"};
        String[] list = PogoUtil.getFilesList(dirname, ext);
        Vector<String> v = new Vector<String>();
        for (i = 0; i < list.length; ++i) {
            if (!PogoUtil.isDeviceImplClass(list[i])) continue;
            v.add(list[i]);
        }
        list = new String[v.size()];
        for (i = 0; i < v.size(); ++i) {
            list[i] = (String)v.elementAt(i);
        }
        return list;
    }

    public static String[] getCvsTangoFilesList(String dirname) {
        int i;
        String[] ext = new String[]{".java,v", ".h,v"};
        String[] list = PogoUtil.getFilesList(dirname, ext);
        Vector<String> v = new Vector<String>();
        for (i = 0; i < list.length; ++i) {
            if (!PogoUtil.isDeviceImplClass(list[i])) continue;
            v.add(list[i]);
        }
        list = new String[v.size()];
        for (i = 0; i < v.size(); ++i) {
            list[i] = (String)v.elementAt(i);
        }
        return list;
    }

    public static String[] getFilesList(String dirname, String[] ext) {
        File d = new File(dirname);
        String[] filenames = d.list();
        Vector<String> v = new Vector<String>();
        if (filenames == null) {
            return new String[0];
        }
        for (int i = 0; i < filenames.length; ++i) {
            String filename = dirname + "/" + filenames[i];
            File f = new File(filename);
            if (!f.isFile()) continue;
            for (int n = 0; n < ext.length; ++n) {
                int start_ext = filename.length() - ext[n].length();
                if (start_ext <= 0 || !filename.substring(start_ext).equals(ext[n])) continue;
                v.add(filename);
            }
        }
        String[] list = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            list[i] = (String)v.elementAt(i);
        }
        return list;
    }

    public static String readFile(String filename) throws FileNotFoundException, SecurityException, IOException {
        FileInputStream fid = new FileInputStream(filename);
        int nb = fid.available();
        byte[] inStr = new byte[nb];
        PogoString pgs = (nb = fid.read(inStr)) > 0 ? new PogoString(inStr) : new PogoString("");
        fid.close();
        return pgs.str;
    }

    public static String readFile(String filename, String src, String target) throws FileNotFoundException, SecurityException, IOException {
        PogoString pgs = new PogoString(PogoUtil.readFile(filename));
        while (pgs.indexOf(src) >= 0) {
            pgs.replace(src, target);
        }
        return pgs.str;
    }

    private static String checkOsFormat(String code) {
        String new_code = code;
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            int end;
            new_code = "";
            String lsp = System.getProperty("line.separator");
            int start = 0;
            while ((end = code.indexOf(10, start)) > 0) {
                new_code = new_code + code.substring(start, end);
                new_code = new_code + lsp;
                start = end + 1;
            }
        }
        return new_code;
    }

    public static void writeFile(String filename, String str) throws FileNotFoundException, SecurityException, IOException {
        str = PogoUtil.checkOsFormat(str);
        FileOutputStream fidout = new FileOutputStream(filename);
        fidout.write(str.getBytes());
        fidout.close();
    }

    public static String replaceAll(String str, String src, String target) {
        PogoString pgs = new PogoString(str);
        while (pgs.str.indexOf(src) >= 0) {
            pgs.replace(src, target);
        }
        return pgs.str;
    }

    public static String enteringTrace(String methodname) {
        int i = methodname.indexOf("::");
        if (i > 0) {
            while (i > 0 && methodname.charAt(i) != ' ') {
                --i;
            }
            if (methodname.charAt(i) == ' ') {
                ++i;
            }
            methodname = methodname.substring(i);
        }
        return "\tDEBUG_STREAM << \"" + methodname + " entering... \"<< endl;\n";
    }

    public static String checkCmdAttrName(String name, Vector existingCmd, Vector existingAttr, int editingIdx, int family) throws PogoException {
        int i;
        if (name.length() <= 0) {
            throw new PogoException("Name field must be filled in !");
        }
        if (attrSoleil == null) {
            attrSoleil = System.getProperty("ATTR_SOLEIL");
            attrSoleil = attrSoleil == null ? "false" : attrSoleil.toLowerCase();
        }
        StringTokenizer stk = new StringTokenizer(name);
        StringBuffer sb = new StringBuffer();
        while (stk.hasMoreTokens()) {
            String word = stk.nextToken();
            word = family == 3 && attrSoleil.equals("true") ? word.substring(0, 1) + word.substring(1) : word.substring(0, 1).toUpperCase() + word.substring(1);
            sb.append(word);
        }
        name = sb.toString();
        for (i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!(c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a') && c <= 'z' || c == '_') continue;
            throw new PogoException("Syntax error in name !\nDo not use '" + c + "' char.");
        }
        for (i = 0; i < existingCmd.size(); ++i) {
            if (i == editingIdx) continue;
            Cmd cmd = (Cmd)existingCmd.elementAt(i);
            if (!name.toLowerCase().equals(cmd.name.toLowerCase())) continue;
            throw new PogoException(name + " already exists as command !");
        }
        for (i = 0; i < existingAttr.size(); ++i) {
            if (i == editingIdx) continue;
            Attrib attr = (Attrib)existingAttr.elementAt(i);
            if (!name.toLowerCase().equals(attr.name.toLowerCase())) continue;
            throw new PogoException(name + " already exists as attribute !");
        }
        return name;
    }

    public static String getHelpMessage(String itemStr) {
        String templates_dir = System.getProperty("TEMPL_HOME");
        if (templates_dir == null) {
            return "No Template Property (TEMPL_HOME) Fixed !";
        }
        try {
            String filename = templates_dir + "/txt/";
            filename = itemStr.equals("What's New ?") ? filename + "WhatIsNew" : filename + itemStr;
            filename = filename + ".txt";
            return PogoUtil.readFile(filename);
        }
        catch (FileNotFoundException e) {
            return e.toString();
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    public static String executeShellCmd(String cmd) throws Exception {
        String str;
        Process proc = Runtime.getRuntime().exec(cmd);
        InputStream istr = proc.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(istr));
        String sb = "";
        while ((str = br.readLine()) != null) {
            sb = sb + str + "\n";
        }
        proc.waitFor();
        int retVal = proc.exitValue();
        if (retVal != 0) {
            InputStream errstr = proc.getErrorStream();
            br = new BufferedReader(new InputStreamReader(errstr));
            while ((str = br.readLine()) != null) {
                System.out.println(str);
                sb = sb + str + "\n";
            }
            throw new PogoException("the shell command\n" + cmd + "\nreturns : " + retVal + " !\n\n" + sb);
        }
        return sb;
    }

    public static String osName() {
        return System.getProperty("os.name");
    }

    public static boolean osIsUnix() {
        String os = PogoUtil.osName();
        return os.equals("Linux") || os.equals("SunOS") || os.equals("HP-UX");
    }

    static PogoString removeLogMessages(String code) {
        return PogoUtil.removeLogMessages(new PogoString(code));
    }

    private static void removeLogInfo(PogoString pgs) {
        int start = 0;
        Vector<String> v = new Vector<String>();
        while ((start = pgs.str.indexOf("$", start)) > 0) {
            int endline = pgs.nextCr(start);
            String line = pgs.substring(start, endline);
            start = line.indexOf(":");
            int end = line.indexOf("$", ++start);
            String info = line.substring(start, end).trim();
            start = endline + 1;
            v.add(info);
        }
        for (int i = 0; i < v.size(); ++i) {
            pgs.remove((String)v.elementAt(i));
        }
    }

    static PogoString removeLogMessages(PogoString code) {
        String line;
        int start = 0;
        int end = -1;
        while ((start = code.str.indexOf("namespace ", start + 1)) > 0 && ((line = code.substring(start = code.previousCr(start), end = code.nextCr(start + 1))).indexOf("//") >= 0 || line.indexOf("using ") >= 0)) {
            start = end;
        }
        if (start < 0) {
            end = -1;
        }
        if (end < 0 && (end = code.str.indexOf("public class")) < 0 && (end = code.str.indexOf("This file is generated by POGO")) < 0) {
            return code;
        }
        String header = code.substring(0, end);
        PogoString new_header = new PogoString(header);
        end = code.str.indexOf("copyleft");
        end = code.previousCr(end);
        end -= 2;
        end = code.previousCr(end);
        start = code.str.indexOf("// $Log: ");
        if (start < 0 && (start = code.str.indexOf("# $Log: ")) < 0) {
            return code;
        }
        start = code.nextCr(start + 1);
        String log_part = new_header.substring(++start, end);
        new_header.remove(log_part);
        PogoUtil.removeLogInfo(new_header);
        code.replace(header, new_header.str);
        return code;
    }

    public static boolean is_test_mode() {
        if (!test_mode_read) {
            String test = System.getProperty("POGO_TEST");
            if (test != null && test.toLowerCase().equals("true")) {
                test_mode = true;
            }
            test_mode_read = true;
        }
        return test_mode;
    }

    private static Vector searchAbstractClassList(String dirname) {
        String[] ext = new String[]{".java", ".h"};
        Vector v = new Vector();
        if (dirname == null) {
            return v;
        }
        File d = new File(dirname);
        String[] filenames = d.list();
        if (filenames == null) {
            return v;
        }
        for (int i = 0; i < filenames.length; ++i) {
            String filename = dirname + "/" + filenames[i];
            File f = new File(filename);
            if (f.isDirectory()) {
                Vector vd = PogoUtil.searchAbstractClassList(f.toString());
                for (int n = 0; n < vd.size(); ++n) {
                    v.add(vd.elementAt(n));
                }
                continue;
            }
            for (int n = 0; n < ext.length; ++n) {
                int start_ext = filename.length() - ext[n].length();
                if (start_ext <= 0 || !filename.substring(start_ext).equals(ext[n]) || !PogoUtil.isDeviceImplClass(filename)) continue;
                v.add(filename);
            }
        }
        return v;
    }

    public static String[] abstractClassList() {
        String super_home = System.getProperty("SUPER_HOME");
        System.out.println("Searching in " + super_home);
        Vector v = PogoUtil.searchAbstractClassList(super_home);
        String[] cl_list = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            cl_list[i] = (String)v.elementAt(i);
        }
        return cl_list;
    }

    public static String getCvsRepository(String path) {
        try {
            String filename = path + "/CVS/Root";
            String code = PogoUtil.readFile(filename).trim();
            String repository = "ESRF";
            if (code.lastIndexOf("tango-cs") > 0) {
                repository = "tango-cs";
            } else if (code.lastIndexOf("tango-ds") > 0) {
                repository = "tango-ds";
            }
            if (code.indexOf("sourceforge") > 0) {
                repository = "sourceforge(" + repository + ")";
            }
            return repository;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getTagRevision(String filename, String class_name) {
        try {
            int end;
            String line;
            String code = PogoUtil.readFile(filename);
            int start = code.indexOf("$Name:");
            if (start < 0) {
                return null;
            }
            if ((line = code.substring(start += "$Name:".length(), end = code.indexOf("$", start)).trim()).startsWith(class_name = class_name + "-")) {
                line = line.substring(class_name.length());
            }
            return line;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String checkFileName(String filename) {
        System.out.println(filename);
        byte[] chars = new byte[filename.length()];
        for (int i = 0; i < filename.length(); ++i) {
            int c = filename.charAt(i);
            chars[i] = c >= 65 && c <= 90 || c >= 97 && c <= 122 || c >= 48 && c <= 57 || c == 46 ? c : 95;
        }
        return new String(chars);
    }

    public static void logString(String str) {
        String log = System.getProperty("LOG");
        if (log == null) {
            return;
        }
        if (!log.equals("true")) {
            return;
        }
        try {
            String logstr = "";
            try {
                logstr = PogoUtil.readFile(logfile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            logstr = logstr + str + "\n";
            PogoUtil.writeFile(logfile, logstr);
        }
        catch (Exception e) {
            System.out.println(e + " in writing " + str);
        }
    }

    public static void main(String[] args) {
        String[] fl = PogoUtil.abstractClassList();
        for (int i = 0; i < fl.length; ++i) {
            System.out.println(fl[i]);
        }
    }
}

