/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.TangoDs.TangoConst;
import java.io.FileNotFoundException;
import java.io.IOException;
import pogo.gene.Cmd;
import pogo.gene.JavaServer;
import pogo.gene.JavaServerClass;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGene;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;

public class PogoGeneJava
extends PogoGene
implements PogoDefs,
TangoConst {
    public PogoGeneJava(PogoClass pogo) {
        super(pogo);
    }

    protected String AddExecuteMethod(Cmd cmd, PogoString pgs) throws PogoException {
        int start = pgs.str.indexOf("Class Description:");
        if (start < 0) {
            throw new PogoException("Template Syntax error !\nClass Description\n Not found !");
        }
        int end = pgs.str.indexOf("*/", start);
        String oldMethod = pgs.str.substring(start, end);
        StringBuffer sb = new StringBuffer("Class Description:\n *\t");
        if (cmd.description != null) {
            sb.append(new PogoString(cmd.description).setComments());
        }
        sb.append("\n");
        pgs.replace(oldMethod, sb.toString());
        String target = "public Any execute(DeviceImpl device,Any in_any)";
        start = pgs.str.indexOf(target);
        if (start < 0) {
            throw new PogoException("Template Syntax error !\n" + target + "\n Not Found !");
        }
        int tmp = start = pgs.inMethod(start);
        if ((start = pgs.str.indexOf("println", start)) < 0) {
            start = tmp;
        }
        start = pgs.nextCr(start) + 1;
        end = pgs.outMethod(start);
        oldMethod = pgs.str.substring(start, end);
        String newMethod = cmd.buildJavaExecuteMethodBlock(this.pogo.class_name);
        pgs.replace(start, oldMethod, newMethod);
        target = "public boolean is_allowed(DeviceImpl device, Any data_in)";
        start = pgs.str.indexOf(target);
        if (start < 0) {
            throw new PogoException("Template Syntax error !\n" + target + "\n Not Found !");
        }
        start = pgs.inMethod(start);
        end = pgs.outMethod(start);
        oldMethod = pgs.str.substring(start, end);
        newMethod = cmd.buildIsAllowedMethod(new PogoString(oldMethod), 0);
        pgs.replace(oldMethod, newMethod);
        return pgs.str;
    }

    protected void generateCommandClasses() throws IOException, PogoException {
        String template = this.pogo.templates_dir + "/java/" + "DevServ" + "Cmd.java";
        for (int i = 0; i < this.pogo.commands.size(); ++i) {
            PogoString pgs;
            Cmd cmd = this.pogo.commands.cmdAt(i);
            if (cmd.virtual_method) continue;
            String servercmd = this.pogo.projectFiles.getPath() + "/" + cmd.cmd_class + ".java";
            if (this.mustGenerate(servercmd)) {
                System.out.println("Generating " + servercmd + "....");
                pgs = new PogoString(PogoUtil.readFile(template));
                pgs = PogoUtil.removeLogMessages(pgs);
                while (pgs.str.indexOf("TemplateDevServ") >= 0) {
                    pgs.replace("TemplateDevServ", this.pogo.class_name);
                }
                while (pgs.str.indexOf("TemplateClassCmd") >= 0) {
                    pgs.replace("TemplateClassCmd", cmd.cmd_class);
                }
                this.strTrace = this.strTrace + servercmd + "        Created\n";
            } else {
                pgs = new PogoString(PogoUtil.readFile(servercmd));
                this.strTrace = this.strTrace + servercmd + "        Modified\n";
            }
            String newcode = this.AddExecuteMethod(cmd, pgs);
            PogoUtil.writeFile(servercmd, newcode);
        }
    }

    protected String addClassToMakefile(PogoString pgs) throws PogoException {
        String tag = "CL_LIST =\t$(CLASS).class";
        if (pgs.str.indexOf(tag) < 0) {
            throw new PogoException("Makefile Syntax error !");
        }
        String f_list = tag + "\\\n\t\t$(CLASS)Class.class";
        for (int i = 0; i < this.pogo.commands.size(); ++i) {
            Cmd cmd = this.pogo.commands.cmdAt(i);
            if (cmd.virtual_method) continue;
            f_list = f_list + "\t\\\n\t\t" + cmd.cmd_class + ".class";
        }
        f_list = f_list + "\n";
        pgs.replace(tag, f_list);
        return pgs.str;
    }

    protected void generateMakefile(String filename) throws IOException, PogoException {
        System.out.println("Generating " + filename + "....");
        String template = this.pogo.templates_dir + "/java/Makefile";
        PogoString pgs = new PogoString(PogoUtil.readFile(template));
        pgs = PogoUtil.removeLogMessages(pgs);
        while (pgs.str.indexOf("TemplateDevServ") >= 0) {
            pgs.replace("TemplateDevServ", this.pogo.class_name);
        }
        String newcode = this.addClassToMakefile(pgs);
        PogoUtil.writeFile(filename, newcode);
    }

    public void generate() throws FileNotFoundException, SecurityException, IOException, PogoException {
        String makefile = this.pogo.projectFiles.getPath() + "/Makefile";
        String server = this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + ".java";
        String serverclass = this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + "Class.java";
        this.strTrace = "Java source code generation:\n\n";
        if (this.mustGenerate(makefile)) {
            this.generateMakefile(makefile);
            this.strTrace = this.strTrace + makefile + "        Created\n";
        }
        this.generateCommandClasses();
        JavaServer serv = new JavaServer(this.pogo);
        serv.generateSource(server);
        this.strTrace = this.strTrace + server + "        Writen\n";
        JavaServerClass sc = new JavaServerClass(this.pogo);
        sc.generateSource(serverclass);
        this.strTrace = this.strTrace + serverclass + "        Writen\n";
    }
}

