/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import pogo.gene.Attrib;
import pogo.gene.AttribTable;
import pogo.gene.Cmd;
import pogo.gene.CmdTable;
import pogo.gene.DevState;
import pogo.gene.DevStateTable;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;
import pogo.gene.ProjectFiles;
import pogo.gene.Property;
import pogo.gene.PropertyTable;
import pogo.gene.ServerDefinitions;

public class PogoClass
implements PogoDefs {
    public String title;
    public String class_name;
    public String inherited_from = null;
    public String class_desc;
    public String templates_dir;
    public PropertyTable class_properties;
    public PropertyTable dev_properties;
    public CmdTable commands;
    public AttribTable attributes;
    public DevStateTable states;
    public int language;
    public String author;
    public String revision;
    public String cvs_repository = null;
    public int deviceImpl;
    public ProjectFiles projectFiles;
    public boolean is_abstractclass = false;
    public Exception except = null;
    private String template_class = "<b><Font size=-1 COLOR=\"#0000FF\"> CLASS </b></Font>";
    private String template_lang = "<Center><Font size=-1 COLOR=\"#0000FF\"><b> LANG </b></Font></Center>";
    private String template_desc = "<b><Font size=-1><a href=CLASS/doc_html/index.html> DESCRIPTION </a></Font></b>";
    private static final int max_desc = 300;

    public String namespace() {
        return this.class_name + "_ns";
    }

    public String inheritedNamespace() {
        return this.inheritedClassName() + "_ns";
    }

    public String inheritedClassName() {
        if (this.inherited_from == null) {
            return "Device_3Impl";
        }
        if (this.inherited_from.equals("Device_3Impl")) {
            return "Device_3Impl";
        }
        int start = this.inherited_from.lastIndexOf("/");
        int end = this.inherited_from.lastIndexOf(".");
        String classname = end > ++start ? this.inherited_from.substring(start, end) : this.inherited_from.substring(start);
        return classname;
    }

    public String inheritedClassPath() {
        String classname = "";
        if (this.inherited_from == null) {
            return classname;
        }
        if (this.inherited_from.equals("Device_3Impl")) {
            return classname;
        }
        int end = this.inherited_from.lastIndexOf("/");
        classname = end > 0 ? this.inherited_from.substring(0, end) : this.inherited_from;
        return classname;
    }

    public PogoClass(String className, String inherited_from, String classDesc, Vector classPropVect, Vector devPropVect, Vector cmdVect, Vector attrVect, Vector statesVector, int language, String path) throws PogoException {
        this.class_name = className;
        this.inherited_from = inherited_from;
        if (classDesc != null) {
            this.class_desc = classDesc;
        }
        this.author = "";
        this.revision = "";
        this.class_properties = new PropertyTable(classPropVect);
        this.dev_properties = new PropertyTable(devPropVect);
        this.commands = new CmdTable(cmdVect);
        this.attributes = new AttribTable(attrVect);
        this.states = new DevStateTable(statesVector);
        this.language = language;
        this.projectFiles = new ProjectFiles(path, this.class_name, language);
        this.deviceImpl = language == 1 ? 3 : 1;
        this.templates_dir = System.getProperty("TEMPL_HOME");
        if (this.templates_dir == null) {
            throw new PogoException("No Template Property (TEMPL_HOME) Fixed !");
        }
    }

    public PogoClass(ServerDefinitions sd, int language, String path) throws PogoException {
        this.class_name = sd.name;
        this.inherited_from = sd.inherited_from;
        this.class_desc = sd.description;
        this.title = sd.project_title;
        this.author = "";
        this.revision = "";
        this.class_properties = new PropertyTable();
        this.dev_properties = new PropertyTable();
        this.commands = new CmdTable();
        this.attributes = new AttribTable();
        this.states = new DevStateTable();
        this.language = language;
        this.projectFiles = new ProjectFiles(path, this.class_name, language);
        this.deviceImpl = language == 1 ? 3 : 1;
        this.templates_dir = System.getProperty("TEMPL_HOME");
        if (this.templates_dir == null) {
            throw new PogoException("No Template Property (TEMPL_HOME) Fixed !");
        }
    }

    public PogoClass(String filename) throws FileNotFoundException, SecurityException, IOException, PogoException {
        this.projectFiles = new ProjectFiles(filename);
        this.author = "";
        this.revision = "";
        this.templates_dir = System.getProperty("TEMPL_HOME");
        if (this.templates_dir == null) {
            throw new PogoException("No Template Property (TEMPL_HOME) Fixed !");
        }
        this.initializePogoFromSrcFiles();
    }

    private void initializePogoFromSrcFiles() throws FileNotFoundException, SecurityException, IOException, PogoException {
        this.class_name = this.projectFiles.getClassName();
        this.language = this.projectFiles.getLanguage();
        String serverDescriptionFile = this.language == 1 ? this.projectFiles.getServer_h() : this.projectFiles.getServer();
        String classDescriptionFile = this.language == 1 ? this.projectFiles.getServerClass_h() : this.projectFiles.getServerClass();
        this.deviceImpl = 1;
        if (this.language == 1) {
            this.deviceImpl = PogoUtil.deviceImplRevisionNumber(serverDescriptionFile);
            System.out.println("Server inherits from Device_" + this.deviceImpl + "Impl class");
            if (this.deviceImpl < 3) {
                PogoUtil.logString(this.class_name + "\tinherits from Device " + this.deviceImpl + "Impl class");
            }
        }
        this.commands = new CmdTable(this.projectFiles.getServerClass(), this.deviceImpl);
        this.commands.getDescriptions(serverDescriptionFile, this.projectFiles.getServerClass(), this.language);
        if (this.language == 1) {
            if (this.deviceImpl >= 3) {
                this.inherited_from = PogoUtil.getInheritance(this.class_name, serverDescriptionFile);
                this.is_abstractclass = PogoUtil.checkIfSuperclass(serverDescriptionFile, this.commands);
                System.out.println("This class is " + (this.is_abstractclass ? "" : "NOT") + " a super class");
                System.out.println("Server inherits " + this.inherited_from + " class");
            }
            System.out.println("Server is a Device_" + this.deviceImpl + "Impl object");
        } else {
            this.inherited_from = "Device_3Impl";
        }
        if (this.language == 1 && this.deviceImpl >= 3) {
            this.commands.setAllowedState(this.class_name, this.projectFiles.getAllowed(), this.is_abstractclass);
        }
        this.states = new DevStateTable(serverDescriptionFile, this.language);
        this.attributes = new AttribTable(this.projectFiles, this.language);
        if (this.language == 1 && this.deviceImpl >= 3) {
            this.attributes.setAllowedState(this.class_name, this.projectFiles.getAllowed(), this.is_abstractclass);
        }
        this.getTheProjectTitle(serverDescriptionFile);
        this.getTheClassDescription(serverDescriptionFile);
        this.getIfOverrided(serverDescriptionFile);
        this.class_properties = new PropertyTable(classDescriptionFile, 0, this.language);
        this.class_properties.readDefaultValues(this.projectFiles.getServerClass(), 0, this.language);
        this.dev_properties = new PropertyTable(serverDescriptionFile, 1, this.language);
        this.dev_properties.readDefaultValues(this.projectFiles.getServerClass(), 1, this.language);
        if (this.commands.except != null) {
            this.except = this.commands.except;
            this.commands.except = null;
        }
        if (this.attributes.except != null) {
            this.except = this.attributes.except;
            this.attributes.except = null;
        }
    }

    private void getIfOverrided(String filename) throws FileNotFoundException, SecurityException, IOException {
        PogoString pgs = new PogoString(PogoUtil.readFile(filename));
        for (int i = 0; i < this.commands.size(); ++i) {
            Cmd cmd = this.commands.cmdAt(i);
            if (!cmd.virtual_method) continue;
            String cppLine = cmd.buildCppCmdProtypesLine();
            if (pgs.str.indexOf(cppLine) > 0) {
                cmd.override_method = 2;
                continue;
            }
            cppLine = cmd.buildCppCmdProtypesLineNoTab();
            if (pgs.str.indexOf(cppLine) > 0) {
                cmd.override_method = 2;
                continue;
            }
            String javaLine = cmd.buildJavaExecCmdMethodSignature(0);
            if (pgs.str.indexOf(javaLine) <= 0) continue;
            cmd.override_method = 2;
        }
    }

    private void getTheProjectTitle(String filename) throws FileNotFoundException, SecurityException, IOException {
        String str = PogoUtil.readFile(filename);
        int start = str.indexOf("project :");
        if (start < 0) {
            System.out.println("WARNING: 'project :' Not Found in " + filename);
            return;
        }
        int end = str.indexOf("\n", start += "project :".length());
        this.title = str.substring(start, end).trim();
        start = str.indexOf("Author:");
        if (start < 0) {
            return;
        }
        end = str.indexOf("$", start += "Author:".length());
        this.author = str.substring(start, end).trim();
        start = str.indexOf("Revision:");
        if (start < 0) {
            return;
        }
        end = str.indexOf("$", start += "Revision:".length());
        this.revision = str.substring(start, end).trim();
        if (this.language == 1) {
            String classfile = this.projectFiles.getPath() + "/" + this.class_name + "Class.cpp";
            String tmp = PogoUtil.getTagRevision(classfile, this.class_name);
            if (tmp != null) {
                this.revision = tmp;
            }
            this.cvs_repository = PogoUtil.getCvsRepository(this.projectFiles.getPath());
        }
    }

    private void getTheClassDescription(String filename) throws FileNotFoundException, SecurityException, IOException {
        String str = PogoUtil.readFile(filename);
        int start = str.indexOf("Class Description:");
        if (start < 0) {
            this.class_desc = "";
            return;
        }
        int end = str.indexOf("*/", start += "Class Description:".length());
        if (end < 0) {
            this.class_desc = "";
            return;
        }
        PogoString comments = new PogoString(str.substring(start, end));
        this.class_desc = comments.getDescription().trim();
    }

    public void setRevision(String vers) {
        this.revision = vers;
    }

    public void setAuthor(String name) {
        this.author = name;
    }

    public void setTitle(String projTitle) {
        this.title = projTitle;
    }

    public void addClassProperty(Property prop) {
        this.class_properties.addElement(prop);
    }

    public void addDevProperty(Property prop) {
        this.dev_properties.addElement(prop);
    }

    public void addCommand(Cmd cmd) {
        this.commands.addElement(cmd);
    }

    public void addAttribute(Attrib attr) {
        this.attributes.addElement(attr);
    }

    public void addState(DevState st) {
        this.states.addElement(st);
    }

    public String[] buildServersListHtmlLine() {
        PogoString html_class = new PogoString(this.template_class);
        while (html_class.indexOf("CLASS") >= 0) {
            html_class.replace("CLASS", this.class_name);
        }
        PogoString html_lang = new PogoString(this.template_lang);
        while (html_lang.indexOf("LANG") >= 0) {
            html_lang.replace("LANG", this.language == 1 ? "C++" : "Java");
        }
        PogoString html_desc = new PogoString(this.template_desc);
        while (html_desc.indexOf("CLASS") >= 0) {
            html_desc.replace("CLASS", this.class_name);
        }
        String desc = this.class_desc.length() > 300 ? this.class_desc.substring(0, 300) + "....." : (this.class_desc.length() == 0 ? "Tango device server" : this.class_desc);
        desc = new PogoString(desc).removeHtmlTags();
        html_desc.replace("DESCRIPTION", desc);
        String[] retstr = new String[]{html_class.str, html_lang.str, html_desc.str};
        return retstr;
    }

    public void setProjectPath(String path) {
        this.projectFiles = new ProjectFiles(path, this.class_name, this.language);
    }

    public String toString() {
        String s = this.class_name + "\n";
        s = s + this.class_desc + "\n";
        s = s + "COMMANDS\n";
        s = s + this.commands;
        s = s + "ATTRIBUTES\n";
        s = s + this.attributes;
        s = s + "STATES\n";
        s = s + this.states;
        s = s + "CLASS PROPERTIES\n";
        s = s + this.class_properties;
        s = s + "Device PROPERTIES\n";
        s = s + this.dev_properties;
        return s;
    }
}

