/*
 * Decompiled with CFR 0.152.
 */
package explorer.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

class DTPrinter {
    DTPrinter() {
    }

    public static void printFrame(JFrame comp, String title, boolean fitToPage, int printerResolution) {
        PageAttributes pa = new PageAttributes();
        JobAttributes ja = new JobAttributes();
        pa.setPrintQuality(PageAttributes.PrintQualityType.HIGH);
        pa.setColor(PageAttributes.ColorType.COLOR);
        pa.setMedia(PageAttributes.MediaType.A4);
        if (fitToPage) {
            pa.setPrinterResolution(72);
        } else {
            pa.setPrinterResolution(printerResolution);
        }
        ja.setMaxPage(1);
        ja.setMinPage(1);
        ja.setDialog(JobAttributes.DialogType.COMMON);
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(comp, title, ja, pa);
        if (printJob != null) {
            int w = comp.getSize().width;
            int h = comp.getSize().height;
            BufferedImage img = new BufferedImage(w, h, 1);
            Color oldBackground = comp.getBackground();
            comp.setBackground(Color.WHITE);
            comp.printAll(img.getGraphics());
            comp.setBackground(oldBackground);
            try {
                int ty;
                int tx;
                if (fitToPage) {
                    double nResolution;
                    int wp = printJob.getPageDimension().width - 72;
                    double ratioW = (double)w / (double)wp;
                    int hp = printJob.getPageDimension().height - 72;
                    double ratioH = (double)h / (double)hp;
                    if (ratioW > ratioH) {
                        nResolution = 72.0 * ratioW;
                        tx = (int)(nResolution * 0.5);
                        double cH = nResolution / 72.0 * (double)hp - (double)h;
                        ty = (int)(0.5 * (nResolution + cH));
                    } else {
                        nResolution = 72.0 * ratioH;
                        double cW = nResolution / 72.0 * (double)wp - (double)w;
                        tx = (int)(0.5 * (nResolution + cW));
                        ty = (int)(nResolution * 0.5);
                    }
                    pa.setPrinterResolution((int)(nResolution + 0.5));
                } else {
                    tx = printerResolution / 2;
                    ty = printerResolution / 2;
                }
                Graphics g = printJob.getGraphics();
                g.translate(tx, ty);
                g.setClip(0, 0, w, h);
                g.drawImage(img, 0, 0, null);
                g.dispose();
                printJob.end();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(comp, "Exception occured while printing\n" + e.getMessage(), title, 0);
            }
        }
    }
}

