/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.jdraw.JLXPath;
import fr.esrf.tangoatk.widget.util.jdraw.JLXStyle;
import fr.esrf.tangoatk.widget.util.jdraw.LXFileLoader;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.io.IOException;

class LXObject {
    int type;
    String name = "";
    Font font = ATKConstant.labelFont;
    boolean visible = true;
    int userClass = 0;
    Color foreground = Color.BLACK;
    Color background = Color.WHITE;
    int lineWidth = 1;
    int lineStyle = 0;
    int lineArrow = 0;
    int fillStyle = 0;
    int shadowWidth = 0;
    boolean invertShadow = false;
    int arcMode = 0;
    double px = 0.0;
    double py = 0.0;
    Rectangle2D boundRect;
    static Color lastForeground;
    static Color lastBackground;
    static int lastLineWidth;
    static int lastLineStyle;
    static int lastLineArrow;
    static int lastFillStyle;
    static int lastArcMode;
    static Font lastFont;

    LXObject() {
    }

    void setBounds(double d, double d2, double d3, double d4) {
        this.boundRect = new Rectangle2D.Double(d + this.px, d2 + this.py, d3, d4);
    }

    boolean toDo(int n, int n2) {
        return (n & n2) == n2;
    }

    void parse(LXFileLoader lXFileLoader, boolean bl) throws IOException {
        int n;
        if (!bl) {
            lXFileLoader.read_safe_word();
            lXFileLoader.read_int();
            lXFileLoader.read_safe_word();
            this.px = lXFileLoader.read_double();
            this.py = lXFileLoader.read_double();
            lXFileLoader.read_safe_word();
            n = lXFileLoader.read_int();
            if (n != -1) {
                lXFileLoader.read_int();
                lXFileLoader.read_int();
                lXFileLoader.read_int();
                lXFileLoader.read_int();
                lXFileLoader.read_int();
                lXFileLoader.read_int();
            }
            lXFileLoader.read_safe_word();
            lXFileLoader.read_int();
            lXFileLoader.read_int();
            lXFileLoader.read_int();
        }
        lXFileLoader.read_int();
        this.type = lXFileLoader.read_int();
        lXFileLoader.read_int();
        this.userClass = lXFileLoader.read_int();
        lXFileLoader.jump_space();
        if (lXFileLoader.CurrentChar == 'N') {
            lXFileLoader.read_safe_word();
            lXFileLoader.jump_space();
            this.name = lXFileLoader.read_line();
        }
        lXFileLoader.read_int();
        this.visible = lXFileLoader.read_int() == 1;
        lXFileLoader.read_int();
        lXFileLoader.read_safe_word();
        lXFileLoader.jump_space();
        if (lXFileLoader.CurrentChar != '=') {
            n = lXFileLoader.read_int_16();
            if (this.toDo(n, 1)) {
                lXFileLoader.read_safe_word();
            }
            if (this.toDo(n, 2)) {
                lastForeground = this.foreground = lXFileLoader.read_color();
            }
            if (this.toDo(n, 4)) {
                lastBackground = this.background = lXFileLoader.read_color();
            }
            if (this.toDo(n, 8)) {
                this.lineWidth = lXFileLoader.read_int() + 1;
                if (this.lineWidth > 6) {
                    this.lineWidth = 0;
                }
                lastLineWidth = this.lineWidth;
            }
            if (this.toDo(n, 16)) {
                lastLineStyle = this.lineStyle = JLXStyle.ToJDLineStyle[lXFileLoader.read_int()];
            }
            if (this.toDo(n, 32)) {
                lastLineArrow = this.lineArrow = JLXPath.ToJDLineArrow[lXFileLoader.read_int()];
            }
            if (this.toDo(n, 64)) {
                this.fillStyle = JLXStyle.ToJDFillStyle[lXFileLoader.read_int()];
                lXFileLoader.read_int();
                lastFillStyle = this.fillStyle;
            }
            if (this.toDo(n, 128)) {
                lastArcMode = this.arcMode = lXFileLoader.read_int();
            }
            if (this.toDo(n, 256)) {
                lastFont = this.font = lXFileLoader.read_font();
            }
        } else {
            lXFileLoader.read_safe_word();
            this.font = lastFont;
            this.arcMode = lastArcMode;
            this.fillStyle = lastFillStyle;
            this.lineArrow = lastLineArrow;
            this.lineStyle = lastLineStyle;
            this.lineWidth = lastLineWidth;
            this.foreground = lastForeground;
            this.background = lastBackground;
        }
        if (this.fillStyle > 1) {
            this.background = this.foreground;
        }
    }
}

