/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JLXFileLoader;
import java.awt.Color;
import java.io.IOException;

class JLXStyle {
    static int[] ToJDLineStyle = new int[]{0, 1, 2, 3, 4, 3, 4};
    static int[] ToJDFillStyle = new int[]{0, 1, 1, 8, 10, 9, 6, 3, 5, 2, 4, 7, 4, 7};
    Color lineColor = Color.BLACK;
    int lineStyle = 0;
    int lineWidth = 1;
    Color fillColor = Color.WHITE;
    int fillStyle = 0;
    float gradientX1 = 0.0f;
    float gradientX2 = 10.0f;
    float gradientY1 = 0.0f;
    float gradientY2 = 10.0f;
    Color gradientC1 = Color.white;
    Color gradientC2 = Color.black;
    boolean gradientCyclic = false;

    JLXStyle() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(JLXFileLoader jLXFileLoader) throws IOException {
        Color color;
        String string = jLXFileLoader.read_safe_word();
        if (string.equals("!")) {
            return;
        }
        if (!string.equals("A")) throw new IOException("Unsupported style type at line " + jLXFileLoader.getCurrentLine());
        this.lineStyle = ToJDLineStyle[jLXFileLoader.read_int()];
        this.lineWidth = (int)jLXFileLoader.read_double();
        if (jLXFileLoader.version.compareTo("2.0.0") >= 0) {
            jLXFileLoader.read_int();
            jLXFileLoader.read_int();
        }
        if ((color = jLXFileLoader.read_color()) != null) {
            this.lineColor = color;
        }
        jLXFileLoader.read_double();
        String string2 = jLXFileLoader.read_safe_word();
        if (!string2.equals("!")) {
            if (string2.equals("F")) {
                this.fillColor = jLXFileLoader.read_color();
                this.fillStyle = 1;
                if (this.fillColor == null) {
                    this.fillColor = Color.black;
                }
                jLXFileLoader.read_color();
            } else if (string2.equals("B")) {
                jLXFileLoader.read_color();
                this.fillColor = jLXFileLoader.read_color();
                if (this.fillColor == null) {
                    this.fillColor = Color.black;
                }
                this.fillStyle = 1;
            } else if (string2.equals("C")) {
                this.fillColor = jLXFileLoader.read_color();
                if (this.fillColor == null) {
                    this.fillColor = Color.white;
                }
                this.fillStyle = 1;
            } else if (string2.equals("G")) {
                this.gradientX1 = (float)jLXFileLoader.read_double();
                jLXFileLoader.jump_colon();
                this.gradientY1 = (float)jLXFileLoader.read_double();
                jLXFileLoader.jump_colon();
                this.gradientX2 = (float)jLXFileLoader.read_double();
                jLXFileLoader.jump_colon();
                this.gradientY2 = (float)jLXFileLoader.read_double();
                String string3 = jLXFileLoader.read_safe_word();
                this.gradientCyclic = string3.charAt(0) == '1';
                boolean bl = string3.charAt(1) == '1';
                Color color2 = jLXFileLoader.read_color();
                if (color2 != null) {
                    this.gradientC1 = color2;
                }
                if ((color2 = jLXFileLoader.read_color()) != null) {
                    this.gradientC2 = color2;
                }
                if (bl) {
                    this.gradientC1 = new Color(this.gradientC1.getRed(), this.gradientC1.getGreen(), this.gradientC1.getBlue(), 0);
                }
                int n = 0;
                if (jLXFileLoader.version.compareTo("2.0.2") >= 0) {
                    n = jLXFileLoader.read_int();
                }
                if (n == 0) {
                    this.fillStyle = 11;
                } else if (n == 1) {
                    // empty if block
                }
            } else if (string2.equals("T")) {
                jLXFileLoader.read_string();
                jLXFileLoader.read_color();
                jLXFileLoader.read_color();
            } else {
                if (!string2.equals("S")) throw new IOException("Bad style format at line " + jLXFileLoader.getCurrentLine());
                int n = jLXFileLoader.read_int();
                Color color3 = jLXFileLoader.read_color();
                Color color4 = jLXFileLoader.read_color();
                this.fillColor = n == 1 ? color3 : (n == 2 ? color4 : Color.BLACK);
                if (this.fillColor == null) {
                    this.fillColor = Color.BLACK;
                }
                this.fillStyle = ToJDFillStyle[n];
            }
        }
        jLXFileLoader.read_safe_full_word();
    }
}

