/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.Tango.DevError;
import fr.esrf.tangoatk.core.ATKException;
import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class ErrorTree
extends JPanel {
    DefaultMutableTreeNode top = new DefaultMutableTreeNode("Stack");
    private JTree errorTree;

    private void initComponents() {
        this.errorTree = new JTree(this.top);
        this.setLayout(new BorderLayout());
        this.add(this.errorTree);
    }

    void populateErrorNode(DefaultMutableTreeNode defaultMutableTreeNode, ErrorNode errorNode) {
        DevError devError = errorNode.getError();
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("Severity - " + ATKException.severity[devError.severity.value()]));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("Origin - " + devError.origin));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("Description - " + devError.desc));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("Reason - " + devError.reason));
    }

    public void addError(DevError devError) {
        ErrorNode errorNode = new ErrorNode(devError);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(errorNode);
        this.top.add(defaultMutableTreeNode);
        this.populateErrorNode(defaultMutableTreeNode, errorNode);
    }

    public void addErrors(DevError[] devErrorArray) {
        int n;
        this.remove(this.errorTree);
        this.top = new DefaultMutableTreeNode("Stack");
        this.initComponents();
        this.errorTree.setRootVisible(true);
        for (n = 0; n < devErrorArray.length; ++n) {
            this.addError(devErrorArray[n]);
        }
        for (n = 0; n < this.errorTree.getRowCount(); ++n) {
            this.errorTree.expandRow(n);
        }
    }

    public ErrorTree() {
        this.initComponents();
        this.errorTree.setRootVisible(false);
    }

    class ErrorNode {
        DevError error;

        public DevError getError() {
            return this.error;
        }

        public String toString() {
            return this.error.reason.trim();
        }

        ErrorNode(DevError devError) {
            this.error = devError;
        }
    }
}

