/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.HelpWindow;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class ATKMenuBar
extends JMenuBar {
    JMenu file;
    JMenu view;
    JMenu edit;
    JMenu help;
    JMenuItem exitItem;
    JMenuItem aboutItem;
    JMenuItem errorItem;
    JMenuItem helpItem;
    GridBagConstraints constraints = new GridBagConstraints();
    ErrorHistory errorHistory;

    public ATKMenuBar(ErrorHistory errorHistory) {
        this();
        this.setErrorHistory(errorHistory);
    }

    public void setErrorHistory(ErrorHistory errorHistory) {
        this.errorHistory = errorHistory;
    }

    public ErrorHistory getErrorHistory() {
        return this.errorHistory;
    }

    protected void showErrorHistory() {
        if (this.errorHistory == null) {
            return;
        }
        this.errorHistory.show();
    }

    protected void showHelpWindow() {
        HelpWindow.getInstance().show();
    }

    public ATKMenuBar() {
        this.constraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.file = new JMenu("File");
        this.add((Component)this.file, this.constraints);
        ++this.constraints.gridx;
        this.edit = new JMenu("Edit");
        this.add((Component)this.edit, this.constraints);
        ++this.constraints.gridx;
        this.view = new JMenu("View");
        this.add((Component)this.view, this.constraints);
        this.constraints.fill = 2;
        this.constraints.weightx = 0.1;
        this.constraints.gridx = 200;
        this.add((Component)new JLabel(""), this.constraints);
        this.constraints.fill = 0;
        this.constraints.gridx = 201;
        this.constraints.weightx = 0.0;
        this.help = new JMenu("Help");
        this.add((Component)this.help, this.constraints);
        this.constraints.gridx = 3;
        this.exitItem = new JMenuItem("Quit");
        this.aboutItem = new JMenuItem("About...");
        this.helpItem = new JMenuItem("Help");
        this.file.setMnemonic('F');
        this.view.setMnemonic('V');
        this.edit.setMnemonic('E');
        this.help.setMnemonic('H');
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.helpItem.setAccelerator(KeyStroke.getKeyStroke("F1"));
        this.helpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ATKMenuBar.this.showHelpWindow();
            }
        });
        this.errorItem = new JMenuItem("Error history...");
        this.errorItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ATKMenuBar.this.showErrorHistory();
            }
        });
        this.errorItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.add2ViewMenu(this.errorItem, 0);
        this.file.add(new JSeparator());
        this.file.add(this.exitItem);
        this.help.add(this.aboutItem);
        this.help.add(this.helpItem);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.file == null) {
            return;
        }
        this.file.setFont(font);
        this.view.setFont(font);
        this.edit.setFont(font);
        this.help.setFont(font);
        this.exitItem.setFont(font);
        this.errorItem.setFont(font);
        this.aboutItem.setFont(font);
        this.helpItem.setFont(font);
    }

    public void setQuitHandler(ActionListener actionListener) {
        this.exitItem.addActionListener(actionListener);
    }

    public void setAboutHandler(ActionListener actionListener) {
        this.aboutItem.addActionListener(actionListener);
    }

    public void add2ViewMenu(JComponent jComponent, int n) {
        jComponent.setFont(this.getFont());
        this.view.add((Component)jComponent, n);
    }

    public void add2ViewMenu(JComponent jComponent) {
        jComponent.setFont(this.getFont());
        this.view.add(jComponent);
    }

    public void add2EditMenu(JComponent jComponent, int n) {
        jComponent.setFont(this.getFont());
        this.edit.add((Component)jComponent, n);
    }

    public void add2EditMenu(JComponent jComponent) {
        jComponent.setFont(this.getFont());
        this.edit.add(jComponent);
    }

    public void add2HelpMenu(JComponent jComponent, int n) {
        jComponent.setFont(this.getFont());
        this.help.add((Component)jComponent, n);
    }

    public void add2HelpMenu(JComponent jComponent) {
        jComponent.setFont(this.getFont());
        this.help.add(jComponent);
    }

    public void add2FileMenu(JComponent jComponent, int n) {
        jComponent.setFont(this.getFont());
        this.file.add((Component)jComponent, n);
    }

    public void add2FileMenu(JComponent jComponent) {
        jComponent.setFont(this.getFont());
        this.file.add(jComponent);
    }

    public void addMenu(JMenu jMenu) {
        ++this.constraints.gridx;
        jMenu.setFont(this.getFont());
        this.add((Component)jMenu, this.constraints);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        ATKMenuBar aTKMenuBar = new ATKMenuBar();
        aTKMenuBar.setFont(new Font("Dialog", 0, 12));
        aTKMenuBar.add2FileMenu(new JMenuItem("foo"), 0);
        JMenu jMenu = new JMenu("bar");
        jMenu.setMnemonic('b');
        jMenu.add(new JMenuItem("baz"));
        aTKMenuBar.addMenu(jMenu);
        aTKMenuBar.setQuitHandler(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(1);
            }
        });
        jFrame.setJMenuBar(aTKMenuBar);
        jFrame.pack();
        jFrame.show();
    }
}

