/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class ATKGraphicsUtils {
    private static FontRenderContext frc = null;
    static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

    public static Dimension measureString(String string, Font font) {
        ATKGraphicsUtils.init();
        Rectangle2D rectangle2D = font.getStringBounds(string, frc);
        int n = (int)(rectangle2D.getWidth() + 0.5);
        int n2 = (int)(rectangle2D.getHeight() + 0.5);
        return new Dimension(n, n2);
    }

    public static FontRenderContext getDefaultRenderContext() {
        ATKGraphicsUtils.init();
        return frc;
    }

    public static LineMetrics getLineMetrics(String string, Font font) {
        ATKGraphicsUtils.init();
        return font.getLineMetrics(string, frc);
    }

    public static void centerDialog(Dialog dialog, int n, int n2) {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        if (dialog.getParent() != null && dialog.getParent().isVisible()) {
            rectangle = dialog.getParent().getBounds();
        }
        if (rectangle.width == 0 || rectangle.height == 0) {
            rectangle.x = 0;
            rectangle.y = 0;
            rectangle.width = ATKGraphicsUtils.screenSize.width;
            rectangle.height = ATKGraphicsUtils.screenSize.height;
        }
        dialog.pack();
        Insets insets = dialog.getInsets();
        int n3 = n + (insets.right + insets.left);
        int n4 = n2 + (insets.bottom + insets.top);
        int n5 = rectangle.x + (rectangle.width - n3) / 2;
        int n6 = rectangle.y + (rectangle.height - n4) / 2;
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n5 + n3 > ATKGraphicsUtils.screenSize.width) {
            n5 = ATKGraphicsUtils.screenSize.width - n3;
        }
        if (n6 + n4 > ATKGraphicsUtils.screenSize.height) {
            n6 = ATKGraphicsUtils.screenSize.height - n4;
        }
        dialog.setBounds(n5, n6, n3, n4);
    }

    public static void centerDialog(Dialog dialog) {
        dialog.pack();
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        if (dialog.getParent() != null && dialog.getParent().isVisible()) {
            rectangle = dialog.getParent().getBounds();
        }
        if (rectangle.width == 0 || rectangle.height == 0) {
            rectangle.x = 0;
            rectangle.y = 0;
            rectangle.width = ATKGraphicsUtils.screenSize.width;
            rectangle.height = ATKGraphicsUtils.screenSize.height;
        }
        int n = dialog.getPreferredSize().width;
        int n2 = dialog.getPreferredSize().height;
        int n3 = rectangle.x + (rectangle.width - n) / 2;
        int n4 = rectangle.y + (rectangle.height - n2) / 2;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n3 + n > ATKGraphicsUtils.screenSize.width) {
            n3 = ATKGraphicsUtils.screenSize.width - n;
        }
        if (n4 + n2 > ATKGraphicsUtils.screenSize.height) {
            n4 = ATKGraphicsUtils.screenSize.height - n2;
        }
        dialog.setBounds(n3, n4, n, n2);
    }

    public static void centerFrameOnScreen(Frame frame) {
        int n;
        Rectangle rectangle = new Rectangle(0, 0, ATKGraphicsUtils.screenSize.width, ATKGraphicsUtils.screenSize.height);
        frame.pack();
        int n2 = frame.getPreferredSize().width;
        if (n2 > ATKGraphicsUtils.screenSize.width) {
            n2 = ATKGraphicsUtils.screenSize.width;
        }
        if ((n = frame.getPreferredSize().height) > ATKGraphicsUtils.screenSize.height) {
            n = ATKGraphicsUtils.screenSize.height;
        }
        int n3 = rectangle.x + (rectangle.width - n2) / 2;
        int n4 = rectangle.y + (rectangle.height - n) / 2;
        frame.setBounds(n3, n4, n2, n);
    }

    public static void centerFrame(JComponent jComponent, Frame frame) {
        frame.pack();
        Window window = ATKGraphicsUtils.getWindowForComponent(jComponent);
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        if (window != null && window.isVisible()) {
            rectangle = window.getBounds();
        }
        if (rectangle.width == 0 || rectangle.height == 0) {
            rectangle.x = 0;
            rectangle.y = 0;
            rectangle.width = ATKGraphicsUtils.screenSize.width;
            rectangle.height = ATKGraphicsUtils.screenSize.height;
        }
        int n = frame.getPreferredSize().width;
        int n2 = frame.getPreferredSize().height;
        int n3 = rectangle.x + (rectangle.width - n) / 2;
        int n4 = rectangle.y + (rectangle.height - n2) / 2;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n3 + n > ATKGraphicsUtils.screenSize.width) {
            n3 = ATKGraphicsUtils.screenSize.width - n;
        }
        if (n4 + n2 > ATKGraphicsUtils.screenSize.height) {
            n4 = ATKGraphicsUtils.screenSize.height - n2;
        }
        frame.setBounds(n3, n4, n, n2);
    }

    public static Window getWindowForComponent(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Frame || component instanceof Dialog) {
            return (Window)component;
        }
        return ATKGraphicsUtils.getWindowForComponent(component.getParent());
    }

    public static void printComponent(JComponent jComponent, String string, boolean bl, int n) {
        PrintJob printJob;
        PageAttributes pageAttributes = new PageAttributes();
        JobAttributes jobAttributes = new JobAttributes();
        pageAttributes.setPrintQuality(PageAttributes.PrintQualityType.HIGH);
        pageAttributes.setColor(PageAttributes.ColorType.COLOR);
        pageAttributes.setMedia(PageAttributes.MediaType.A4);
        if (bl) {
            pageAttributes.setPrinterResolution(72);
        } else {
            pageAttributes.setPrinterResolution(n);
        }
        jobAttributes.setMaxPage(1);
        jobAttributes.setMinPage(1);
        jobAttributes.setDialog(JobAttributes.DialogType.NATIVE);
        Window window = ATKGraphicsUtils.getWindowForComponent(jComponent);
        if (window instanceof Frame) {
            printJob = Toolkit.getDefaultToolkit().getPrintJob((Frame)window, string, jobAttributes, pageAttributes);
        } else {
            Frame frame = new Frame();
            printJob = Toolkit.getDefaultToolkit().getPrintJob(frame, string, jobAttributes, pageAttributes);
        }
        if (printJob != null) {
            int n2 = jComponent.getSize().width;
            int n3 = jComponent.getSize().height;
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
            Color color = jComponent.getBackground();
            jComponent.setBackground(Color.WHITE);
            jComponent.paint(bufferedImage.getGraphics());
            jComponent.setBackground(color);
            try {
                int n4;
                int n5;
                if (bl) {
                    double d;
                    int n6 = printJob.getPageDimension().width - 72;
                    double d2 = (double)n2 / (double)n6;
                    int n7 = printJob.getPageDimension().height - 72;
                    double d3 = (double)n3 / (double)n7;
                    if (d2 > d3) {
                        d = 72.0 * d2;
                        n5 = (int)(d * 0.5);
                        double d4 = d / 72.0 * (double)n7 - (double)n3;
                        n4 = (int)(0.5 * (d + d4));
                    } else {
                        d = 72.0 * d3;
                        double d5 = d / 72.0 * (double)n6 - (double)n2;
                        n5 = (int)(0.5 * (d + d5));
                        n4 = (int)(d * 0.5);
                    }
                    pageAttributes.setPrinterResolution((int)(d + 0.5));
                } else {
                    n5 = n / 2;
                    n4 = n / 2;
                }
                Graphics graphics = printJob.getGraphics();
                graphics.translate(n5, n4);
                graphics.setClip(0, 0, n2, n3);
                graphics.drawImage(bufferedImage, 0, 0, null);
                graphics.dispose();
                printJob.end();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(window, "Exception occured while printing\n" + exception.getMessage(), string, 0);
            }
        }
    }

    private static void init() {
        if (frc == null) {
            BufferedImage bufferedImage = new BufferedImage(10, 10, 1);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            frc = graphics2D.getFontRenderContext();
            graphics2D.dispose();
        }
    }
}

