/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;

public class ATKFontChooser
extends JDialog
implements ActionListener,
ListSelectionListener,
ChangeListener {
    private JPanel innerPanel;
    private Font currentFont;
    private int fontSize;
    Font result;
    private String[] allFamily;
    private DefaultListModel listModel;
    private JScrollPane familyView;
    private JList familyList;
    private JPanel infoPanel;
    private JCheckBox plainCheck;
    private JCheckBox boldCheck;
    private JCheckBox italicCheck;
    private JCheckBox italicboldCheck;
    private JTextField sizeText;
    private JLabel sizeLabel;
    private JSlider sizeSlider;
    private JSmoothLabel sampleLabel;
    private JButton okBtn;
    private JButton cancelBtn;
    private static Font labelFontBold = new Font("Dialog", 1, 12);
    private static Color labelColor = new Color(85, 87, 140);

    ATKFontChooser(Frame frame, String string, Font font) {
        super(frame, true);
        this.initComponents(string, font);
    }

    ATKFontChooser(Dialog dialog, String string, Font font) {
        super(dialog, true);
        this.initComponents(string, font);
    }

    private void initComponents(String string, Font font) {
        int n;
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(null);
        this.currentFont = font == null ? ATKConstant.labelFont : font;
        this.fontSize = this.currentFont.getSize();
        this.result = this.currentFont;
        this.allFamily = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.listModel = new DefaultListModel();
        this.familyList = new JList(this.listModel);
        this.familyList.setSelectionMode(0);
        this.familyList.setFont(ATKConstant.labelFont);
        for (n = 0; n < this.allFamily.length; ++n) {
            this.listModel.addElement(this.allFamily[n]);
        }
        this.familyView = new JScrollPane(this.familyList);
        this.familyView.setBorder(BorderFactory.createLoweredBevelBorder());
        this.infoPanel = new JPanel();
        this.infoPanel.setLayout(null);
        this.infoPanel.setBorder(this.createTitleBorder("Size and Style"));
        this.plainCheck = new JCheckBox("Plain");
        this.plainCheck.setForeground(labelColor);
        this.plainCheck.setFont(ATKConstant.labelFont);
        this.plainCheck.addActionListener(this);
        this.boldCheck = new JCheckBox("Bold");
        this.boldCheck.setForeground(labelColor);
        this.boldCheck.setFont(ATKConstant.labelFont);
        this.boldCheck.addActionListener(this);
        this.italicCheck = new JCheckBox("Italic");
        this.italicCheck.setForeground(labelColor);
        this.italicCheck.setFont(ATKConstant.labelFont);
        this.italicCheck.addActionListener(this);
        this.italicboldCheck = new JCheckBox("Bold italic");
        this.italicboldCheck.setForeground(labelColor);
        this.italicboldCheck.setFont(ATKConstant.labelFont);
        this.italicboldCheck.addActionListener(this);
        this.sizeText = new JTextField();
        this.sizeText.addActionListener(this);
        this.sizeText.setEditable(true);
        this.sizeLabel = new JLabel("Size");
        this.sizeLabel.setFont(ATKConstant.labelFont);
        this.sizeLabel.setForeground(labelColor);
        this.sizeSlider = new JSlider(5, 72, this.fontSize);
        this.sizeSlider.setMinorTickSpacing(1);
        this.sizeSlider.setMajorTickSpacing(5);
        this.sizeSlider.setPaintTicks(true);
        this.sizeSlider.setPaintLabels(true);
        this.sizeSlider.addChangeListener(this);
        this.infoPanel.add(this.plainCheck);
        this.infoPanel.add(this.italicCheck);
        this.infoPanel.add(this.italicboldCheck);
        this.infoPanel.add(this.boldCheck);
        this.infoPanel.add(this.sizeLabel);
        this.infoPanel.add(this.sizeText);
        this.infoPanel.add(this.sizeSlider);
        this.plainCheck.setBounds(5, 20, 100, 25);
        this.italicCheck.setBounds(5, 45, 100, 25);
        this.boldCheck.setBounds(5, 70, 100, 25);
        this.italicboldCheck.setBounds(5, 95, 100, 25);
        this.sizeLabel.setBounds(130, 35, 80, 25);
        this.sizeText.setBounds(130, 60, 80, 25);
        this.sizeSlider.setBounds(5, 125, 240, 45);
        this.okBtn = new JButton("Apply");
        this.okBtn.setFont(ATKConstant.labelFont);
        this.okBtn.addActionListener(this);
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.setFont(ATKConstant.labelFont);
        this.cancelBtn.addActionListener(this);
        this.sampleLabel = new JSmoothLabel();
        this.sampleLabel.setText("Sample 12.34");
        this.sampleLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.sampleLabel.setBackground(new Color(220, 220, 220));
        this.innerPanel.add(this.familyView);
        this.innerPanel.add(this.infoPanel);
        this.innerPanel.add(this.okBtn);
        this.innerPanel.add(this.cancelBtn);
        this.innerPanel.add(this.sampleLabel);
        this.infoPanel.setBounds(178, 5, 254, 175);
        this.familyView.setBounds(5, 5, 170, 300);
        this.okBtn.setBounds(180, 280, 80, 25);
        this.cancelBtn.setBounds(350, 280, 80, 25);
        this.sampleLabel.setBounds(180, 185, 250, 90);
        this.setTitle(string);
        this.updateControl();
        n = this.familyList.getNextMatch(this.currentFont.getFamily(), 0, Position.Bias.Forward);
        if (n != -1) {
            this.familyList.setSelectedIndex(n);
            this.familyList.ensureIndexIsVisible(n);
        }
        this.familyList.addListSelectionListener(this);
        this.innerPanel.setPreferredSize(new Dimension(435, 312));
        this.setContentPane(this.innerPanel);
        this.setResizable(false);
    }

    private void updateControl() {
        this.plainCheck.setSelected(this.currentFont.isPlain());
        this.boldCheck.setSelected(this.currentFont.isBold() && !this.currentFont.isItalic());
        this.italicCheck.setSelected(this.currentFont.isItalic() && !this.currentFont.isBold());
        this.italicboldCheck.setSelected(this.currentFont.isBold() && this.currentFont.isItalic());
        this.sampleLabel.setFont(this.currentFont);
        this.sizeText.setText(Integer.toString(this.fontSize));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancelBtn) {
            this.result = null;
            this.setVisible(false);
            this.dispose();
        } else if (actionEvent.getSource() == this.okBtn) {
            this.result = this.currentFont;
            this.setVisible(false);
            this.dispose();
        } else if (actionEvent.getSource() == this.plainCheck) {
            Font font = new Font(this.currentFont.getFamily(), 0, this.fontSize);
            if (font != null) {
                this.currentFont = font;
                this.updateControl();
            }
        } else if (actionEvent.getSource() == this.boldCheck) {
            Font font = new Font(this.currentFont.getFamily(), 1, this.fontSize);
            if (font != null) {
                this.currentFont = font;
                this.updateControl();
            }
        } else if (actionEvent.getSource() == this.italicCheck) {
            Font font = new Font(this.currentFont.getFamily(), 2, this.fontSize);
            if (font != null) {
                this.currentFont = font;
                this.updateControl();
            }
        } else if (actionEvent.getSource() == this.italicboldCheck) {
            Font font = new Font(this.currentFont.getFamily(), 3, this.fontSize);
            if (font != null) {
                this.currentFont = font;
                this.updateControl();
            }
        } else if (actionEvent.getSource() == this.sizeText) {
            try {
                int n = Integer.parseInt(this.sizeText.getText());
                this.sizeSlider.setValue(n);
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showConfirmDialog(this, "Wrong integer format\n" + numberFormatException.getMessage());
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        String string;
        Font font;
        if (listSelectionEvent.getSource() == this.familyList && (font = new Font(string = (String)this.listModel.get(this.familyList.getSelectedIndex()), 0, this.fontSize)) != null) {
            this.currentFont = font;
            this.updateControl();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.sizeSlider) {
            this.fontSize = this.sizeSlider.getValue();
            Font font = this.currentFont.deriveFont((float)this.fontSize);
            if (font != null) {
                this.currentFont = font;
                this.updateControl();
            }
        }
    }

    public static Font getNewFont(Component component, String string, Font font) {
        Window window = ATKGraphicsUtils.getWindowForComponent(component);
        ATKFontChooser aTKFontChooser = window instanceof Dialog ? new ATKFontChooser((Dialog)window, string, font) : (window instanceof Frame ? new ATKFontChooser((Frame)window, string, font) : new ATKFontChooser((Frame)null, string, font));
        ATKGraphicsUtils.centerDialog(aTKFontChooser);
        aTKFontChooser.setVisible(true);
        return aTKFontChooser.result;
    }

    private Border createTitleBorder(String string) {
        return BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string, 1, 0, labelFontBold, labelColor);
    }

    public static void main(String[] stringArray) {
        ATKFontChooser.getNewFont(null, "Choose font", null);
        System.exit(0);
    }
}

