/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.device;

import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IStateListener;
import fr.esrf.tangoatk.core.StateEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import javax.swing.JButton;

public class DeviceStateButtonViewer
extends JButton
implements IStateListener {
    private Device deviceModel = null;
    private boolean alarmEnabled = true;
    private boolean viewLabel = true;
    private boolean defaultLabel = true;

    public DeviceStateButtonViewer() {
        this.setHorizontalAlignment(0);
    }

    public void stateChange(StateEvent stateEvent) {
        if (this.viewLabel && this.defaultLabel) {
            this.setText(stateEvent.getState());
        }
        if (this.alarmEnabled) {
            this.setBackground(ATKConstant.getColor4State(stateEvent.getState()));
        }
    }

    public boolean isDefaultLabel() {
        return this.defaultLabel;
    }

    public void setDefaultLabel(boolean bl) {
        this.defaultLabel = bl;
    }

    public boolean isViewLabel() {
        return this.viewLabel;
    }

    public void setViewLabel(boolean bl) {
        this.viewLabel = bl;
        if (!bl) {
            this.setText("");
        } else {
            this.setText("UNKNOWN");
        }
    }

    public boolean isAlarmEnabled() {
        return this.alarmEnabled;
    }

    public void setAlarmEnabled(boolean bl) {
        this.alarmEnabled = bl;
    }

    public Device getDeviceModel() {
        return this.deviceModel;
    }

    public void setDeviceModel(Device device) {
        this.deviceModel = device;
        device.addStateListener((IStateListener)this);
    }

    public void clearModel() {
        if (this.deviceModel != null) {
            this.deviceModel.removeStateListener((IStateListener)this);
            this.deviceModel = null;
        }
    }

    public void errorChange(ErrorEvent errorEvent) {
        if (this.viewLabel && this.defaultLabel) {
            this.setText("UNKNOWN");
        }
        if (this.alarmEnabled) {
            this.setBackground(ATKConstant.getColor4State("UNKNOWN"));
        }
    }
}

