/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.command;

import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.command.InvalidCommand;
import fr.esrf.tangoatk.core.command.VoidVoidCommand;
import fr.esrf.tangoatk.widget.command.AnyCommandViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class CommandButtonViewer
extends JPanel {
    JFrame argFrame = new JFrame();
    AnyCommandViewer acv = new AnyCommandViewer();
    private JButton executeButton;
    ICommand model;
    boolean borderVisble;
    boolean descriptionVisible;
    boolean infoButtonVisible;
    boolean deviceButtonVisible;
    boolean cancelButtonVisible;

    public CommandButtonViewer() {
        this.initComponents();
        this.argFrame.getContentPane().add(this.acv);
    }

    private void initComponents() {
        this.executeButton = new JButton();
        this.setLayout(new BorderLayout());
        this.executeButton.setText("command-name");
        this.executeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CommandButtonViewer.this.executeButtonActionPerformed(actionEvent);
            }
        });
        this.add((Component)this.executeButton, "Center");
    }

    private void executeButtonActionPerformed(ActionEvent actionEvent) {
        if (this.model instanceof InvalidCommand) {
            JOptionPane.showMessageDialog(this, this.model.getName() + " is not supported. It probably takes an array as input.", "Error", 1);
            return;
        }
        if (this.model instanceof VoidVoidCommand) {
            this.model.execute();
            return;
        }
        this.acv.initialize(this.model);
        this.acv.setDeviceButtonVisible(this.deviceButtonVisible);
        this.acv.setDescriptionVisible(this.descriptionVisible);
        this.acv.setInfoButtonVisible(this.infoButtonVisible);
        this.acv.setBorder(null);
        this.acv.setInputVisible(true);
        if (!this.model.takesInput()) {
            this.model.execute();
        }
        this.argFrame.setTitle(this.model.getName());
        this.argFrame.pack();
        this.argFrame.show();
    }

    public void setEnabled(boolean bl) {
        this.executeButton.setEnabled(bl);
    }

    public boolean isEnabled() {
        return this.executeButton.isEnabled();
    }

    public void setModel(ICommand iCommand) {
        this.model = iCommand;
        this.executeButton.setText(this.model.getNameSansDevice());
        this.executeButton.setToolTipText(this.model.getDevice().toString());
    }

    public ICommand getModel() {
        return this.model;
    }

    public void setFont(Font font) {
        if (this.executeButton == null) {
            return;
        }
        this.executeButton.setFont(font);
    }

    public Font getFont() {
        if (this.executeButton == null) {
            return super.getFont();
        }
        return this.executeButton.getFont();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.executeButton == null) {
            return;
        }
        this.executeButton.setBackground(color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.executeButton == null) {
            return;
        }
        this.executeButton.setForeground(color);
    }

    public boolean isBorderVisible() {
        return this.borderVisble;
    }

    public void setBorderVisible(boolean bl) {
        this.borderVisble = bl;
    }

    public boolean isDescriptionVisible() {
        return this.descriptionVisible;
    }

    public void setDescriptionVisible(boolean bl) {
        this.descriptionVisible = bl;
    }

    public boolean isInfoButtonVisible() {
        return this.infoButtonVisible;
    }

    public void setInfoButtonVisible(boolean bl) {
        this.infoButtonVisible = bl;
    }

    public boolean isDeviceButtonVisible() {
        return this.deviceButtonVisible;
    }

    public void setDeviceButtonVisible(boolean bl) {
        this.deviceButtonVisible = bl;
    }

    public boolean isCancelButtonVisible() {
        return this.cancelButtonVisible;
    }

    public void setCancelButtonVisible(boolean bl) {
        this.cancelButtonVisible = bl;
    }

    public static void main(String[] stringArray) throws Exception {
        CommandList commandList = new CommandList();
        CommandButtonViewer commandButtonViewer = new CommandButtonViewer();
        commandList.add("eas/test-api/1/IOFloatArray");
        commandButtonViewer.setModel((ICommand)commandList.add("eas/test-api/1/IOFloatArray"));
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(commandButtonViewer);
        jFrame.pack();
        jFrame.show();
    }
}

