/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringScalarListener;
import fr.esrf.tangoatk.core.StringScalarEvent;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class StringScalarComboEditor
extends JComboBox
implements ActionListener,
IStringScalarListener,
JDrawable {
    static String[] exts = new String[]{"valueList"};
    private DefaultComboBoxModel comboModel = null;
    private String defActionCmd = "setAttActionCmd";
    private String jdrawExts = "";
    private Font theFont;
    private IStringScalar stringModel = null;
    private String[] defOptionList = new String[]{"None"};
    private String[] optionList = new String[]{"None"};

    public StringScalarComboEditor() {
        this.theFont = new Font("Dialog", 0, 14);
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.setActionCommand(this.defActionCmd);
        this.addActionListener(this);
    }

    public IStringScalar getStringModel() {
        return this.stringModel;
    }

    public void setStringModel(IStringScalar iStringScalar) {
        String[] stringArray = null;
        int n = 0;
        String[] stringArray2 = null;
        if (this.stringModel != null) {
            this.stringModel.removeStringScalarListener((IStringScalarListener)this);
            this.stringModel = null;
            this.optionList = this.defOptionList;
            this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
            this.setModel(this.comboModel);
        }
        if (iStringScalar == null) {
            return;
        }
        if (!iStringScalar.isWritable()) {
            throw new IllegalArgumentException("StringScalarComboEditor: Only accept writable attribute.");
        }
        this.stringModel = iStringScalar;
        String string = "???";
        stringArray = this.stringModel.getPossibleValues();
        stringArray2 = null;
        if (stringArray != null && (n = stringArray.length) > 0) {
            stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = new String(stringArray[i]);
            }
        }
        if (stringArray2 == null) {
            stringArray2 = new String[]{new String(string + " ")};
        }
        if (stringArray2 != null) {
            this.optionList = stringArray2;
            this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
            this.setModel(this.comboModel);
        }
        this.stringModel.addStringScalarListener((IStringScalarListener)this);
        this.stringModel.refresh();
    }

    public void stringScalarChange(StringScalarEvent stringScalarEvent) {
        String string = null;
        int n = this.getSelectedIndex();
        string = this.hasFocus() ? this.stringModel.getStringDeviceSetPoint() : this.stringModel.getStringSetPoint();
        if (string == null) {
            try {
                this.changeCurrentSelection(-1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("caught exception : " + illegalArgumentException.getMessage());
            }
            return;
        }
        if (this.optionList == null) {
            return;
        }
        for (int i = 0; i < this.optionList.length; ++i) {
            if (!string.equalsIgnoreCase(this.optionList[i])) continue;
            if (n != i) {
                this.changeCurrentSelection(i);
            }
            return;
        }
        try {
            this.changeCurrentSelection(-1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("caught exception : " + illegalArgumentException.getMessage());
        }
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
        if (this.stringModel == null) {
            return;
        }
        int n = this.getSelectedIndex();
        if (n != -1) {
            try {
                this.changeCurrentSelection(-1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("caught exception : " + illegalArgumentException.getMessage());
            }
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox = null;
        String string = null;
        if (!actionEvent.getActionCommand().equals(this.defActionCmd)) {
            return;
        }
        if (this.stringModel == null) {
            return;
        }
        jComboBox = (JComboBox)actionEvent.getSource();
        string = (String)jComboBox.getSelectedItem();
        if (string == null) {
            return;
        }
        this.stringModel.setString(string);
    }

    private void changeCurrentSelection(int n) {
        this.disableExecution();
        this.setSelectedIndex(n);
        this.repaint();
        this.enableExecution();
    }

    public void enableExecution() {
        this.setActionCommand(this.defActionCmd);
    }

    public void disableExecution() {
        this.setActionCommand("dummy");
    }

    public void initForEditing() {
    }

    public JComponent getComponent() {
        return this;
    }

    public String getDescription(String string) {
        if (string.equalsIgnoreCase("valueList")) {
            return "The list of values to be proposed in the ComboBox.";
        }
        return "";
    }

    public String[] getExtensionList() {
        return exts;
    }

    public boolean setExtendedParam(String string, String string2, boolean bl) {
        if (string.equalsIgnoreCase("valueList")) {
            this.jdrawExts = "";
            String[] stringArray = string2.split(",");
            if (stringArray.length <= 0) {
                this.showJdrawError(bl, "valueList", "String value list expected: str,str,str");
                return false;
            }
            this.jdrawExts = string2;
            return true;
        }
        return false;
    }

    public String getExtendedParam(String string) {
        if (string.equalsIgnoreCase("valueList")) {
            return this.jdrawExts;
        }
        return "";
    }

    private void showJdrawError(boolean bl, String string, String string2) {
        if (bl) {
            JOptionPane.showMessageDialog(null, "StringScalarComboEditor: " + string + " incorrect.\n" + string2, "Error", 0);
        }
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        StringScalarComboEditor stringScalarComboEditor = new StringScalarComboEditor();
        String[] stringArray2 = new String[]{"short", "long"};
        JFrame jFrame = null;
        try {
            IEntity iEntity = attributeList.add("elin/gun/run/PulseType");
            IStringScalar iStringScalar = iEntity instanceof IStringScalar ? (IStringScalar)iEntity : null;
            if (iStringScalar == null) {
                System.exit(-1);
            }
            iStringScalar.setPossibleValues(stringArray2);
            stringScalarComboEditor.setStringModel(iStringScalar);
        }
        catch (Exception exception) {
            System.out.println("caught exception : " + exception.getMessage());
            System.exit(-1);
        }
        attributeList.startRefresher();
        jFrame = new JFrame();
        jFrame.setContentPane(stringScalarComboEditor);
        jFrame.pack();
        jFrame.show();
    }
}

