/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class BooleanScalarCheckBoxViewer
extends JCheckBox
implements ActionListener,
IBooleanScalarListener,
ISetErrorListener,
JDrawable {
    private IBooleanScalar attModel = null;
    private String trueLabel = null;
    private String falseLabel = null;
    private String fixedLabel = null;
    static String[] exts = new String[]{"text"};

    public BooleanScalarCheckBoxViewer() {
        this.addActionListener(this);
    }

    public BooleanScalarCheckBoxViewer(String string) {
        super(string);
        this.addActionListener(this);
    }

    public IBooleanScalar getAttModel() {
        return this.attModel;
    }

    public void setAttModel(IBooleanScalar iBooleanScalar) {
        if (this.attModel != null) {
            this.attModel.removeBooleanScalarListener((IBooleanScalarListener)this);
            if (this.attModel.isWritable()) {
                this.attModel.removeSetErrorListener((ISetErrorListener)this);
            }
            this.attModel = null;
            this.setText("");
        }
        if (iBooleanScalar != null) {
            this.attModel = iBooleanScalar;
            this.attModel.addBooleanScalarListener((IBooleanScalarListener)this);
            if (this.attModel.isWritable()) {
                this.attModel.addSetErrorListener((ISetErrorListener)this);
            }
            if (this.trueLabel == null && this.falseLabel == null && this.fixedLabel == null) {
                this.setText(iBooleanScalar.getLabel());
            }
            this.setBoolValue(this.attModel.getDeviceValue());
        }
    }

    public String getTrueLabel() {
        return this.trueLabel;
    }

    public void setTrueLabel(String string) {
        this.trueLabel = string;
        if (this.trueLabel == null || this.falseLabel == null) {
            if (this.attModel != null) {
                this.setText(this.attModel.getLabel());
            } else {
                this.setText(null);
            }
        } else if (this.isSelected()) {
            this.setText(this.trueLabel);
        }
    }

    public String getFalseLabel() {
        return this.falseLabel;
    }

    public void setFalseLabel(String string) {
        this.falseLabel = string;
        if (this.trueLabel == null || this.falseLabel == null) {
            if (this.attModel != null) {
                this.setText(this.attModel.getLabel());
            } else {
                this.setText(null);
            }
        } else if (!this.isSelected()) {
            this.setText(this.falseLabel);
        }
    }

    public void clearModel() {
        this.setAttModel(null);
    }

    public void initForEditing() {
        this.setText("CheckBox");
    }

    public JComponent getComponent() {
        return this;
    }

    public String getDescription(String string) {
        if (string.equalsIgnoreCase("text")) {
            return "Overrides text given by the model.";
        }
        return "";
    }

    public String[] getExtensionList() {
        return exts;
    }

    public boolean setExtendedParam(String string, String string2, boolean bl) {
        if (string.equalsIgnoreCase("text")) {
            this.fixedLabel = string2;
            if (this.fixedLabel.length() == 0) {
                this.fixedLabel = null;
                this.setText("CheckBox");
            } else {
                this.setText(this.fixedLabel);
            }
            return true;
        }
        return false;
    }

    public String getExtendedParam(String string) {
        if (string.equalsIgnoreCase("text") && this.fixedLabel != null) {
            return this.fixedLabel;
        }
        return "";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.attModel == null) {
            return;
        }
        if (!this.attModel.isWritable()) {
            this.setSelected(!this.isSelected());
            return;
        }
        if (this.isSelected()) {
            this.attModel.setValue(true);
        } else {
            this.attModel.setValue(false);
        }
    }

    public void booleanScalarChange(BooleanScalarEvent booleanScalarEvent) {
        this.setBoolValue(booleanScalarEvent.getValue());
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.setEnabled(false);
    }

    private void setBoolValue(boolean bl) {
        if (!this.isEnabled()) {
            this.setEnabled(true);
        }
        this.setSelected(bl);
        if (this.trueLabel != null || this.falseLabel != null) {
            if (bl) {
                this.setText(this.trueLabel);
            } else {
                this.setText(this.falseLabel);
            }
        }
    }

    public void setErrorOccured(ErrorEvent errorEvent) {
        if (this.attModel == null) {
            return;
        }
        if (errorEvent.getSource() != this.attModel) {
            return;
        }
        this.setBoolValue(this.attModel.getDeviceValue());
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        JFrame jFrame = new JFrame();
        BooleanScalarCheckBoxViewer booleanScalarCheckBoxViewer = new BooleanScalarCheckBoxViewer();
        try {
            IEntity iEntity = attributeList.add("jlp/test/1/att_boolean");
            if (!(iEntity instanceof IBooleanScalar)) {
                System.out.println("jlp/test/1/att_boolean is not a booleanScalar");
                System.exit(0);
            }
            IBooleanScalar iBooleanScalar = (IBooleanScalar)iEntity;
            booleanScalarCheckBoxViewer.setAttModel(iBooleanScalar);
        }
        catch (Exception exception) {
            System.out.println("Cannot connect to elin/mod/aux-1/Economy");
        }
        jFrame.setContentPane(booleanScalarCheckBoxViewer);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

