/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.DevStateScalarHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class DevStateScalar
extends AAttribute
implements IDevStateScalar {
    DevStateScalarHelper devStateHelper = new DevStateScalarHelper(this);
    String devStateValue = null;

    public int getXDimension() {
        return 1;
    }

    public int getMaxXDimension() {
        return 1;
    }

    public String getValue() {
        return this.devStateValue;
    }

    public String getDeviceValue() {
        try {
            String string;
            this.devStateValue = string = Device.toString(this.readValueFromNetwork().extractState());
        }
        catch (DevFailed devFailed) {
            this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
        }
        catch (Exception exception) {
            System.out.println("DevStateScalar.getDeviceValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("DevStateScalar.getDeviceValue()------------------------------------------------");
        }
        return this.devStateValue;
    }

    public void refresh() {
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        this.trace(4, "DevStateScalar.refresh() method called for " + this.getName(), l);
        try {
            try {
                deviceAttribute = this.readValueFromNetwork();
                this.trace(4, "DevStateScalar.refresh(" + this.getName() + ") readValueFromNetwork success", l);
                if (deviceAttribute == null) {
                    return;
                }
                this.devStateValue = Device.toString(deviceAttribute.extractState());
                this.fireValueChanged(this.devStateValue);
                this.trace(4, "DevStateScalar.refresh(" + this.getName() + ") fireValueChanged(devStateValue) success", l);
            }
            catch (DevFailed devFailed) {
                this.trace(4, "DevStateScalar.refresh(" + this.getName() + ") failed, caught DevFailed; will call readAttError", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
        }
        catch (Exception exception) {
            this.trace(4, "DevStateScalar.refresh(" + this.getName() + ") Code failure, caught other Exception", l);
            System.out.println("DevStateScalar.refresh() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("DevStateScalar.refresh()------------------------------------------------");
        }
    }

    public void dispatch(DeviceAttribute deviceAttribute) {
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                this.setState(deviceAttribute);
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.devStateValue = Device.toString(deviceAttribute.extractState());
                this.fireValueChanged(this.devStateValue);
            }
            catch (DevFailed devFailed) {
                this.dispatchError(devFailed);
            }
        }
        catch (Exception exception) {
            System.out.println("DevStateScalar.dispatch() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("DevStateScalar.dispatch()------------------------------------------------");
        }
    }

    public void dispatchError(DevFailed devFailed) {
        this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
    }

    public boolean isWritable() {
        return super.isWritable();
    }

    protected void fireValueChanged(String string) {
        this.devStateHelper.fireValueChanged(string, this.timeStamp);
    }

    public void addDevStateScalarListener(IDevStateScalarListener iDevStateScalarListener) {
        this.devStateHelper.addDevStateScalarListener(iDevStateScalarListener);
        this.addStateListener(iDevStateScalarListener);
    }

    public void removeDevStateScalarListener(IDevStateScalarListener iDevStateScalarListener) {
        this.devStateHelper.removeDevStateScalarListener(iDevStateScalarListener);
        this.removeStateListener(iDevStateScalarListener);
    }

    public String getDevStateValue() {
        return this.devStateValue;
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
        ++this.periodicCount;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(128, "DevStateScalar.periodic method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoPeriodicEvent.getValue();
            this.trace(128, "DevStateScalar.periodicEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(128, "DevStateScalar.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "DevStateScalar.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(128, "DevStateScalar.periodicEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(128, "DevStateScalar.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            System.out.println("DevStateScalar.periodic.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("DevStateScalar.periodic.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.trace(128, "DevStateScalar.periodic(" + this.getName() + ") setState(da) called", l);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.devStateValue = Device.toString(deviceAttribute.extractState());
                this.fireValueChanged(this.devStateValue);
                this.trace(128, "DevStateScalar.periodic(" + this.getName() + ") fireValueChanged(devStateValue) called", l);
            }
            catch (DevFailed devFailed) {
                this.trace(128, "DevStateScalar.periodic(" + this.getName() + ") failed, got DevFailed when called fireValueChanged(devStateValue)", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.trace(128, "DevStateScalar.periodic(" + this.getName() + ") failed, got other Exception when called fireValueChanged(devStateValue)", l);
                System.out.println("DevStateScalar.periodic: Device.toString(extractState()) Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("DevStateScalar.periodic: Device.toString(extractState())------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
        ++this.changeCount;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(32, "DevStateScalar.change method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoChangeEvent.getValue();
            this.trace(32, "DevStateScalar.changeEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(32, "DevStateScalar.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "DevStateScalar.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(32, "DevStateScalar.changeEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(32, "DevStateScalar.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            System.out.println("DevStateScalar.change.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("DevStateScalar.change.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.trace(32, "DevStateScalar.change(" + this.getName() + ") setState(da) called", l);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.devStateValue = Device.toString(deviceAttribute.extractState());
                this.fireValueChanged(this.devStateValue);
                this.trace(32, "DevStateScalar.change(" + this.getName() + ") fireValueChanged(devStateValue) called", l);
            }
            catch (DevFailed devFailed) {
                this.trace(32, "DevStateScalar.change(" + this.getName() + ") failed, got DevFailed when called fireValueChanged(devStateValue)", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.trace(32, "DevStateScalar.change(" + this.getName() + ") failed, got other Exception when called fireValueChanged(devStateValue)", l);
                System.out.println("DevStateScalar.change: Device.toString(extractState()) Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("DevStateScalar.change: Device.toString(extractState())------------------------------------------------");
            }
        }
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    public String getVersion() {
        return "$Id: DevStateScalar.java,v 1.7 2005/12/02 15:41:03 jlpons Exp $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }
}

