/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IBooleanSpectrum;
import fr.esrf.tangoatk.core.IBooleanSpectrumListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.BooleanSpectrumHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class BooleanSpectrum
extends AAttribute
implements IBooleanSpectrum {
    BooleanSpectrumHelper spectrumHelper = new BooleanSpectrumHelper(this);
    boolean[] spectrumValue = null;

    public boolean[] getValue() {
        return this.spectrumValue;
    }

    public void setValue(boolean[] blArray) {
        try {
            this.attribute.insert(blArray);
            this.writeAtt();
            this.refresh();
        }
        catch (DevFailed devFailed) {
            this.setAttError("Couldn't set value", new AttributeSetException(devFailed));
        }
    }

    public void refresh() {
        DeviceAttribute deviceAttribute = null;
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                deviceAttribute = this.readValueFromNetwork();
                if (deviceAttribute == null) {
                    return;
                }
                this.spectrumValue = deviceAttribute.extractBooleanArray();
                this.fireValueChanged(this.spectrumValue);
            }
            catch (DevFailed devFailed) {
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
        }
        catch (Exception exception) {
            System.out.println("BooleanSpectrum.refresh() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("BooleanSpectrum.refresh()------------------------------------------------");
        }
    }

    public void dispatch(DeviceAttribute deviceAttribute) {
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                this.setState(deviceAttribute);
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.spectrumValue = deviceAttribute.extractBooleanArray();
                this.fireValueChanged(this.spectrumValue);
            }
            catch (DevFailed devFailed) {
                this.dispatchError(devFailed);
            }
        }
        catch (Exception exception) {
            System.out.println("BooleanSpectrum.dispatch() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("BooleanSpectrum.dispatch()------------------------------------------------");
        }
    }

    public void dispatchError(DevFailed devFailed) {
        this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
    }

    public boolean isWritable() {
        return super.isWritable();
    }

    protected void fireValueChanged(boolean[] blArray) {
        this.spectrumHelper.fireSpectrumValueChanged(blArray, this.timeStamp);
    }

    public void addBooleanSpectrumListener(IBooleanSpectrumListener iBooleanSpectrumListener) {
        this.spectrumHelper.addBooleanSpectrumListener(iBooleanSpectrumListener);
        this.addStateListener(iBooleanSpectrumListener);
    }

    public void removeBooleanSpectrumListener(IBooleanSpectrumListener iBooleanSpectrumListener) {
        this.spectrumHelper.removeBooleanSpectrumListener(iBooleanSpectrumListener);
        this.removeStateListener(iBooleanSpectrumListener);
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
        ++this.periodicCount;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(128, "BooleanSpectrum.periodic method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoPeriodicEvent.getValue();
            this.trace(128, "BooleanSpectrum.periodicEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(128, "BooleanSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "BooleanSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(128, "BooleanSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(128, "BooleanSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            System.out.println("BooleanSpectrum.periodic.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("BooleanSpectrum.periodic.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.spectrumValue = deviceAttribute.extractBooleanArray();
                this.fireValueChanged(this.spectrumValue);
            }
            catch (DevFailed devFailed) {
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                System.out.println("BooleanSpectrum.periodic.extractBooleanArray() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("BooleanSpectrum.periodic.extractBooleanArray()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
        ++this.changeCount;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(32, "BooleanSpectrum.change method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoChangeEvent.getValue();
            this.trace(32, "BooleanSpectrum.changeEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(32, "BooleanSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "BooleanSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(32, "BooleanSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(32, "BooleanSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            System.out.println("BooleanSpectrum.change.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("BooleanSpectrum.change.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.spectrumValue = deviceAttribute.extractBooleanArray();
                this.fireValueChanged(this.spectrumValue);
            }
            catch (DevFailed devFailed) {
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                System.out.println("BooleanSpectrum.change.extractBooleanArray() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("BooleanSpectrum.change.extractBooleanArray()------------------------------------------------");
            }
        }
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    public String getVersion() {
        return "$Id: BooleanSpectrum.java,v 1.4 2005/12/02 15:41:03 jlpons Exp $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }
}

