/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.BooleanScalarHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class BooleanScalar
extends AAttribute
implements IBooleanScalar {
    BooleanScalarHelper booleanHelper = new BooleanScalarHelper(this);
    boolean booleanValue = false;
    boolean setPointValue = false;

    public boolean getValue() {
        return this.booleanValue;
    }

    public void setValue(boolean bl) {
        try {
            this.attribute.insert(bl);
            this.writeAtt();
        }
        catch (DevFailed devFailed) {
            this.setAttError("Couldn't set value", new AttributeSetException(devFailed));
        }
        catch (Exception exception) {
            System.out.println("Received un exception other than DevFailed while setting a booleanScalar");
            this.setAttError("Couldn't set value", new AttributeSetException("Set Exception other than DevFailed."));
        }
    }

    public int getXDimension() {
        return 1;
    }

    public int getMaxXDimension() {
        return 1;
    }

    public void refresh() {
        DeviceAttribute deviceAttribute = null;
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                deviceAttribute = this.readValueFromNetwork();
                if (deviceAttribute == null) {
                    return;
                }
                this.booleanValue = deviceAttribute.extractBoolean();
                this.setPointValue = this.booleanHelper.getBooleanScalarSetPoint(deviceAttribute);
                this.fireValueChanged(this.booleanValue);
            }
            catch (DevFailed devFailed) {
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
        }
        catch (Exception exception) {
            System.out.println("BooleanScalar.refresh() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("BooleanScalar.refresh()------------------------------------------------");
        }
    }

    public void dispatch(DeviceAttribute deviceAttribute) {
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                this.setState(deviceAttribute);
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.booleanValue = deviceAttribute.extractBoolean();
                this.setPointValue = this.booleanHelper.getBooleanScalarSetPoint(deviceAttribute);
                this.fireValueChanged(this.booleanValue);
            }
            catch (DevFailed devFailed) {
                this.dispatchError(devFailed);
            }
        }
        catch (Exception exception) {
            System.out.println("BooleanScalar.dispatch() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("BooleanScalar.dispatch()------------------------------------------------");
        }
    }

    public void dispatchError(DevFailed devFailed) {
        this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
    }

    public boolean isWritable() {
        return super.isWritable();
    }

    protected void fireValueChanged(boolean bl) {
        this.booleanHelper.fireValueChanged(bl, this.timeStamp);
    }

    public void addBooleanScalarListener(IBooleanScalarListener iBooleanScalarListener) {
        this.booleanHelper.addBooleanScalarListener(iBooleanScalarListener);
        this.addStateListener(iBooleanScalarListener);
    }

    public void removeBooleanScalarListener(IBooleanScalarListener iBooleanScalarListener) {
        this.booleanHelper.removeBooleanScalarListener(iBooleanScalarListener);
        this.removeStateListener(iBooleanScalarListener);
    }

    public boolean getDeviceValue() {
        try {
            boolean bl;
            this.booleanValue = bl = this.readValueFromNetwork().extractBoolean();
        }
        catch (DevFailed devFailed) {
            this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
        }
        catch (Exception exception) {
            System.out.println("BooleanScalar.getBooleanDeviceValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("BooleanScalar.getBooleanDeviceValue()------------------------------------------------");
        }
        return this.booleanValue;
    }

    public boolean getSetPoint() {
        return this.setPointValue;
    }

    public boolean getDeviceSetPoint() {
        boolean bl = false;
        try {
            this.setPointValue = bl = this.booleanHelper.getBooleanScalarSetPoint(this.readDeviceValueFromNetwork());
        }
        catch (DevFailed devFailed) {
            this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
        }
        catch (Exception exception) {
            this.readAttError(exception.getMessage(), exception);
        }
        return bl;
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
        ++this.periodicCount;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(128, "BooleanScalar.periodic method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoPeriodicEvent.getValue();
            this.trace(128, "BooleanScalar.periodicEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(128, "BooleanScalar.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "BooleanScalar.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(128, "BooleanScalar.periodicEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(128, "BooleanScalar.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            System.out.println("BooleanScalar.periodic.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("BooleanScalar.periodic.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.booleanValue = deviceAttribute.extractBoolean();
                this.setPointValue = this.booleanHelper.getBooleanScalarSetPoint(deviceAttribute);
                this.fireValueChanged(this.booleanValue);
            }
            catch (DevFailed devFailed) {
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                System.out.println("BooleanScalar.periodic.extractBoolean() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("BooleanScalar.periodic.extractBoolean()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
        ++this.changeCount;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(32, "BooleanScalar.change method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoChangeEvent.getValue();
            this.trace(32, "BooleanScalar.changeEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(32, "BooleanScalar.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "BooleanScalar.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(32, "BooleanScalar.changeEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(32, "BooleanScalar.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            System.out.println("BooleanScalar.change.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("BooleanScalar.change.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.booleanValue = deviceAttribute.extractBoolean();
                this.setPointValue = this.booleanHelper.getBooleanScalarSetPoint(deviceAttribute);
                this.fireValueChanged(this.booleanValue);
            }
            catch (DevFailed devFailed) {
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                System.out.println("BooleanScalar.change.extractBoolean() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("BooleanScalar.change.extractBoolean()------------------------------------------------");
            }
        }
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    public String getVersion() {
        return "$Id: BooleanScalar.java,v 1.6 2005/12/02 15:41:03 jlpons Exp $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }
}

