//+======================================================================
// $Source: /cvsroot/tango-cs/tango/tools/pogo/appli/PrefGeneDialog.java,v $
//
// Project:   Tango
//
// Description:  java source code for the Pogo class definition .
//
// $Author: pascal_verdier $
//
// $Version$
//
// $Log: PrefGeneDialog.java,v $
// Revision 3.8  2005/06/14 08:48:39  pascal_verdier
// SuperClass is replaced by AbstractClass.
//
// Revision 3.7  2005/04/13 06:53:09  pascal_verdier
// spelling fault correction.
//
// Revision 3.6  2005/03/29 15:01:28  pascal_verdier
// Bug on change class name fixed.
//
// Revision 3.5  2005/03/11 14:15:36  pascal_verdier
// Abstract class management is not only in test mode.
//
// Revision 3.4  2005/03/02 14:01:54  pascal_verdier
// Managing Abstract Classes and inherited classes.
//
// Revision 3.3  2004/11/22 11:12:06  pascal_verdier
// First revision to generate a super class.
// User code managed in device_factory().
//
// Revision 3.2  2004/09/07 12:02:45  pascal_verdier
// Remove CVS log messages and info from templates.
//
// Revision 3.1  2004/08/26 07:25:35  pascal_verdier
// Attributes are now generated as class.
// Look and field changed.
//
// Revision 3.0  2003/04/29 10:42:14  pascal_verdier
// TANGO 3.0 compatibility
// little bugs fixed.
//
// Revision 1.33  2003/01/16 14:32:36  verdier
// Tango classe files detected for open JFileChooser.
//
// Revision 1.32  2002/10/03 13:54:27  verdier
// Pogo has been used without known bug.
// Put class description as class property.
//
// Revision 1.31  2002/04/25 12:05:08  verdier
// IDL 2 implemented for c++ servers
//
// Revision 1.30  2002/02/06 15:21:23  verdier
// Java code generation updated.
//
// Revision 1.26  2001/12/18 10:13:30  verdier
// Attribute user default property code added.
//
// Revision 1.25  2001/11/09 09:46:57  verdier
// Many bugs fixed.
//
// Revision 1.24  2001/04/04 12:22:58  verdier
// Property management added for cpp.
//
// Revision 1.23  2000/10/24 06:21:22  verdier
// The compatibility with TANGO2 has been tested on DatabaseDs.
//
// Revision 1.22  2000/10/02 05:52:20  verdier
// Attribute code generated is now compatible with Tango 2.
//
// Revision 1.21  2000/09/22 08:54:31  verdier
// DevState & DevStatus are virtual.
// First tests with Tango2
// Taco import utility added.
//
// Revision 1.20  2000/07/07 13:30:10  verdier
// Utilities added after first users.
//
// Revision 1.18  2000/06/20 06:57:35  verdier
// Right button double click management added for :
// editing src code, creating item, editing class....
// Little bugs fixed on generation/re-read src code.
//
// Revision 1.17  2000/05/12 07:37:10  verdier
//  Attributes management added for java generation.
//
// Revision 1.16  2000/04/26 06:04:00  verdier
// The save/restore file (.pogo) does not exist anymore.
// DevStates and DevStates allowed management is now available for java.
//
// Revision 1.15  2000/04/18 08:12:47  verdier
// Management of DevStates to allow command added.
//
// Revision 1.14  2000/04/12 09:25:43  verdier
// Methods to manage attributes are now generated
//  Only if at leat one attribute exists.
//
// Revision 1.13  2000/04/11 09:35:07  verdier
// Attributes management added.
//
//
// copyleft 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================
package pogo.appli;




import javax.swing.*;
import java.io.*;
import pogo.gene.*;


/**
 *	Dialog object to manage generation preferences.
 */

public class PrefGeneDialog extends javax.swing.JDialog implements PogoAppliDefs, PogoDefs {

  private static int returnStatus = PogoAppliDefs.RET_CANCEL;

//===================================================================
/**
 *	Initializes the Form
 */
//===================================================================
	public PrefGeneDialog(JFrame parent, int lang) {
		super (parent, true);
		initComponents ();

//		if (lang==javaLang || PogoUtil.is_test_mode()==false)
		if (lang==javaLang)
		{
			asAbstractClassBtn.setVisible(false);
			asDeviceServerBtn.setVisible(false);
		}

		pack ();

		PogoAppli.centerDialog(this, parent);
	}

//===================================================================
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
//===================================================================
        private void initComponents() {//GEN-BEGIN:initComponents
              jPanel1 = new javax.swing.JPanel();
              okBtn = new javax.swing.JButton();
              cancelBtn = new javax.swing.JButton();
              jPanel = new javax.swing.JPanel();
              nameLbl = new javax.swing.JLabel();
              jLabel5 = new javax.swing.JLabel();
              outPathText = new javax.swing.JTextField();
              jButton1 = new javax.swing.JButton();
              jLabel2 = new javax.swing.JLabel();
              asAbstractClassBtn = new javax.swing.JRadioButton();
              asDeviceServerBtn = new javax.swing.JRadioButton();
              
              setTitle("Generation Preference  Window");
              setBackground(new java.awt.Color(198, 178, 168));
              addWindowListener(new java.awt.event.WindowAdapter() {
                  public void windowClosing(java.awt.event.WindowEvent evt) {
                      closeDialog(evt);
                  }
              });
              
              jPanel1.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));
              
              okBtn.setText("OK");
              okBtn.addActionListener(new java.awt.event.ActionListener() {
                  public void actionPerformed(java.awt.event.ActionEvent evt) {
                      okBtnActionPerformed(evt);
                  }
              });
              
              jPanel1.add(okBtn);
              
              cancelBtn.setText("Cancel");
              cancelBtn.addActionListener(new java.awt.event.ActionListener() {
                  public void actionPerformed(java.awt.event.ActionEvent evt) {
                      cancelBtnActionPerformed(evt);
                  }
              });
              
              jPanel1.add(cancelBtn);
              
              getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);
              
              jPanel.setLayout(new java.awt.GridBagLayout());
              java.awt.GridBagConstraints gridBagConstraints1;
              
              nameLbl.setFont(new java.awt.Font("Arial", 1, 12));
              nameLbl.setText("  Output Path:    ");
              gridBagConstraints1 = new java.awt.GridBagConstraints();
              jPanel.add(nameLbl, gridBagConstraints1);
              
              jLabel5.setText("    ");
              gridBagConstraints1 = new java.awt.GridBagConstraints();
              gridBagConstraints1.gridx = 0;
              gridBagConstraints1.gridy = 5;
              jPanel.add(jLabel5, gridBagConstraints1);
              
              outPathText.setMinimumSize(new java.awt.Dimension(450, 25));
              outPathText.setPreferredSize(new java.awt.Dimension(450, 25));
              outPathText.addActionListener(new java.awt.event.ActionListener() {
                  public void actionPerformed(java.awt.event.ActionEvent evt) {
                      okBtnActionPerformed(evt);
                  }
              });
              
              gridBagConstraints1 = new java.awt.GridBagConstraints();
              gridBagConstraints1.gridx = 2;
              gridBagConstraints1.gridy = 0;
              jPanel.add(outPathText, gridBagConstraints1);
              
              jButton1.setText("Browse");
              jButton1.addActionListener(new java.awt.event.ActionListener() {
                  public void actionPerformed(java.awt.event.ActionEvent evt) {
                      browsActionPerformed(evt);
                  }
              });
              
              gridBagConstraints1 = new java.awt.GridBagConstraints();
              gridBagConstraints1.gridx = 3;
              gridBagConstraints1.gridy = 0;
              jPanel.add(jButton1, gridBagConstraints1);
              
              jLabel2.setText("    ");
              gridBagConstraints1 = new java.awt.GridBagConstraints();
              gridBagConstraints1.gridx = 0;
              gridBagConstraints1.gridy = 1;
              jPanel.add(jLabel2, gridBagConstraints1);
              
              asAbstractClassBtn.setText("As a Abstract Class");
              asAbstractClassBtn.addActionListener(new java.awt.event.ActionListener() {
                  public void actionPerformed(java.awt.event.ActionEvent evt) {
                      asAbstractClassBtnActionPerformed(evt);
                  }
              });
              
              gridBagConstraints1 = new java.awt.GridBagConstraints();
              gridBagConstraints1.gridy = 3;
              gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
              jPanel.add(asAbstractClassBtn, gridBagConstraints1);
              
              asDeviceServerBtn.setText("As a Device Server");
              asDeviceServerBtn.addActionListener(new java.awt.event.ActionListener() {
                  public void actionPerformed(java.awt.event.ActionEvent evt) {
                      asDeviceServerBtnActionPerformed(evt);
                  }
              });
              
              gridBagConstraints1 = new java.awt.GridBagConstraints();
              gridBagConstraints1.gridx = 0;
              gridBagConstraints1.gridy = 4;
              gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
              jPanel.add(asDeviceServerBtn, gridBagConstraints1);
              
              getContentPane().add(jPanel, java.awt.BorderLayout.NORTH);
            
        }//GEN-END:initComponents

//=============================================================
//=============================================================
	private void asDeviceServerBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_asDeviceServerBtnActionPerformed
		asAbstractClassBtn.setSelected(false);
		asDeviceServerBtn.setSelected(true);
	}//GEN-LAST:event_asDeviceServerBtnActionPerformed

//=============================================================
//=============================================================
	private void asAbstractClassBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_asAbstractClassBtnActionPerformed
		asAbstractClassBtn.setSelected(true);
		asDeviceServerBtn.setSelected(false);
	}//GEN-LAST:event_asAbstractClassBtnActionPerformed


//=============================================================
/**
 *	Open a File Chooser Dialog to select the new output directory.
 */
//=============================================================
  private void browsActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browsActionPerformed

	JFileChooser	chooser = new JFileChooser(outPathText.getText());
	chooser.addChoosableFileFilter(new PogoFileFilter("", "Directory"));
	chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
	int retval = chooser.showDialog(this, "Target Dir.");

	if (retval==JFileChooser.APPROVE_OPTION)
	{
		File  file = chooser.getSelectedFile();
		if (file!=null)
			if (file.isDirectory()==true)
      		{
				outPathText.setText(file.getAbsolutePath().toString());
			}
	}
	outPathText.requestFocus();
  }//GEN-LAST:event_browsActionPerformed



//=============================================================
//=============================================================
  private void cancelBtnActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelBtnActionPerformed
  doClose(PogoAppliDefs.RET_CANCEL);
  }//GEN-LAST:event_cancelBtnActionPerformed

//=============================================================
//=============================================================
  private void okBtnActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okBtnActionPerformed

	//	Check if path exists and if it exists, if it is a directory
	//----------------------------------------------------------------
    String path = new String(outPathText.getText());
	File file = new File(path);
	if (file.exists()==true)
		if (file.isDirectory()==true)
			doClose(PogoAppliDefs.RET_OK);
		else
		JOptionPane.showMessageDialog(this, 
								new String(path + " is not a directory !"),
								"Error Window",
								JOptionPane.ERROR_MESSAGE);
	else
		if (JOptionPane.showConfirmDialog(this, 
								new String(path + " Does not exists !\n\n"+
								"   Would you like to create it ? "),
								"Error Window",
								JOptionPane.ERROR_MESSAGE)==JOptionPane.OK_OPTION)
		{
			//	The try to create a new directory
			//------------------------------------------
			try{
				if (file.mkdir()==false)
					JOptionPane.showMessageDialog(this, 
								new String("Cannot create: " + path),
								"Error Window",
								JOptionPane.ERROR_MESSAGE);
				else
				{
					System.out.println(path + " created");
					doClose(PogoAppliDefs.RET_OK);
				}
			}
			catch(Exception e)
			{
				JOptionPane.showMessageDialog(this, 
								new String("Cannot create: " + path + "\n" + e),
								"Error Window",
								JOptionPane.ERROR_MESSAGE);
			}
		}
  }//GEN-LAST:event_okBtnActionPerformed

//=============================================================
/**
 *	Closes the dialog
 */
//=============================================================
	private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
		doClose(PogoAppliDefs.RET_CANCEL);
	}//GEN-LAST:event_closeDialog

//======================================================
//======================================================
  public int showDialog(String path, boolean is_abstractclass)
  {
     //  Initialize Window with input parameters
    //-----------------------------------------------
 	if (is_abstractclass)
	{
		asAbstractClassBtn.setSelected(true);
		asDeviceServerBtn.setSelected(false);
	}
	else
	{
		asAbstractClassBtn.setSelected(false);
		asDeviceServerBtn.setSelected(true);
	}

	outPathText.setText(path);
	outPathText.setRequestFocusEnabled(true);
	outPathText.requestFocus();
	setVisible(true);
	return returnStatus;
  }
//======================================================
//======================================================
  private void doClose(int retStatus)
  {
    returnStatus = retStatus;
    setVisible (false);
    dispose ();
  }

//======================================================
//======================================================
  public String  getOutputPath()
  {
    return new String(outPathText.getText());
  }
//======================================================
//======================================================
	public boolean getOutputModel()
	{
		return (asAbstractClassBtn.getSelectedObjects()!=null);
	}
  //======================================================


  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JPanel jPanel1;
  private javax.swing.JButton okBtn;
  private javax.swing.JButton cancelBtn;
  private javax.swing.JPanel jPanel;
  private javax.swing.JLabel nameLbl;
  private javax.swing.JLabel jLabel5;
  private javax.swing.JTextField outPathText;
  private javax.swing.JButton jButton1;
  private javax.swing.JLabel jLabel2;
  private javax.swing.JRadioButton asAbstractClassBtn;
  private javax.swing.JRadioButton asDeviceServerBtn;
  // End of variables declaration//GEN-END:variables


  public static void main(java.lang.String[] args) {
    new PrefGeneDialog (new JFrame (), 0).setVisible(true);
  }

}
