/*
 * EditDialog.java
 *
 * Created on October 27, 2003, 2:48 PM
 */

package pogo.appli;

import java.awt.*;
import java.util.*;
import javax.swing.*;
import pogo.gene.*;
import fr.esrf.Tango.*;


/**
 *
 * @author  verdier
 */
public class EditDialog extends javax.swing.JDialog {
	private int 	returnStatus = PogoAppliDefs.RET_CANCEL;
	private JFrame	parent;

//===================================================================
/**
 *	Creates new form EditDialog
 */
//===================================================================
	public EditDialog(JFrame parent, String text) {
		super(parent, true);
		this.parent = parent;
		initComponents();
		
		PogoString	pgs = new PogoString(text);
		while (pgs.indexOf("\\n")>=0)
			pgs.replace("\\n", "\n");
		editText.setText(pgs.str);
		pack();
		PogoAppli.centerDialog(this, parent);
	}

//===================================================================
/** This method is called from within the constructor to
 * initialize the form.
 * WARNING: Do NOT modify this code. The content of this method is
 * always regenerated by the Form Editor.
 */
 //===================================================================
        private void initComponents() {//GEN-BEGIN:initComponents
              jPanel1 = new javax.swing.JPanel();
              okBtn = new javax.swing.JButton();
              cancelBtn = new javax.swing.JButton();
              jScrollPane1 = new javax.swing.JScrollPane();
              editText = new javax.swing.JTextArea();
              
              addWindowListener(new java.awt.event.WindowAdapter() {
                  public void windowClosing(java.awt.event.WindowEvent evt) {
                      closeDialog(evt);
                  }
              });
              
              okBtn.setText("OK");
              okBtn.addActionListener(new java.awt.event.ActionListener() {
                  public void actionPerformed(java.awt.event.ActionEvent evt) {
                      okBtnActionPerformed(evt);
                  }
              });
              
              jPanel1.add(okBtn);
              
              cancelBtn.setText("Cancel");
              cancelBtn.addActionListener(new java.awt.event.ActionListener() {
                  public void actionPerformed(java.awt.event.ActionEvent evt) {
                      cancelBtnActionPerformed(evt);
                  }
              });
              
              jPanel1.add(cancelBtn);
              
              getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);
              
              jScrollPane1.setPreferredSize(new java.awt.Dimension(500, 150));
              jScrollPane1.setViewportView(editText);
              
              getContentPane().add(jScrollPane1, java.awt.BorderLayout.CENTER);
            
            pack();
        }//GEN-END:initComponents

//===================================================================
//===================================================================
    private void okBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okBtnActionPerformed
		doClose(PogoAppliDefs.RET_OK);
    }//GEN-LAST:event_okBtnActionPerformed

//===================================================================
//===================================================================
    private void cancelBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelBtnActionPerformed
		doClose(PogoAppliDefs.RET_CANCEL);
    }//GEN-LAST:event_cancelBtnActionPerformed

//===================================================================
//===================================================================
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
		doClose(PogoAppliDefs.RET_CANCEL);
    }//GEN-LAST:event_closeDialog
//===================================================================
/**
 *	Closes the dialog
 */
//===================================================================
	private void doClose(int retStatus)
	{
		returnStatus = retStatus;
		setVisible(false);
		dispose();
	}
//===================================================================
//===================================================================
	public String getText()
	{
		PogoString	pgs = new PogoString(editText.getText());
		while (pgs.indexOf("\n")>=0)
			pgs.replace("\n", "\\n");
		return pgs.str;
	}
//===================================================================
//===================================================================
  public int showDialog()
  {
	PogoAppli.centerDialog(this, parent);
	setVisible(true);
	return returnStatus;
  }
//===================================================================
//===================================================================


//===================================================================
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JPanel jPanel1;
  private javax.swing.JButton okBtn;
  private javax.swing.JButton cancelBtn;
  private javax.swing.JScrollPane jScrollPane1;
  private javax.swing.JTextArea editText;
  // End of variables declaration//GEN-END:variables
//===================================================================

}
