/*
 * DeviceFinder.java
 *
 * Created on June 18, 2002, 10:28 AM
 */

package fr.esrf.tangoatk.widget.util;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import java.util.*;
/**
 *
 * @author  root
 */
public class DeviceFinder extends javax.swing.JPanel {
    Domain[] domains = new Domain[0];

    String deviceName = null;
    JDialog parent;
    DefaultMutableTreeNode top;

    public DeviceFinder(JDialog dialog) {
	this();
	parent = dialog;
    }
    /** Creates new form DeviceFinder */
    public DeviceFinder() {

	top = new DefaultMutableTreeNode("Devices");	
	try {
	    Database db = new Database();
	    String[] dms = db.get_device_domain("*");
	    addDomains(top, db, dms);
	} catch (Exception e) {
	    
	} // end of try-catch

        initComponents();
	deviceTree.addTreeSelectionListener(new TreeSelectionListener() {
		public void valueChanged(TreeSelectionEvent e) {
		    DefaultMutableTreeNode n = (DefaultMutableTreeNode)
			deviceTree.getLastSelectedPathComponent();
		    
		    Object nodeInfo = n.getUserObject();
		    if (n == null ||
			!(nodeInfo instanceof ANode))
			return;
		    inputField.setText(((ANode)nodeInfo).getName());
		}

	    });

    }

    private void addDomains(DefaultMutableTreeNode top, Database db,
			    String[] dms) throws DevFailed {
        DefaultMutableTreeNode domainNode = null;
	domains = new Domain[dms.length];
	for (int i = 0; i < dms.length; i++) {
	    String d = dms[i];
	    Domain domain = new Domain(d, db);
	    domainNode = new DefaultMutableTreeNode(domain); 
	    String[] families = db.get_device_family(d + "/*");
	    domain.setNode(domainNode);
	    domains[i] = domain;
	    initialAddFamilies(domainNode, db, domain, families);
	    top.add(domainNode);
	} // end of for ()
    }

    private void initialAddFamilies(DefaultMutableTreeNode top, Database db,
				    Domain domain, String [] fms) throws DevFailed {
	DefaultMutableTreeNode familyNode = null;
	for (int i = 0; i < fms.length; i++) {
	    String f = fms[i];
	    String []members = db.get_device_member(domain.getName() +
						     f + "/*");
	    Family family = new Family(domain, f, db);
	    familyNode = new DefaultMutableTreeNode(family);
	    family.setNode(familyNode);
	    domain.addFamily(family);
	    initialAddMembers(familyNode, db, family, members);
	    top.add(familyNode);
	} // end of for ()
    }

    private void initialAddMembers(DefaultMutableTreeNode top, Database db,
				   Family family,
				   String [] members) throws DevFailed {

	DefaultMutableTreeNode memberNode = null;
	for (int i = 0; i < members.length; i++) {
	    String m = members[i];
	    Member member = new Member(family, m, db);
	    memberNode = new DefaultMutableTreeNode(member);
	    family.addMember(member);
	    member.setNode(memberNode);
	    top.add(memberNode);
	} // end of for ()
    }

    private void openPath(DefaultMutableTreeNode node) {
	TreePath tp = new TreePath(node.getPath());
	deviceTree.getSelectionModel().setSelectionPath(tp);
	deviceTree.expandPath(tp);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
          label = new javax.swing.JLabel();
          inputField = new javax.swing.JTextField();
          jScrollPane1 = new javax.swing.JScrollPane();
          deviceTree = new javax.swing.JTree(top);
          ok = new javax.swing.JButton();
          cancel = new javax.swing.JButton();
          
          setLayout(new java.awt.GridBagLayout());
          java.awt.GridBagConstraints gridBagConstraints1;
          
          label.setFont(new java.awt.Font("Dialog", 0, 12));
          label.setText("Device");
          gridBagConstraints1 = new java.awt.GridBagConstraints();
          gridBagConstraints1.gridx = 0;
          gridBagConstraints1.gridy = 1;
          gridBagConstraints1.insets = new java.awt.Insets(0, 10, 9, 5);
          add(label, gridBagConstraints1);
          
          inputField.setColumns(40);
          inputField.addKeyListener(new java.awt.event.KeyAdapter() {
              public void keyTyped(java.awt.event.KeyEvent evt) {
                  inputFieldKeyTyped(evt);
              }
          });
          
          gridBagConstraints1 = new java.awt.GridBagConstraints();
          gridBagConstraints1.gridx = 1;
          gridBagConstraints1.gridy = 1;
          gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
          gridBagConstraints1.insets = new java.awt.Insets(0, 5, 10, 10);
          gridBagConstraints1.weightx = 0.1;
          add(inputField, gridBagConstraints1);
          
          jScrollPane1.setViewportView(deviceTree);
          
          gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.insets = new java.awt.Insets(5, 10, 0, 10);
        gridBagConstraints1.weightx = 0.1;
        gridBagConstraints1.weighty = 0.1;
        add(jScrollPane1, gridBagConstraints1);
        
        ok.setFont(new java.awt.Font("Dialog", 0, 12));
        ok.setText("OK");
        ok.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okActionPerformed(evt);
            }
        });
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new java.awt.Insets(0, 5, 9, 10);
        add(ok, gridBagConstraints1);
        
        cancel.setFont(new java.awt.Font("Dialog", 0, 12));
        cancel.setText("Cancel");
        cancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelActionPerformed(evt);
            }
        });
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new java.awt.Insets(0, 0, 9, 0);
        add(cancel, gridBagConstraints1);
        
    }//GEN-END:initComponents

    private void okActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okActionPerformed
        // Add your handling code here:
	if (parent != null) {
	    parent.dispose();
	}
	
	deviceName = inputField.getText();
	
    }//GEN-LAST:event_okActionPerformed

    private void cancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelActionPerformed
        // Add your handling code here:
	if (parent != null) {
	    parent.dispose();
	}
	
	deviceName = null;
    }//GEN-LAST:event_cancelActionPerformed

    synchronized private void inputFieldKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_inputFieldKeyTyped
        // Add your handling code here:

	if (Character.isISOControl(evt.getKeyChar()))
	    return;
	inputField.setEditable(false);
	String tmp = inputField.getText() + evt.getKeyChar();

	Domain domain = null;
	Family family = null;
	Member member = null;
	
	String domainName = tmp, familyName = null, memberName = null;
	Object [] path;
	DefaultMutableTreeNode node;

	if (tmp.indexOf('/') != -1) {
	    try {
		domainName = tmp.substring(0, tmp.indexOf('/'));
	    } catch (Exception e) {

	    } // end of try-catch

	    try {
		String fm = tmp.substring(tmp.indexOf('/') + 1,
					 tmp.length());
		familyName = fm;

		familyName = fm.substring(0, fm.indexOf('/')); 

		memberName = fm.substring(fm.indexOf('/') + 1, fm.length());
	    } catch (Exception e) {
		    
	    } // end of try-catch
	}

	domain = findDomain(domainName);
	if (domain != null) {
	    evt.consume();
	    family = domain.findFamily(familyName);
	    if (family != null) {
		member = family.findMember(memberName);
		if (member != null) {
		    node = member.getNode();
		    tmp = member.getName();
		} else {
		    node = family.getNode();
		    tmp = family.getName() +
			(memberName == null ? "" : memberName);

		    
		} // end of else
	    } else {
		node = domain.getNode();
		tmp = domain.getName() +
		    (familyName == null ? "" : familyName);
	    } // end of else
	    openPath(node);
	    inputField.setText(tmp);
	} 


	inputField.setEditable(true);

	
    }//GEN-LAST:event_inputFieldKeyTyped


    Domain findDomain(String name) {
	if (domains.length == 1) return domains[0];
	int found = 0;
	Domain d = null;
	   
	for (int i = 0; i < domains.length; i++) 
	    if (domains[i].toString().startsWith(name)) {
		d = domains[i];
		found++;
	    }
	if (found == 1) return d;

	return null;
    }

    public String getDevice() {
	return deviceName;
    }

    public static String getDeviceName() {
	JDialog f = new JDialog();
	DeviceFinder finder = new DeviceFinder(f);
	f.setContentPane(finder);
	f.pack();
	f.setModal(true);
	f.show();
	System.out.println("> " + finder.getDevice());
	return finder.getDevice();
    }
	
	
    public static void main (String[] args) {
	getDeviceName();
    } // end of main ()
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel label;
    private javax.swing.JTextField inputField;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTree deviceTree;
    private javax.swing.JButton ok;
    private javax.swing.JButton cancel;
    // End of variables declaration//GEN-END:variables

    abstract class ANode {
	String name;
	DefaultMutableTreeNode node;
	Database database;
	
	public abstract String getName();

	public void setNode(DefaultMutableTreeNode node) {
	    this.node = node;

	}

	public DefaultMutableTreeNode getNode() {
	    return node;
	}

	public String toString() {
	    return name;
	}
	
    }

    class Domain extends  ANode{
	List families = new Vector();

	Domain(String name, Database database) {
	    this.name = name;
	    this.database = database;
	}

	Family findFamily(String familyName) {
	    if (families.size() == 1) 
		return (Family)families.get(0);

	    if (familyName == null) return null;

	    int found = 0;
	    Family family = null;
	    for (int i = 0; i < families.size(); i++) {
		Family f  = (Family)families.get(i);
		System.out.println(f + " = " + familyName);
		if (f.toString().startsWith(familyName)) {
		    family = f;
		    found++;
		}
		
	    } // end of for ()
	    if (found == 1) return family;

	    return null;
	}


	public String getName() {
	    return name + "/";
	}
	
	public void addFamily(Family f) {
	    families.add(f);
	}

	public List getFamilies() {
	    return families;
	}
    }

    class Family extends ANode {

	Domain domain;
	Database database;
	List members = new Vector();
	DefaultMutableTreeNode node;
	Family(Domain domain, String name,
	       Database database) {
	    this.name = name;
	    this.domain = domain;
	    this.database = database;
	}

	public String getName() {
	    return domain + "/" + name + "/";
	}

	public List getMembers() {
	    return members;
	}
	
	public void addMember(Member m) {
	    members.add(m);
	}

	Member findMember(String memberName) {
	    if (members.size() == 1) 
		return (Member)members.get(0);

	    if (memberName == null) return null;

	    int found = 0;
	    Member member = null;
	    for (int i = 0; i < members.size(); i++) {
		Member f  = (Member)members.get(i);
		if (f.toString().startsWith(memberName)) {
		    member = f;
		    found++;
		}
		
	    } // end of for ()
	    if (found == 1) return member;

	    return null;
	}


    }

    class Member extends ANode {

	Family family;
	
	Member(Family family, String name, Database database) {
	    this.name = name;
	    this.database = database;
	    this.family = family;
	}

	public String getName() {
	    return family.getName() + name;

	}
    }

}
