/*
 * SimpleSynopticAppli.java
 *
 * Created on May 25, 2005
 */

package fr.esrf.tangoatk.widget.jdraw;

import java.io.*;
import java.util.*;
import fr.esrf.tangoatk.widget.jdraw.*;
import fr.esrf.tangoatk.widget.util.ErrorHistory;

/**
 *
 * @author  PONCET
 */
public class SimpleSynopticAppli extends javax.swing.JFrame {

    private  ErrorHistory        errorHistory;

    /** Creates new form SimpleSynopticAppli */
    public SimpleSynopticAppli()
    {
        errorHistory = new ErrorHistory();
        initComponents();
    }
    
    public SimpleSynopticAppli(String jdrawFullFileName)
    {
	this();  	
        try
        {
            tangoSynopHandler.setSynopticFileName(jdrawFullFileName);
            tangoSynopHandler.setToolTipMode(TangoSynopticHandler.TOOL_TIP_NAME);
	    tangoSynopHandler.setAutoZoom(true);
        }
        catch (FileNotFoundException  fnfEx)
        {
            javax.swing.JOptionPane.showMessageDialog(
             null, "Cannot find the synoptic file : " + jdrawFullFileName + ".\n"
                  + "Check the file name you entered;"
                  + " Application will abort ...\n"
                  + fnfEx,
                  "No such file",
                  javax.swing.JOptionPane.ERROR_MESSAGE);
            System.exit(-1);
        }
        catch (IllegalArgumentException  illEx)
        {
            javax.swing.JOptionPane.showMessageDialog(
             null, "Cannot parse the synoptic file : " + jdrawFullFileName + ".\n"
                  + "Check if the file is a Jdraw file."
                  + " Application will abort ...\n"
                  + illEx,
                  "Cannot parse the file",
                  javax.swing.JOptionPane.ERROR_MESSAGE);
            System.exit(-1);
        }
        catch (MissingResourceException  mrEx)
        {
            javax.swing.JOptionPane.showMessageDialog(
             null, "Cannot parse the synoptic file : " + jdrawFullFileName + ".\n"
                  + " Application will abort ...\n"
                  + mrEx,
                  "Cannot parse the file",
                  javax.swing.JOptionPane.ERROR_MESSAGE);
            System.exit(-1);
        }
        pack();
     }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        tangoSynopHandler = new fr.esrf.tangoatk.widget.jdraw.TangoSynopticHandler();
        jMenuBar1 = new javax.swing.JMenuBar();
        fileJMenu = new javax.swing.JMenu();
        quitJMenuItem = new javax.swing.JMenuItem();
        viewMenu = new javax.swing.JMenu();
        errHistMenuItem = new javax.swing.JMenuItem();
        diagtMenuItem = new javax.swing.JMenuItem();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jPanel1.setLayout(new java.awt.GridBagLayout());

        if (errorHistory != null)
        {
            try
            {
                tangoSynopHandler.setErrorHistoryWindow(errorHistory);
            }
            catch (Exception setErrwExcept)
            {
                System.out.println("Cannot set Error History Window");
            }
        }

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(tangoSynopHandler, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(jPanel1, gridBagConstraints);

        fileJMenu.setText("File");
        quitJMenuItem.setText("Quit");
        quitJMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                quitJMenuItemActionPerformed(evt);
            }
        });

        fileJMenu.add(quitJMenuItem);

        jMenuBar1.add(fileJMenu);

        viewMenu.setText("View");
	
        errHistMenuItem.setText("Error History ...");
        errHistMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                errHistMenuItemActionPerformed(evt);
            }
        });

        viewMenu.add(errHistMenuItem);

        diagtMenuItem.setText("Diagnostic ...");
        diagtMenuItem.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    fr.esrf.tangoatk.widget.util.ATKDiagnostic.showDiagnostic();
                }
            });

        viewMenu.add(diagtMenuItem);
        jMenuBar1.add(viewMenu);

        setJMenuBar(jMenuBar1);

        pack();
    }//GEN-END:initComponents

    private void errHistMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_errHistMenuItemActionPerformed
        // TODO add your handling code here:
	errorHistory.setVisible(true);        
    }//GEN-LAST:event_errHistMenuItemActionPerformed

    private void quitJMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_quitJMenuItemActionPerformed
        // TODO add your handling code here:
        System.exit(0);
    }//GEN-LAST:event_quitJMenuItemActionPerformed
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit(0);
    }//GEN-LAST:event_exitForm
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[])
    {
        String                   fullFileName=null;
        SimpleSynopticAppli      syApp=null;
	String                   arg0=null, arg1=null;
        
        if (args.length >= 2) // The synoptic file name and the directory are specified
        {
	   arg0 = args[0];
	   arg1 = args[1];
	   
	   if (arg0 == null)
	      fullFileName = arg1;
	   else
	      if (arg0.length() <= 0)
	         fullFileName = arg1;
	      else
	         fullFileName = arg0 + "/" + arg1;
        }
	else
	    if (args.length == 1) // Only the synoptic absolute file name is specified
            {
	       fullFileName = args[0];
	    }


        if (fullFileName == null)
        {
            javax.swing.JOptionPane.showMessageDialog(
             null, "No synoptic file is specified.\n\n"
	          + "Please specify either directory name and synoptic file name or the absolute synoptic file name.",
                  "Not enough parameters",
                  javax.swing.JOptionPane.ERROR_MESSAGE);
            System.exit(-1);
        }
	else
	{
	    syApp = new SimpleSynopticAppli(fullFileName);
            syApp.show();
	}

    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuItem errHistMenuItem;
    private javax.swing.JMenuItem diagtMenuItem;
    private javax.swing.JMenu fileJMenu;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JMenuItem quitJMenuItem;
    private fr.esrf.tangoatk.widget.jdraw.TangoSynopticHandler tangoSynopHandler;
    private javax.swing.JMenu viewMenu;
    // End of variables declaration//GEN-END:variables
    
}
