// File:          ATKNode.java
// Created:       2002-09-12 11:53:41, erik
// By:            <erik@assum.net>
// Time-stamp:    <2002-09-30 15:15:1, erik>
// 
// $Id: Node.java,v 1.1 2003/01/16 15:24:26 pons Exp $
// 
// Description:       
package fr.esrf.tangoatk.widget.dnd;
import java.awt.dnd.*;
import java.awt.datatransfer.*;
import fr.esrf.tangoatk.core.*;

public abstract class Node implements Transferable {
    Object value;
    
    public DataFlavor[] getTransferDataFlavors() {
	String [] mimeTypes = getMimeTypes();
	DataFlavor[] ret = new DataFlavor[mimeTypes.length];

	try {	
	    for (int i = 0; i < mimeTypes.length; i++) {
		ret[i] = new DataFlavor(mimeTypes[i]);
	    }

	} catch (ClassNotFoundException e) {
	    System.out.println(e);
	    return null;
	}
	return ret;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
	return true;
    }


    public Object getTransferData(DataFlavor f) {
	if (value instanceof IEntity) {
	    return ((IEntity)value).getName();
	}

	if (value instanceof IDevice) {
	    return ((IDevice)value).getName();
	}
	return value.toString();
    }

    public String getFQName() {
	if (value instanceof IEntity) {
	    return ((IEntity)value).getName();
	}
	if (value instanceof IDevice) {
	    return ((IDevice)value).getName();
	}
	return value.toString();
    }
    
    protected String[] getMimeTypes() {
	String types[] = new String [0];
	return types;
    }

    public String toString() {
	return value.toString();
    }

    public String getName() {
	if (value instanceof IEntity) {
	    return ((IEntity)value).getNameSansDevice();
	}

	if (value instanceof IDevice) {
	    return ((IDevice)value).getName();
	}
	return value.toString();
    }
	
}
