/*
 * Status.java
 *
 * Created on December 14, 2001, 4:22 PM
 */

package fr.esrf.tangoatk.widget.device;

import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.IDeviceApplication;
import fr.esrf.tangoatk.core.StateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;

import fr.esrf.tangoatk.widget.util.*;


/**
 * <code>State</code>
 * State is a viewer to surveil the state of a
 * {@link fr.esrf.tangoatk.core.Device}. Normally one connects the
 * device with the viewer like this:<br>
 * <code>
 * Device device = getDevice(); // some method to obtain the device.
 * State = new State();
 * state.setModel(device);
 * </code>
 * @author <a href="mailto:assum@esrf.fr">Erik Assum</a>
 * @version $Revision: 1.5 $
 */
public class StateViewer extends javax.swing.JPanel
        implements fr.esrf.tangoatk.core.IStateListener {

  Device device;
  String state = "UNKNOWN";
  boolean externalSetText = false;
  boolean stateClickable = true;
  IDeviceApplication application;

  public StateViewer() {
    initComponents();
    UIManagerHelper.setAll("StateViewer.Label", textLabel);
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  private void initComponents() {//GEN-BEGIN:initComponents
    textLabel = new javax.swing.JLabel();
    valueLabel = new javax.swing.JLabel();

    setLayout(new java.awt.GridBagLayout());
    java.awt.GridBagConstraints gridBagConstraints1;

    textLabel.setText("Not Connected");
    textLabel.setFont(new java.awt.Font("Dialog", 0, 12));
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.gridx = 1;
    gridBagConstraints1.gridy = 0;
    gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints1.insets = new java.awt.Insets(0, 4, 0, 3);
    gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints1.weightx = 0.1;
    gridBagConstraints1.weighty = 0.1;
    add(textLabel, gridBagConstraints1);

    valueLabel.setBackground(java.awt.Color.red);
    valueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
    valueLabel.setPreferredSize(new java.awt.Dimension(40, 14));
    valueLabel.setOpaque(true);
    valueLabel.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mouseClicked(java.awt.event.MouseEvent evt) {
        valueLabelMouseClicked(evt);
      }
    });

    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.gridx = 0;
    gridBagConstraints1.gridy = 0;
    gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints1.insets = new java.awt.Insets(0, 3, 0, 4);
    gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints1.weightx = 0.2;
    gridBagConstraints1.weighty = 0.2;
    add(valueLabel, gridBagConstraints1);

  }//GEN-END:initComponents

  private void valueLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_valueLabelMouseClicked
    // Add your handling code here:
    if ((evt.getModifiers() &
            java.awt.event.InputEvent.BUTTON3_MASK) != 0) {
      if (application == null) return;
      application.setModel(device);
      application.run();
      return;
    }

    if (stateClickable && device != null) {
      popUp.setModel(device);
      popUp.setVisible(true);
    }

  }//GEN-LAST:event_valueLabelMouseClicked

  IDevicePopUp popUp = SingletonStatusViewer.getInstance();

  /**
   * Get the value of popUp.
   * @return value of popUp.
   */
  public IDevicePopUp getPopUp() {
    return popUp;
  }

  /**
   * Set the value of popUp.
   * @param v  Value to assign to popUp.
   */
  public void setPopUp(IDevicePopUp v) {
    this.popUp = v;
  }

  /**
   * <code>setModel</code> sets the model of this viewer.
   * If the textLabel property is not set, the name of the device is
   * shown on the textLabel.
   * @param device a <code>Device</code> to surveil
   */
  public void setModel(Device device) {
    this.device = device;
    device.addStateListener(this);
    setState(device.getState());
    if (!externalSetText)
      textLabel.setText(device.getName());

    valueLabel.setToolTipText(device.getName());
  }

  /**
   * <code>getModel</code> gets the model of this stateviewer.
   *
   * @return a <code>Device</code> value
   */
  public Device getModel() {
    return device;
  }

  /**
   * <code>setState</code>
   *
   * @param state a <code>String</code> value
   */
  public void setState(String state) {
    this.state = state;
    valueLabel.setBackground(ATKConstant.getColor4State(state));
  }

  /**
   * <code>getState</code>
   *
   * @return a <code>String</code> value presenting the state of the device
   */
  public String getState() {
    return state;
  }

  /**
   * <code>setLabel</code> set the text of the label. The
   * default value is to show the name of the device.
   * @param label a <code>String</code> value
   */
  public void setLabel(String label) {
    externalSetText = true;
    textLabel.setText(label);
  }

  public String getLabel() {
    return textLabel.getText();
  }

  /**
   * <code>setLabelVisisble</code> makes the label visible or not.
   *
   * @param visible a <code>boolean</code> value
   */
  public void setLabelVisible(boolean visible) {
    textLabel.setVisible(visible);
  }

  /**
   * <code>isLabelVisible</code> returns the visibility of the label
   *
   * @return a <code>boolean</code> value
   */
  public boolean isLabelVisible() {
    return textLabel.isVisible();
  }

  /**
   * <code>setStateVisible</code> makes the state visible or not.
   *
   * @param visible a <code>boolean</code> value
   */
  public void setStateVisible(boolean visible) {
    valueLabel.setVisible(visible);
  }

  /**
   * <code>isStateVisible</code> returns the visibility of the
   * state
   * @return a <code>boolean</code> value
   */
  public boolean isStateVisible() {
    return valueLabel.isVisible();
  }


  /**
   * <code>stateChange</code> inherited from IStateListener
   *
   * @param evt a <code>StateEvent</code> value
   */
  public void stateChange(StateEvent evt) {
    setState(evt.getState());
  }

  public void errorChange(ErrorEvent evt) {
    setState("UNKNOWN");

  }

  /**
   * <code>setStateText</code> sets the text on the colored state box
   *
   * @param text a <code>String</code> value
   */
  public void setStateText(String text) {
    valueLabel.setText(text);
  }

  /**
   * <code>getStateText</code> gets the text that is on the
   * colored state box
   * @return a <code>String</code> value
   */
  public String getStateText() {
    return valueLabel.getText();
  }


  public void setStateFont(java.awt.Font font) {
    valueLabel.setFont(font);
  }

  public void setFont(java.awt.Font font) {
    if (valueLabel != null) {
      valueLabel.setFont(font);
    }
    if (textLabel != null) {
      textLabel.setFont(font);
    }

    super.setFont(font);
  }

  public java.awt.Font getStateFont() {
    return valueLabel.getFont();
  }

  public void setStateForeground(java.awt.Color color) {
    valueLabel.setForeground(color);
  }


  public java.awt.Color getStateForeground() {
    return valueLabel.getForeground();
  }


  public void setForeground(java.awt.Color color) {
    if (valueLabel != null) {
      valueLabel.setForeground(color);
    }
    if (textLabel != null) {
      textLabel.setForeground(color);
    }
    super.setForeground(color);
  }


  /**
   * <code>setStateHorizontalAlignement</code>
   * @see javax.swing.SwingConstants
   * @param i an <code>int</code> value
   */
  public void setStateHorizontalAlignment(int i) {
    valueLabel.setHorizontalAlignment(i);
  }

  public int getStateHorizontalAlignment() {
    return valueLabel.getHorizontalAlignment();
  }

  public void setStatePreferredSize(java.awt.Dimension dimension) {
    valueLabel.setPreferredSize(dimension);
  }

  public java.awt.Dimension getStatePreferredSize() {
    return valueLabel.getPreferredSize();
  }

  public void setStateBorder(javax.swing.border.Border border) {
    if (valueLabel == null) return;

    valueLabel.setBorder(border);
  }

  public javax.swing.border.Border getStateBorder() {
    if (valueLabel == null) return null;

    return valueLabel.getBorder();
  }

  /**
   * <code>setStateClickable</code> will the state be clickable?
   *
   * @param clickable a <code>boolean</code> value
   */
  public void setStateClickable(boolean clickable) {
    stateClickable = clickable;
  }

  /**
   * <code>isStateClickable</code> returns if the state is clickable or not.
   *
   * @return a <code>boolean</code> value
   */
  public boolean isStateClickable() {
    return stateClickable;
  }

  public void setApplication(IDeviceApplication runnable) {
    application = runnable;
  }

  public IDeviceApplication getApplication() {
    return application;
  }

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JLabel textLabel;
  private javax.swing.JLabel valueLabel;
  // End of variables declaration//GEN-END:variables

}
